/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import quphoria.compactvoidminers.CompactVoidMiners;
import quphoria.compactvoidminers.collection.TagCollection;
import quphoria.compactvoidminers.config.Config;

public class TagCache {
    private static List<ResourceLocation> tags;
    private static Map<ResourceLocation, List<ResourceLocation>> itemTags;

    public static List<ResourceLocation> getTags() {
        return tags;
    }

    public static List<ResourceLocation> getItems(ResourceLocation tag) {
        return itemTags.get(tag);
    }

    public static void cache() {
        CompactVoidMiners.LOGGER.info("CACHING ITEM TAGS, LAG MAY ENSUE");
        Map tempTags = ItemTags.func_199903_a().func_241833_a();
        HashMap<ResourceLocation, List<ResourceLocation>> goodTags = new HashMap<ResourceLocation, List<ResourceLocation>>();
        Config.voidminer.parseItemWildcardBlacklist();
        for (ResourceLocation tag : tempTags.keySet()) {
            if (TagCollection.checkTagBlacklist(tag) || !TagCollection.isEnabledTagType(tag)) continue;
            ArrayList<ResourceLocation> goodItems = new ArrayList<ResourceLocation>();
            for (Item item : ((ITag)tempTags.get(tag)).func_230236_b_()) {
                if (TagCollection.checkItemBlacklist(item.getRegistryName()) || TagCollection.checkWildcardItemBlacklist(item.getRegistryName()) || item.getCreativeTabs().size() <= 0) continue;
                goodItems.add(item.getRegistryName());
            }
            if (goodItems.isEmpty()) continue;
            goodTags.put(tag, goodItems);
        }
        tags = Arrays.asList(goodTags.keySet().toArray(new ResourceLocation[0]));
        itemTags = goodTags;
        CompactVoidMiners.LOGGER.info("CACHING ITEM TAGS COMPLETE");
    }
}

