/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.stonecutter;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.stonecutter.StonecutterRecipeContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.stonecutter.StonecutterUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class StonecutterUpgradeContainer
extends UpgradeContainerBase<StonecutterUpgradeWrapper, StonecutterUpgradeContainer> {
    private static final String DATA_SHIFT_CLICK_INTO_BACKPACK = "shiftClickIntoBackpack";
    private final StonecutterRecipeContainer recipeContainer;

    public StonecutterUpgradeContainer(PlayerEntity player, int upgradeContainerId, StonecutterUpgradeWrapper upgradeWrapper, UpgradeContainerType<StonecutterUpgradeWrapper, StonecutterUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
        IWorldPosCallable worldPosCallable = player.field_70170_p.field_72995_K ? IWorldPosCallable.field_221489_a : IWorldPosCallable.func_221488_a((World)player.field_70170_p, (BlockPos)player.func_233580_cy_());
        this.recipeContainer = new StonecutterRecipeContainer(this, this.slots::add, this, worldPosCallable);
    }

    @Override
    public void handleMessage(CompoundNBT data) {
        if (data.func_74764_b(DATA_SHIFT_CLICK_INTO_BACKPACK)) {
            this.setShiftClickIntoBackpack(data.func_74767_n(DATA_SHIFT_CLICK_INTO_BACKPACK));
        } else {
            this.recipeContainer.handleMessage(data);
        }
    }

    public boolean shouldShiftClickIntoBackpack() {
        return ((StonecutterUpgradeWrapper)this.upgradeWrapper).shouldShiftClickIntoBackpack();
    }

    public void setShiftClickIntoBackpack(boolean shiftClickIntoBackpack) {
        ((StonecutterUpgradeWrapper)this.upgradeWrapper).setShiftClickIntoBackpack(shiftClickIntoBackpack);
        this.sendDataToServer(() -> NBTHelper.putBoolean(new CompoundNBT(), DATA_SHIFT_CLICK_INTO_BACKPACK, shiftClickIntoBackpack));
    }

    public StonecutterRecipeContainer getRecipeContainer() {
        return this.recipeContainer;
    }

    @Override
    public boolean mergeIntoBackpackFirst(Slot slot) {
        return this.recipeContainer.isNotResultSlot(slot) || this.shouldShiftClickIntoBackpack();
    }

    @Override
    public boolean allowsPickupAll(Slot slot) {
        return this.recipeContainer.isNotResultSlot(slot);
    }
}

