/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InventoryOrder;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.SubBackpacksHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.IItemHandlerSimpleInserter;

public class InceptionInventoryHandler
implements IItemHandlerSimpleInserter {
    private IItemHandlerModifiable combinedInventories;
    private final IItemHandlerSimpleInserter wrappedInventoryHandler;
    private final InventoryOrder inventoryOrder;
    private final SubBackpacksHandler subBackpacksHandler;
    private List<IItemHandlerSimpleInserter> handlers;

    public InceptionInventoryHandler(IItemHandlerSimpleInserter wrappedInventoryHandler, InventoryOrder inventoryOrder, SubBackpacksHandler subBackpacksHandler) {
        this.wrappedInventoryHandler = wrappedInventoryHandler;
        this.inventoryOrder = inventoryOrder;
        this.subBackpacksHandler = subBackpacksHandler;
        subBackpacksHandler.addRefreshListener(sbs -> this.refreshHandlerDelegate());
        this.refreshHandlerDelegate();
    }

    private void refreshHandlerDelegate() {
        this.handlers = new ArrayList<IItemHandlerSimpleInserter>();
        if (this.inventoryOrder == InventoryOrder.MAIN_FIRST) {
            this.handlers.add(this.wrappedInventoryHandler);
        }
        this.subBackpacksHandler.getSubBackpacks().forEach(sbp -> this.handlers.add(sbp.getInventoryForInputOutput()));
        if (this.inventoryOrder == InventoryOrder.INCEPTED_FIRST) {
            this.handlers.add(this.wrappedInventoryHandler);
        }
        this.combinedInventories = new CombinedInvWrapper(this.handlers.toArray(new IItemHandlerModifiable[0]));
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.combinedInventories.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.combinedInventories.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.combinedInventories.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.combinedInventories.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.combinedInventories.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.combinedInventories.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.combinedInventories.isItemValid(slot, stack);
    }

    @Override
    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        IItemHandlerSimpleInserter handler;
        ItemStack remainingStack = stack;
        Iterator<IItemHandlerSimpleInserter> iterator = this.handlers.iterator();
        while (iterator.hasNext() && !(remainingStack = (handler = iterator.next()).insertItem(remainingStack, simulate)).func_190926_b()) {
        }
        return remainingStack;
    }
}

