/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.turbine.simulation.modern;

import java.util.ArrayList;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.multiblocks.turbine.simulation.ITurbineBattery;
import net.roguelogix.biggerreactors.multiblocks.turbine.simulation.ITurbineFluidTank;
import net.roguelogix.biggerreactors.multiblocks.turbine.simulation.ITurbineSimulation;
import net.roguelogix.biggerreactors.multiblocks.turbine.simulation.modern.Battery;
import net.roguelogix.biggerreactors.multiblocks.turbine.simulation.modern.FluidTank;
import net.roguelogix.biggerreactors.multiblocks.turbine.state.VentState;
import net.roguelogix.biggerreactors.registries.TurbineCoilRegistry;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector4i;

public class ModernTurbineSimulation
implements ITurbineSimulation {
    private int x;
    private int y;
    private int z;
    private boolean active = false;
    private long coilSize;
    private double inductionEfficiency;
    private double inductorDragCoefficient;
    private double inductionEnergyExponentBonus;
    private double rotorCapacityPerRPM;
    private long maxFlowRate = -1L;
    private long maxMaxFlowRate = 0L;
    private int rotorShafts;
    private double rotorAxialMass;
    private double rotorMass;
    private double linearBladeMetersPerRevolution = 0.0;
    private VentState ventState = VentState.OVERFLOW;
    private boolean coilEngaged = true;
    private double rotorEnergy = 0.0;
    private final FluidTank fluidTank = new FluidTank();
    private final Battery battery = new Battery();
    private double energyGeneratedLastTick;
    private double rotorEfficiencyLastTick;

    @Override
    public void reset() {
        this.rotorEnergy = 0.0;
    }

    @Override
    public void resize(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.coilSize = 0L;
        this.inductionEfficiency = 0.0;
        this.inductorDragCoefficient = 0.0;
        this.inductionEnergyExponentBonus = 0.0;
        this.maxMaxFlowRate = ((long)x * (long)z - 1L) * Config.Turbine.Modern.FlowRatePerBlock;
    }

    @Override
    public void setRotorConfiguration(ArrayList<Vector4i> rotorConfiguration) {
        this.rotorMass = 0.0;
        this.linearBladeMetersPerRevolution = 0.0;
        for (Vector4i vector4i : rotorConfiguration) {
            this.linearBladeMetersPerRevolution += (double)this.rangeFromZeroSum(vector4i.x);
            this.linearBladeMetersPerRevolution += (double)this.rangeFromZeroSum(vector4i.y);
            this.linearBladeMetersPerRevolution += (double)this.rangeFromZeroSum(vector4i.z);
            this.linearBladeMetersPerRevolution += (double)this.rangeFromZeroSum(vector4i.w);
            this.rotorMass += (double)(vector4i.x + vector4i.y + vector4i.z + vector4i.w);
        }
        this.rotorCapacityPerRPM = this.linearBladeMetersPerRevolution * Config.Turbine.Modern.FluidPerBladeLinerKilometre;
        this.rotorCapacityPerRPM /= 1000.0;
        this.rotorShafts = rotorConfiguration.size();
        this.rotorAxialMass = (double)this.rotorShafts * Config.Turbine.Modern.RotorAxialMassPerShaft;
        this.rotorAxialMass += this.linearBladeMetersPerRevolution * Config.Turbine.Modern.RotorAxialMassPerBlade;
        this.rotorCapacityPerRPM *= Math.PI * 2;
        this.rotorMass *= Config.Turbine.Modern.RotorAxialMassPerBlade;
        this.rotorMass += (double)this.rotorShafts * Config.Turbine.Modern.RotorAxialMassPerShaft;
        if (this.maxFlowRate == -1L) {
            this.setNominalFlowRate((long)(this.rotorCapacityPerRPM * 1800.0));
        }
    }

    private long rangeFromZeroSum(long upper) {
        return (1L + upper) * upper / 2L;
    }

    @Override
    public void setCoilData(int x, int y, TurbineCoilRegistry.CoilData coilData) {
        this.inductionEfficiency += coilData.efficiency;
        this.inductionEnergyExponentBonus += coilData.bonus;
        double distance = Math.max(Math.abs(x), Math.abs(y));
        this.inductorDragCoefficient += coilData.extractionRate * this.layerMultiplier(distance);
        ++this.coilSize;
    }

    private double layerMultiplier(double distance) {
        if (distance < 1.0) {
            return 1.0;
        }
        return 2.0 / (distance + 1.0);
    }

    @Override
    public void updateInternalValues() {
        this.inductorDragCoefficient *= Config.Turbine.Modern.CoilDragMultiplier;
        this.battery.setCapacity((this.coilSize + 1L) * Config.Turbine.Modern.BatterySizePerCoilBlock);
        if (this.coilSize <= 0L) {
            this.inductionEfficiency = 0.0;
            this.inductorDragCoefficient = 0.0;
            this.inductionEnergyExponentBonus = 0.0;
        } else {
            this.inductionEfficiency = this.inductionEfficiency * 1.0 / (double)this.coilSize;
            this.inductionEnergyExponentBonus = Math.max(1.0, this.inductionEnergyExponentBonus / (double)this.coilSize);
            this.inductorDragCoefficient /= (double)this.coilSize;
        }
        this.fluidTank.perSideCapacity = ((long)this.x * (long)this.y * (long)this.z - ((long)this.rotorShafts + this.coilSize)) * Config.Turbine.Modern.TankVolumePerBlock;
    }

    @Override
    public void setVentState(VentState state) {
        this.ventState = state;
    }

    @Override
    public VentState ventState() {
        return this.ventState;
    }

    @Override
    public double RPM() {
        return this.rotorEnergy / this.rotorAxialMass;
    }

    @Override
    public double bladeEfficiencyLastTick() {
        return this.rotorEfficiencyLastTick;
    }

    @Override
    public long flowLastTick() {
        return this.fluidTank.transitionedLastTick();
    }

    @Override
    public long nominalFlowRate() {
        return this.maxFlowRate;
    }

    @Override
    public void setNominalFlowRate(long flowRate) {
        this.maxFlowRate = flowRate;
        this.maxFlowRate = Math.min(this.maxMaxFlowRate, Math.max(0L, flowRate));
    }

    @Override
    public long flowRateLimit() {
        return this.maxMaxFlowRate;
    }

    @Override
    public ITurbineBattery battery() {
        return this.battery;
    }

    @Override
    public ITurbineFluidTank fluidTank() {
        return this.fluidTank;
    }

    @Override
    public void tick() {
        double rpm = this.RPM();
        if (this.active) {
            double flowRate;
            double effectiveFlowRate = flowRate = (double)this.fluidTank.flow(this.maxFlowRate, this.ventState != VentState.CLOSED);
            double rotorCapacity = this.rotorCapacityPerRPM * Math.max(100.0, rpm);
            if (flowRate > rotorCapacity) {
                double excessFLow = flowRate - rotorCapacity;
                double excessEfficiency = rotorCapacity / flowRate;
                effectiveFlowRate = rotorCapacity + excessFLow * excessEfficiency;
            }
            this.rotorEfficiencyLastTick = flowRate != 0.0 ? effectiveFlowRate / flowRate : 0.0;
            if (effectiveFlowRate > 0.0) {
                this.rotorEnergy += this.fluidTank.activeTransition().latentHeat * effectiveFlowRate * this.fluidTank.activeTransition().turbineMultiplier;
            }
        } else {
            this.fluidTank.flow(0L, this.ventState != VentState.CLOSED);
            this.rotorEfficiencyLastTick = 0.0;
        }
        if (this.ventState == VentState.ALL) {
            this.fluidTank.dumpLiquid();
        }
        if (this.coilEngaged) {
            double inductionTorque = rpm * this.inductorDragCoefficient * (double)this.coilSize;
            double energyToGenerate = Math.pow(inductionTorque, this.inductionEnergyExponentBonus) * this.inductionEfficiency;
            double efficiency = 0.25 * Math.cos(rpm / 142.94246573833559) + 0.75;
            if (rpm < 450.0) {
                efficiency = Math.min(0.5, efficiency);
            }
            if (rpm > 2245.0) {
                efficiency = -rpm / 4490.0;
                efficiency += 1.0;
            }
            if (efficiency < 0.0) {
                efficiency = 0.0;
            }
            this.energyGeneratedLastTick = energyToGenerate *= efficiency;
            if (energyToGenerate > 1.0) {
                this.battery.generate((long)energyToGenerate);
            }
            this.rotorEnergy -= inductionTorque;
        } else {
            this.energyGeneratedLastTick = 0.0;
        }
        this.rotorEnergy -= this.rotorMass * Math.pow(rpm * Config.Turbine.Modern.FrictionDragMultiplier, 2.0);
        this.rotorEnergy -= this.linearBladeMetersPerRevolution * Math.pow(rpm * Config.Turbine.Modern.AerodynamicDragMultiplier, 2.0);
        if (this.rotorEnergy < 0.0) {
            this.rotorEnergy = 0.0;
        }
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean active() {
        return this.active;
    }

    @Override
    public void setCoilEngaged(boolean engaged) {
        this.coilEngaged = engaged;
    }

    @Override
    public boolean coilEngaged() {
        return this.coilEngaged;
    }

    @Override
    public long FEGeneratedLastTick() {
        return (long)this.energyGeneratedLastTick;
    }

    @Override
    public long bladeSurfaceArea() {
        return 0L;
    }

    @Override
    public double rotorMass() {
        return this.rotorAxialMass;
    }

    @Override
    public String debugString() {
        return "";
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("fluidTank", (INBT)this.fluidTank.serializeNBT());
        nbt.func_218657_a("battery", (INBT)this.battery.serializeNBT());
        nbt.func_74768_a("ventState", this.ventState.toInt());
        nbt.func_74780_a("rotorEnergy", this.rotorEnergy);
        nbt.func_74772_a("maxFlowRate", this.maxFlowRate);
        nbt.func_74757_a("coilEngaged", this.coilEngaged);
        nbt.func_74757_a("active", this.active);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.fluidTank.deserializeNBT(nbt.func_74775_l("fluidTank"));
        this.battery.deserializeNBT(nbt.func_74775_l("battery"));
        this.ventState = VentState.fromInt(nbt.func_74762_e("ventState"));
        this.rotorEnergy = nbt.func_74769_h("rotorEnergy");
        this.maxFlowRate = nbt.func_74763_f("maxFlowRate");
        this.coilEngaged = nbt.func_74767_n("coilEngaged");
        this.active = nbt.func_74767_n("active");
    }
}

