/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.turbine.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.roguelogix.biggerreactors.client.Biselector;
import net.roguelogix.biggerreactors.client.CommonRender;
import net.roguelogix.biggerreactors.client.SelectorColors;
import net.roguelogix.biggerreactors.client.Triselector;
import net.roguelogix.biggerreactors.multiblocks.turbine.containers.TurbineTerminalContainer;
import net.roguelogix.biggerreactors.multiblocks.turbine.state.TurbineActivity;
import net.roguelogix.biggerreactors.multiblocks.turbine.state.TurbineState;
import net.roguelogix.biggerreactors.multiblocks.turbine.state.VentState;
import net.roguelogix.phosphophyllite.gui.client.RenderHelper;
import net.roguelogix.phosphophyllite.gui.client.ScreenBase;
import net.roguelogix.phosphophyllite.gui.client.elements.AbstractElement;
import net.roguelogix.phosphophyllite.gui.client.elements.Button;
import net.roguelogix.phosphophyllite.gui.client.elements.Symbol;
import net.roguelogix.phosphophyllite.gui.client.elements.Tooltip;

public class TurbineTerminalScreen
extends ScreenBase<TurbineTerminalContainer> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("biggerreactors", "textures/screen/turbine_terminal.png");
    private TurbineState turbineState;
    private Fluid intakeFluid = Fluids.field_204541_a;
    private Fluid exhaustFluid = Fluids.field_204541_a;

    public TurbineTerminalScreen(TurbineTerminalContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.turbine_terminal"), DEFAULT_TEXTURE, 176, 152);
        this.turbineState = (TurbineState)((TurbineTerminalContainer)this.func_212873_a_()).getGuiPacket();
        this.intakeFluid = (Fluid)Registry.field_212619_h.func_82594_a(new ResourceLocation(this.turbineState.intakeResourceLocation));
        this.exhaustFluid = (Fluid)Registry.field_212619_h.func_82594_a(new ResourceLocation(this.turbineState.exhaustResourceLocation));
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.initTooltips();
        this.initControls();
        this.initGauges();
        this.initSymbols();
    }

    private void initTooltips() {
        this.addElement((AbstractElement)new Tooltip((ScreenBase)this, 8, 19, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.turbine_terminal.tachometer.tooltip")));
        Tooltip tachometerReadoutTooltip = new Tooltip((ScreenBase)this, 26, 19, 53, 16, StringTextComponent.field_240750_d_);
        tachometerReadoutTooltip.onTick = () -> {
            tachometerReadoutTooltip.tooltip = new StringTextComponent(String.format("%.3f RPM", this.turbineState.currentRPM));
        };
        this.addElement((AbstractElement)tachometerReadoutTooltip);
        this.addElement((AbstractElement)new Tooltip((ScreenBase)this, 8, 38, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.turbine_terminal.energy_generation_rate.tooltip")));
        Tooltip generationRateReadoutTooltip = new Tooltip((ScreenBase)this, 26, 38, 53, 16, StringTextComponent.field_240750_d_);
        generationRateReadoutTooltip.onTick = () -> {
            generationRateReadoutTooltip.tooltip = new StringTextComponent(String.format("%.3f RF/t", this.turbineState.turbineOutputRate));
        };
        this.addElement((AbstractElement)generationRateReadoutTooltip);
        this.addElement((AbstractElement)new Tooltip((ScreenBase)this, 8, 57, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.turbine_terminal.flow_rate_governor.tooltip")));
        Tooltip flowRateReadoutTooltip = new Tooltip((ScreenBase)this, 26, 57, 53, 16, StringTextComponent.field_240750_d_);
        flowRateReadoutTooltip.onTick = () -> {
            flowRateReadoutTooltip.tooltip = new StringTextComponent(String.format("%d mB/t", this.turbineState.flowRate));
        };
        this.addElement((AbstractElement)flowRateReadoutTooltip);
        this.addElement((AbstractElement)new Tooltip((ScreenBase)this, 8, 76, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.turbine_terminal.rotor_efficiency.tooltip")));
        Tooltip rotorEfficiencyReadoutTooltip = new Tooltip((ScreenBase)this, 26, 76, 53, 16, StringTextComponent.field_240750_d_);
        rotorEfficiencyReadoutTooltip.onTick = () -> {
            rotorEfficiencyReadoutTooltip.tooltip = new StringTextComponent(String.format("%.1f%%", this.turbineState.efficiencyRate * 100.0));
        };
        this.addElement((AbstractElement)rotorEfficiencyReadoutTooltip);
        this.addElement((AbstractElement)new Tooltip((ScreenBase)this, 86, 6, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.turbine_terminal.tachometer.tooltip")));
        this.addElement((AbstractElement)new Tooltip((ScreenBase)this, 152, 6, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.turbine_terminal.internal_battery.tooltip")));
    }

    private void initControls() {
        Biselector<TurbineTerminalContainer> activityToggle = new Biselector<TurbineTerminalContainer>(this, 8, 98, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.turbine_terminal.activity_toggle.tooltip"), () -> this.turbineState.turbineActivity.toInt(), SelectorColors.RED, SelectorColors.GREEN);
        activityToggle.onMouseReleased = (mX, mY, btn) -> {
            ((TurbineTerminalContainer)this.func_212873_a_()).executeRequest("setActive", activityToggle.getState() == 0 ? 1 : 0);
            return true;
        };
        this.addElement((AbstractElement)activityToggle);
        Biselector<TurbineTerminalContainer> coilEngageToggle = new Biselector<TurbineTerminalContainer>(this, 8, 114, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.turbine_terminal.coil_engage_toggle.tooltip"), () -> this.turbineState.coilStatus ? 1 : 0, SelectorColors.RED, SelectorColors.GREEN);
        coilEngageToggle.onMouseReleased = (mX, mY, btn) -> {
            ((TurbineTerminalContainer)this.func_212873_a_()).executeRequest("setCoilEngaged", coilEngageToggle.getState() == 0 ? 1 : 0);
            return true;
        };
        this.addElement((AbstractElement)coilEngageToggle);
        Triselector<TurbineTerminalContainer> ventStateToggle = new Triselector<TurbineTerminalContainer>(this, 8, 130, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.turbine_terminal.vent_state_toggle.tooltip"), () -> this.turbineState.ventState.toInt(), SelectorColors.YELLOW, SelectorColors.RED, SelectorColors.GREEN);
        ventStateToggle.onMouseReleased = (mX, mY, btn) -> {
            ((TurbineTerminalContainer)this.func_212873_a_()).executeRequest("setVentState", ventStateToggle.getState());
            return true;
        };
        this.addElement((AbstractElement)ventStateToggle);
        Button flowRateIncreaseButton = new Button((ScreenBase)this, 153, 92, 14, 15, 226, 0, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.turbine_terminal.flow_rate_increase.tooltip"));
        flowRateIncreaseButton.onMouseReleased = (mX, mY, btn) -> {
            if (flowRateIncreaseButton.func_231047_b_(mX, mY)) {
                long delta = Screen.func_231173_s_() && Screen.func_231172_r_() ? 100L : (Screen.func_231172_r_() ? 50L : (Screen.func_231173_s_() ? 10L : 1L));
                ((TurbineTerminalContainer)this.func_212873_a_()).executeRequest("changeFlowRate", delta);
                flowRateIncreaseButton.playSound(SoundEvents.field_187909_gi);
                return true;
            }
            return false;
        };
        flowRateIncreaseButton.onRender = (mS, mX, mY) -> {
            if (flowRateIncreaseButton.func_231047_b_((double)mX, (double)mY)) {
                flowRateIncreaseButton.blit(mS, 242, 0);
            } else {
                flowRateIncreaseButton.blit(mS, 228, 0);
            }
        };
        this.addElement((AbstractElement)flowRateIncreaseButton);
        Button flowRateDecreaseButton = new Button((ScreenBase)this, 153, 108, 14, 15, 226, 0, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.turbine_terminal.flow_rate_decrease.tooltip"));
        flowRateDecreaseButton.onMouseReleased = (mX, mY, btn) -> {
            if (flowRateDecreaseButton.func_231047_b_(mX, mY)) {
                long delta = Screen.func_231173_s_() && Screen.func_231172_r_() ? -100L : (Screen.func_231172_r_() ? -50L : (Screen.func_231173_s_() ? -10L : -1L));
                ((TurbineTerminalContainer)this.func_212873_a_()).executeRequest("changeFlowRate", delta);
                flowRateDecreaseButton.playSound(SoundEvents.field_187909_gi);
                return true;
            }
            return false;
        };
        flowRateDecreaseButton.onRender = (mS, mX, mY) -> {
            if (flowRateDecreaseButton.func_231047_b_((double)mX, (double)mY)) {
                flowRateDecreaseButton.blit(mS, 242, 15);
            } else {
                flowRateDecreaseButton.blit(mS, 228, 15);
            }
        };
        this.addElement((AbstractElement)flowRateDecreaseButton);
    }

    private void initGauges() {
        Symbol tachometerGauge = new Symbol((ScreenBase)this, 85, 25, 18, 64, 0, 152, StringTextComponent.field_240750_d_);
        tachometerGauge.onRender = (mS, mX, mY) -> TurbineTerminalScreen.renderTachometerGauge(mS, (Symbol<TurbineTerminalContainer>)tachometerGauge, this.turbineState.currentRPM, this.turbineState.maxRPM);
        this.addElement((AbstractElement)tachometerGauge);
        Symbol intakeTank = new Symbol((ScreenBase)this, 107, 25, 18, 64, 0, 152, StringTextComponent.field_240750_d_);
        intakeTank.onRender = (mS, mX, mY) -> CommonRender.renderFluidGauge(mS, intakeTank, this.turbineState.intakeStored, this.turbineState.intakeCapacity, this.intakeFluid);
        this.addElement((AbstractElement)intakeTank);
        Symbol exhaustTank = new Symbol((ScreenBase)this, 129, 25, 18, 64, 0, 152, StringTextComponent.field_240750_d_);
        exhaustTank.onRender = (mS, mX, mY) -> CommonRender.renderFluidGauge(mS, exhaustTank, this.turbineState.exhaustStored, this.turbineState.exhaustCapacity, this.exhaustFluid);
        this.addElement((AbstractElement)exhaustTank);
        Symbol internalBattery = new Symbol((ScreenBase)this, 151, 25, 18, 64, 0, 152, StringTextComponent.field_240750_d_);
        internalBattery.onRender = (mS, mX, mY) -> CommonRender.renderEnergyGauge(mS, internalBattery, this.turbineState.energyStored, this.turbineState.energyCapacity);
        this.addElement((AbstractElement)internalBattery);
    }

    private void initSymbols() {
        Symbol intakeTankSymbol = new Symbol((ScreenBase)this, 108, 6, 16, 16, 54, 152, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.turbine_terminal.intake_tank.tooltip"));
        intakeTankSymbol.onRender = (mS, mX, mY) -> RenderHelper.drawMaskedFluid((MatrixStack)mS, (int)intakeTankSymbol.x, (int)intakeTankSymbol.y, (int)this.func_230927_p_(), (int)intakeTankSymbol.width, (int)intakeTankSymbol.height, (int)intakeTankSymbol.u, (int)intakeTankSymbol.v, (Fluid)this.intakeFluid);
        this.addElement((AbstractElement)intakeTankSymbol);
        Symbol exhaustTankSymbol = new Symbol((ScreenBase)this, 130, 6, 16, 16, 70, 152, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.turbine_terminal.exhaust_tank.tooltip"));
        exhaustTankSymbol.onRender = (mS, mX, mY) -> RenderHelper.drawMaskedFluid((MatrixStack)mS, (int)exhaustTankSymbol.x, (int)exhaustTankSymbol.y, (int)this.func_230927_p_(), (int)exhaustTankSymbol.width, (int)exhaustTankSymbol.height, (int)exhaustTankSymbol.u, (int)exhaustTankSymbol.v, (Fluid)this.exhaustFluid);
        this.addElement((AbstractElement)exhaustTankSymbol);
    }

    public void func_231023_e_() {
        this.turbineState = (TurbineState)((TurbineTerminalContainer)this.func_212873_a_()).getGuiPacket();
        super.func_231023_e_();
        if (!this.turbineState.intakeResourceLocation.equals(Objects.requireNonNull(this.intakeFluid.getRegistryName()).toString())) {
            this.intakeFluid = (Fluid)Registry.field_212619_h.func_82594_a(new ResourceLocation(this.turbineState.intakeResourceLocation));
        }
        if (!this.turbineState.exhaustResourceLocation.equals(Objects.requireNonNull(this.exhaustFluid.getRegistryName()).toString())) {
            this.exhaustFluid = (Fluid)Registry.field_212619_h.func_82594_a(new ResourceLocation(this.turbineState.exhaustResourceLocation));
        }
    }

    public static void renderTachometerGauge(@Nonnull MatrixStack mStack, @Nonnull Symbol<TurbineTerminalContainer> symbol, double currentRPM, double maxRPM) {
        if (currentRPM > 0.0 && maxRPM > 0.0) {
            int renderSize = (int)((double)symbol.height * currentRPM / maxRPM);
            symbol.blit(mStack, symbol.u + 36, symbol.v);
            symbol.blit(mStack, symbol.width, symbol.height - renderSize, symbol.u + 18, symbol.v);
        }
        symbol.blit(mStack);
        symbol.tooltip = new StringTextComponent(String.format("%.1f/%.1f RPM", currentRPM, maxRPM));
    }

    public void func_230430_a_(@Nonnull MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        this.getFont().func_238421_b_(mStack, RenderHelper.formatValue((double)this.turbineState.currentRPM, (int)1, (String)"RPM", (boolean)false), (float)(this.getGuiLeft() + 27), (float)(this.getGuiTop() + 23), 0x404040);
        this.getFont().func_238421_b_(mStack, RenderHelper.formatValue((double)this.turbineState.turbineOutputRate, (String)"RF/t"), (float)(this.getGuiLeft() + 27), (float)(this.getGuiTop() + 42), 0x404040);
        this.getFont().func_238421_b_(mStack, RenderHelper.formatValue((double)((double)this.turbineState.flowRate / 1000.0), (int)1, (String)"B/t", (boolean)true), (float)(this.getGuiLeft() + 27), (float)(this.getGuiTop() + 61), 0x404040);
        this.getFont().func_238421_b_(mStack, String.format("%.1f%%", this.turbineState.efficiencyRate * 100.0), (float)(this.getGuiLeft() + 27), (float)(this.getGuiTop() + 80), 0x404040);
        if (this.turbineState.turbineActivity == TurbineActivity.ACTIVE) {
            this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.turbine_terminal.activity_toggle.online").getString(), (float)(this.getGuiLeft() + 42), (float)(this.getGuiTop() + 102), 0x404040);
        } else {
            this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.turbine_terminal.activity_toggle.offline").getString(), (float)(this.getGuiLeft() + 42), (float)(this.getGuiTop() + 102), 0x404040);
        }
        if (this.turbineState.coilStatus) {
            this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.turbine_terminal.coil_engage_toggle.engaged").getString(), (float)(this.getGuiLeft() + 42), (float)(this.getGuiTop() + 118), 0x404040);
        } else {
            this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.turbine_terminal.coil_engage_toggle.disengaged").getString(), (float)(this.getGuiLeft() + 42), (float)(this.getGuiTop() + 118), 0x404040);
        }
        if (this.turbineState.ventState == VentState.OVERFLOW) {
            this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.turbine_terminal.vent_state_toggle.overflow").getString(), (float)(this.getGuiLeft() + 58), (float)(this.getGuiTop() + 134), 0x404040);
        } else if (this.turbineState.ventState == VentState.ALL) {
            this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.turbine_terminal.vent_state_toggle.all").getString(), (float)(this.getGuiLeft() + 58), (float)(this.getGuiTop() + 134), 0x404040);
        } else {
            this.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.turbine_terminal.vent_state_toggle.closed").getString(), (float)(this.getGuiLeft() + 58), (float)(this.getGuiTop() + 134), 0x404040);
        }
    }
}

