/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.simulation.classic;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorFuelTank;

public class FuelTank
implements IReactorFuelTank {
    private long capacity;
    private long fuel = 0L;
    private long waste = 0L;
    private double partialUsed = 0.0;

    void burn(double amount) {
        if (Double.isInfinite(amount) || Double.isNaN(amount)) {
            return;
        }
        this.partialUsed += amount;
        if (this.partialUsed < 1.0) {
            return;
        }
        long toBurn = Math.min(this.fuel, (long)this.partialUsed);
        this.partialUsed -= (double)toBurn;
        if (toBurn <= 0L) {
            return;
        }
        this.fuel -= toBurn;
        this.waste += toBurn;
    }

    void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public long insertFuel(long amount, boolean simulated) {
        if (this.totalStored() >= this.capacity) {
            return 0L;
        }
        amount = Math.min(amount, this.capacity - this.totalStored());
        if (!simulated) {
            this.fuel += amount;
        }
        return amount;
    }

    @Override
    public long insertWaste(long amount, boolean simulated) {
        if (this.totalStored() >= this.capacity) {
            return 0L;
        }
        amount = Math.min(amount, this.capacity - this.totalStored());
        if (!simulated) {
            this.waste += amount;
        }
        return amount;
    }

    public long spaceAvailable() {
        return this.capacity() - this.totalStored();
    }

    @Override
    public long extractFuel(long toExtract, boolean simulated) {
        toExtract = Math.min(this.fuel, toExtract);
        if (!simulated) {
            this.fuel -= toExtract;
        }
        return toExtract;
    }

    @Override
    public long extractWaste(long toExtract, boolean simulated) {
        toExtract = Math.min(this.waste, toExtract);
        if (!simulated) {
            this.waste -= toExtract;
        }
        return toExtract;
    }

    @Override
    public long totalStored() {
        return this.fuel + this.waste;
    }

    @Override
    public long fuel() {
        return this.fuel;
    }

    @Override
    public long waste() {
        return this.waste;
    }

    @Nonnull
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74772_a("capacity", this.capacity);
        nbt.func_74772_a("fuel", this.fuel);
        nbt.func_74772_a("waste", this.waste);
        nbt.func_74780_a("partialUsed", this.partialUsed);
        return nbt;
    }

    public void deserializeNBT(@Nonnull CompoundNBT nbt) {
        if (nbt.func_74764_b("capacity")) {
            this.capacity = nbt.func_74763_f("capacity");
        }
        if (nbt.func_74764_b("fuel")) {
            this.fuel = nbt.func_74763_f("fuel");
        }
        if (nbt.func_74764_b("waste")) {
            this.waste = nbt.func_74763_f("waste");
        }
        if (nbt.func_74764_b("partialUsed")) {
            this.partialUsed = nbt.func_74769_h("partialUsed");
        }
    }
}

