/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.client.Biselector;
import net.roguelogix.biggerreactors.client.SelectorColors;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.ActiveReactorTerminalScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.PassiveReactorTerminalScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorTerminalContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorActivity;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorState;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorType;
import net.roguelogix.phosphophyllite.gui.client.RenderHelper;
import net.roguelogix.phosphophyllite.gui.client.ScreenBase;
import net.roguelogix.phosphophyllite.gui.client.elements.AbstractElement;
import net.roguelogix.phosphophyllite.gui.client.elements.Button;
import net.roguelogix.phosphophyllite.gui.client.elements.Symbol;
import net.roguelogix.phosphophyllite.gui.client.elements.Tooltip;

@OnlyIn(value=Dist.CLIENT)
public class CommonReactorTerminalScreen
extends ScreenBase<ReactorTerminalContainer> {
    private final ReactorState initialState = (ReactorState)((ReactorTerminalContainer)this.func_212873_a_()).getGuiPacket();

    public CommonReactorTerminalScreen(ReactorTerminalContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_terminal"), RenderHelper.getBlankTextureResource(), 176, 152);
    }

    public void func_231160_c_() {
        if (this.initialState.reactorType == ReactorType.ACTIVE) {
            this.getMinecraft().func_147108_a((Screen)new ActiveReactorTerminalScreen((ReactorTerminalContainer)this.field_147002_h, this.field_213127_e, this.field_230704_d_));
        } else {
            this.getMinecraft().func_147108_a((Screen)new PassiveReactorTerminalScreen((ReactorTerminalContainer)this.field_147002_h, this.field_213127_e, this.field_230704_d_));
        }
    }

    public static void initTooltips(@Nonnull ScreenBase<ReactorTerminalContainer> screen, ReactorState reactorState) {
        screen.addElement((AbstractElement)new Tooltip(screen, 8, 19, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_terminal.temperature.tooltip")));
        Tooltip temperatureReadoutTooltip = new Tooltip(screen, 26, 19, 53, 16, StringTextComponent.field_240750_d_);
        temperatureReadoutTooltip.onTick = () -> {
            temperatureReadoutTooltip.tooltip = new StringTextComponent(String.format("%.3f \u00b0C", reactorState.fuelHeatStored));
        };
        screen.addElement((AbstractElement)temperatureReadoutTooltip);
        screen.addElement((AbstractElement)new Tooltip(screen, 8, 57, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_terminal.fuel_usage_rate.tooltip")));
        Tooltip fuelConsumptionReadoutTooltip = new Tooltip(screen, 26, 57, 53, 16, StringTextComponent.field_240750_d_);
        fuelConsumptionReadoutTooltip.onTick = () -> {
            fuelConsumptionReadoutTooltip.tooltip = new StringTextComponent(String.format("%.3f mB/t", reactorState.fuelUsageRate));
        };
        screen.addElement((AbstractElement)fuelConsumptionReadoutTooltip);
        screen.addElement((AbstractElement)new Tooltip(screen, 8, 76, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_terminal.reactivity_rate.tooltip")));
        Tooltip reactivityRateTooltip = new Tooltip(screen, 26, 76, 53, 16, StringTextComponent.field_240750_d_);
        reactivityRateTooltip.onTick = () -> {
            reactivityRateTooltip.tooltip = new StringTextComponent(String.format("%.1f%%", reactorState.reactivityRate * 100.0));
        };
        screen.addElement((AbstractElement)reactivityRateTooltip);
        screen.addElement((AbstractElement)new Tooltip(screen, 86, 6, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_terminal.fuel_mix.tooltip")));
        screen.addElement((AbstractElement)new Tooltip(screen, 108, 6, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_terminal.case_heat.tooltip")));
        screen.addElement((AbstractElement)new Tooltip(screen, 130, 6, 16, 16, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_terminal.fuel_heat.tooltip")));
    }

    public static void initControls(@Nonnull ScreenBase<ReactorTerminalContainer> screen, ReactorState reactorState) {
        Biselector<ReactorTerminalContainer> activityToggle = new Biselector<ReactorTerminalContainer>(screen, 8, 98, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_terminal.activity_toggle.tooltip"), () -> reactorState.reactorActivity.toInt(), SelectorColors.RED, SelectorColors.GREEN);
        activityToggle.onMouseReleased = (mX, mY, btn) -> {
            ((ReactorTerminalContainer)screen.func_212873_a_()).executeRequest("setActive", activityToggle.getState() == 0 ? 1 : 0);
            return true;
        };
        screen.addElement(activityToggle);
        Biselector<ReactorTerminalContainer> autoEjectToggle = new Biselector<ReactorTerminalContainer>(screen, 8, 114, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_terminal.auto_eject_toggle.tooltip"), () -> reactorState.doAutoEject ? 1 : 0, SelectorColors.RED, SelectorColors.CYAN);
        autoEjectToggle.onMouseReleased = (mX, mY, btn) -> {
            ((ReactorTerminalContainer)screen.func_212873_a_()).executeRequest("setAutoEject", autoEjectToggle.getState() == 0 ? 1 : 0);
            return true;
        };
        screen.addElement(autoEjectToggle);
        Button manualEjectButton = new Button(screen, 8, 130, 15, 15, 226, 0, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_terminal.manual_eject.tooltip"));
        manualEjectButton.onMouseReleased = (mX, mY, btn) -> {
            if (manualEjectButton.func_231047_b_(mX, mY)) {
                Minecraft.func_71410_x().field_71439_g.func_71165_d("No effect. This button will be removed in the future.");
                Minecraft.func_71410_x().field_71439_g.func_71165_d("Use the access ports to eject waste!");
                manualEjectButton.playSound(SoundEvents.field_187909_gi);
                return true;
            }
            return false;
        };
        manualEjectButton.onRender = (mS, mX, mY) -> {
            if (manualEjectButton.func_231047_b_((double)mX, (double)mY)) {
                manualEjectButton.blit(mS, 241, 0);
            } else {
                manualEjectButton.blit(mS, 226, 0);
            }
        };
    }

    public static void initGauges(@Nonnull ScreenBase<ReactorTerminalContainer> screen, ReactorState reactorState) {
        Symbol fuelMixGauge = new Symbol(screen, 85, 25, 18, 64, 0, 152, StringTextComponent.field_240750_d_);
        fuelMixGauge.onRender = (mS, mX, mY) -> CommonReactorTerminalScreen.renderFuelMixGauge(mS, (Symbol<ReactorTerminalContainer>)fuelMixGauge, reactorState.wasteStored, reactorState.fuelStored, reactorState.fuelCapacity);
        screen.addElement((AbstractElement)fuelMixGauge);
        Symbol caseHeatGauge = new Symbol(screen, 107, 25, 18, 64, 0, 152, StringTextComponent.field_240750_d_);
        caseHeatGauge.onRender = (mS, mX, mY) -> CommonReactorTerminalScreen.renderHeatGauge(mS, (Symbol<ReactorTerminalContainer>)caseHeatGauge, reactorState.caseHeatStored, Config.Reactor.GUI.HeatDisplayMax);
        screen.addElement((AbstractElement)caseHeatGauge);
        Symbol fuelHeatGauge = new Symbol(screen, 129, 25, 18, 64, 0, 152, StringTextComponent.field_240750_d_);
        fuelHeatGauge.onRender = (mS, mX, mY) -> CommonReactorTerminalScreen.renderHeatGauge(mS, (Symbol<ReactorTerminalContainer>)fuelHeatGauge, reactorState.fuelHeatStored, Config.Reactor.GUI.HeatDisplayMax);
        screen.addElement((AbstractElement)fuelHeatGauge);
    }

    public static void initSymbols(@Nonnull ScreenBase<ReactorTerminalContainer> screen, ReactorState reactorState) {
    }

    public static void renderHeatGauge(@Nonnull MatrixStack mStack, @Nonnull Symbol<ReactorTerminalContainer> symbol, double heatStored, double heatCapacity) {
        if (heatStored > 0.0 && heatCapacity > 0.0) {
            int renderSize = (int)((double)symbol.height * heatStored / heatCapacity);
            symbol.blit(mStack, symbol.u + 72, symbol.v);
            symbol.blit(mStack, symbol.width, symbol.height - renderSize, symbol.u + 18, symbol.v);
        }
        symbol.blit(mStack);
        symbol.tooltip = new StringTextComponent(String.format("%.1f/%.1f \u00b0C", heatStored, heatCapacity));
    }

    public static void renderFuelMixGauge(@Nonnull MatrixStack mStack, @Nonnull Symbol<ReactorTerminalContainer> symbol, double wasteStored, double fuelStored, double fuelCapacity) {
        if ((wasteStored > 0.0 || fuelStored > 0.0) && fuelCapacity > 0.0) {
            int wasteRenderSize = (int)((double)symbol.height * wasteStored / fuelCapacity);
            int fuelRenderSize = (int)((double)symbol.height * fuelStored / fuelCapacity);
            symbol.blit(mStack, symbol.u + 54, symbol.v);
            symbol.blit(mStack, symbol.width, symbol.height - wasteRenderSize, symbol.u + 36, symbol.v);
            symbol.blit(mStack, symbol.width, symbol.height - (wasteRenderSize + fuelRenderSize), symbol.u + 18, symbol.v);
        }
        symbol.blit(mStack);
        symbol.tooltip = new StringTextComponent(String.format(new TranslationTextComponent("screen.biggerreactors.reactor_terminal.fuel_mix_gauge.tooltip").getString(), RenderHelper.formatValue((double)((fuelStored + wasteStored) / 1000.0), (String)"B", (boolean)true), RenderHelper.formatValue((double)(fuelCapacity / 1000.0), (String)"B", (boolean)true), RenderHelper.formatValue((double)(fuelStored / 1000.0), (String)"B", (boolean)true), RenderHelper.formatValue((double)(wasteStored / 1000.0), (String)"B", (boolean)true)));
    }

    public static void renderStatusText(@Nonnull MatrixStack mStack, @Nonnull ScreenBase<ReactorTerminalContainer> screen, ReactorActivity reactorActivity, boolean doAutoEject, double heatStored, double fuelUsageRate, double reactivityRate) {
        screen.getFont().func_238421_b_(mStack, String.format("%.0f \u00b0C", heatStored), (float)(screen.getGuiLeft() + 27), (float)(screen.getGuiTop() + 23), 0x404040);
        screen.getFont().func_238421_b_(mStack, RenderHelper.formatValue((double)(fuelUsageRate / 1000.0), (int)3, (String)"B/t", (boolean)true), (float)(screen.getGuiLeft() + 27), (float)(screen.getGuiTop() + 61), 0x404040);
        screen.getFont().func_238421_b_(mStack, String.format("%.1f%%", reactivityRate * 100.0), (float)(screen.getGuiLeft() + 27), (float)(screen.getGuiTop() + 80), 0x404040);
        if (reactorActivity == ReactorActivity.ACTIVE) {
            screen.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.reactor_terminal.activity_toggle.online").getString(), (float)(screen.getGuiLeft() + 42), (float)(screen.getGuiTop() + 102), 0x404040);
        } else {
            screen.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.reactor_terminal.activity_toggle.offline").getString(), (float)(screen.getGuiLeft() + 42), (float)(screen.getGuiTop() + 102), 0x404040);
        }
        if (doAutoEject) {
            screen.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.reactor_terminal.auto_eject_toggle.enabled").getString(), (float)(screen.getGuiLeft() + 42), (float)(screen.getGuiTop() + 118), 0x404040);
        } else {
            screen.getFont().func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.reactor_terminal.auto_eject_toggle.disabled").getString(), (float)(screen.getGuiLeft() + 42), (float)(screen.getGuiTop() + 118), 0x404040);
        }
    }
}

