/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.biggerreactors.BiggerReactors;
import net.roguelogix.biggerreactors.client.CommonRender;
import net.roguelogix.phosphophyllite.gui.client.RenderHelper;
import net.roguelogix.phosphophyllite.gui.client.ScreenBase;
import net.roguelogix.phosphophyllite.gui.client.elements.Button;

@OnlyIn(value=Dist.CLIENT)
public class TextBox<T extends Container>
extends Button<T> {
    private boolean focusEnable;
    private int cursorPos;
    private int selectionPos;
    private int cursorAnimationTime;
    private final int cursorAnimationTimeTotal;
    private final int charLimit;
    private final StringBuffer textBuffer;
    private final FontRenderer fontRenderer;

    public TextBox(@Nonnull ScreenBase<T> parent, @Nonnull FontRenderer fontRenderer, int x, int y, int width, int charLimit, String initialText) {
        super(parent, x, y, width, 16, 0, 158, null);
        this.textBuffer = new StringBuffer(initialText);
        this.fontRenderer = fontRenderer;
        this.selectionPos = this.cursorPos = this.textBuffer.length();
        this.charLimit = charLimit;
        this.cursorAnimationTime = 30;
        this.cursorAnimationTimeTotal = 60;
    }

    public String getContents() {
        if (this.textBuffer.length() > 0) {
            return this.textBuffer.toString();
        }
        return "";
    }

    public void render(@Nonnull MatrixStack mStack, int mouseX, int mouseY) {
        if (this.renderEnable) {
            ResourceLocation preservedResource = RenderHelper.getCurrentResource();
            RenderHelper.bindTexture((ResourceLocation)CommonRender.COMMON_RESOURCE_TEXTURE);
            this.blit(mStack, this.x, this.y, 0, 158, 3, 16);
            for (int i = 0; i <= this.width; i += 6) {
                this.blit(mStack, this.x + 3 + i, this.y, 6, 158, 6, 16);
            }
            this.blit(mStack, this.x + 6 + 6 * this.charLimit, this.y, 3, 158, 3, 16);
            this.fontRenderer.func_238405_a_(mStack, this.textBuffer.toString(), (float)(this.x + 3), (float)(this.y + 4), 0xFFFFFF);
            this.renderCursor();
            this.renderSelection();
            RenderHelper.clearRenderColor();
            RenderHelper.bindTexture((ResourceLocation)preservedResource);
            if (this.onRender != null) {
                this.onRender.trigger(mStack, mouseX, mouseY);
            }
        }
    }

    private void renderCursor() {
        ++this.cursorAnimationTime;
        if (this.cursorAnimationTime > this.cursorAnimationTimeTotal) {
            this.cursorAnimationTime = 0;
        }
        if (!this.focusEnable || !this.renderEnable || this.cursorAnimationTime < this.cursorAnimationTimeTotal / 2) {
            return;
        }
        int cursorRenderPos = this.x + 2;
        if (this.textBuffer.length() >= this.cursorPos) {
            cursorRenderPos = this.fontRenderer.func_78256_a(this.textBuffer.substring(0, this.cursorPos)) + (this.x + 2);
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderBuffer = tessellator.func_178180_c();
        RenderHelper.setRenderColor((float)255.0f, (float)255.0f, (float)255.0f, (float)255.0f);
        RenderSystem.disableTexture();
        renderBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        renderBuffer.func_225582_a_((double)(cursorRenderPos + 1), (double)(this.y + 3), 0.0).func_181675_d();
        renderBuffer.func_225582_a_((double)cursorRenderPos, (double)(this.y + 3), 0.0).func_181675_d();
        renderBuffer.func_225582_a_((double)cursorRenderPos, (double)(this.y + 13), 0.0).func_181675_d();
        renderBuffer.func_225582_a_((double)(cursorRenderPos + 1), (double)(this.y + 13), 0.0).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        RenderHelper.clearRenderColor();
    }

    private void renderSelection() {
        if (!this.renderEnable || this.cursorPos == this.selectionPos) {
            return;
        }
        int cursorRenderPos = this.x + 2;
        if (this.textBuffer.length() >= this.cursorPos) {
            cursorRenderPos = this.fontRenderer.func_78256_a(this.textBuffer.substring(0, this.cursorPos)) + (this.x + 2);
        }
        int selectionRenderPos = this.x + 2;
        if (this.textBuffer.length() >= this.selectionPos) {
            selectionRenderPos = this.fontRenderer.func_78256_a(this.textBuffer.substring(0, this.selectionPos)) + (this.x + 2);
        }
        int leftRenderPos = this.selectionPos > this.cursorPos ? cursorRenderPos : selectionRenderPos;
        int rightRenderPos = this.selectionPos > this.cursorPos ? selectionRenderPos : cursorRenderPos;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderBuffer = tessellator.func_178180_c();
        RenderHelper.setRenderColor((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        renderBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        renderBuffer.func_225582_a_((double)rightRenderPos, (double)(this.y + 2), 0.0).func_181675_d();
        renderBuffer.func_225582_a_((double)leftRenderPos, (double)(this.y + 2), 0.0).func_181675_d();
        renderBuffer.func_225582_a_((double)leftRenderPos, (double)(this.y + 14), 0.0).func_181675_d();
        renderBuffer.func_225582_a_((double)rightRenderPos, (double)(this.y + 14), 0.0).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
        RenderHelper.clearRenderColor();
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        int relativeX = this.parent.getGuiLeft() + this.x;
        int relativeY = this.parent.getGuiTop() + this.y;
        return mouseX > (double)relativeX && mouseX < (double)(relativeX + (this.width + 6)) && mouseY > (double)relativeY && mouseY < (double)(relativeY + this.height);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        this.cursorPos = this.selectionPos;
        this.focusEnable = this.func_231047_b_(mouseX, mouseY) && this.actionEnable;
        return this.focusEnable;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.actionEnable && this.focusEnable) {
            if (Screen.func_231170_j_((int)keyCode)) {
                this.cursorPos = this.textBuffer.length();
                this.selectionPos = 0;
                return true;
            }
            if (Screen.func_231169_i_((int)keyCode)) {
                this.parent.getMinecraft().field_195559_v.func_197960_a(this.getSelection());
                return true;
            }
            if (Screen.func_231166_g_((int)keyCode)) {
                this.parent.getMinecraft().field_195559_v.func_197960_a(this.getSelection());
                this.deleteSelection();
                return true;
            }
            if (Screen.func_231168_h_((int)keyCode)) {
                this.write(this.parent.getMinecraft().field_195559_v.func_197965_a());
                return true;
            }
            switch (keyCode) {
                case 256: {
                    return false;
                }
                case 259: {
                    this.deleteCharacter();
                    if (!Screen.func_231172_r_()) break;
                    this.deleteWord();
                    break;
                }
                case 263: {
                    this.shiftCursorLeft();
                    break;
                }
                case 262: {
                    this.shiftCursorRight();
                    break;
                }
                case 268: {
                    this.cursorPos = 0;
                    break;
                }
                case 269: {
                    this.cursorPos = this.textBuffer.length();
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        if (this.actionEnable && this.focusEnable) {
            this.write(Character.toString(codePoint));
            return true;
        }
        return false;
    }

    public void shiftCursorLeft() {
        if (this.cursorPos > 0) {
            if (Screen.func_231173_s_() && Screen.func_231172_r_()) {
                this.cursorPos = this.findBreakCharacter(this.cursorPos, true);
            } else if (Screen.func_231172_r_()) {
                this.selectionPos = this.cursorPos = this.findBreakCharacter(this.cursorPos, true);
            } else if (Screen.func_231173_s_()) {
                --this.cursorPos;
            } else {
                --this.cursorPos;
                this.selectionPos = this.cursorPos;
            }
        }
    }

    public void shiftCursorRight() {
        if (this.cursorPos < this.textBuffer.length()) {
            if (Screen.func_231173_s_() && Screen.func_231172_r_()) {
                this.cursorPos = this.findBreakCharacter(this.cursorPos, false);
            } else if (Screen.func_231172_r_()) {
                this.selectionPos = this.cursorPos = this.findBreakCharacter(this.cursorPos, false);
            } else if (Screen.func_231173_s_()) {
                ++this.cursorPos;
            } else {
                ++this.cursorPos;
                this.selectionPos = this.cursorPos;
            }
        }
    }

    public int findBreakCharacter(int start, boolean reverse) {
        if (start < 0) {
            return 0;
        }
        if (start > this.textBuffer.length()) {
            return this.textBuffer.length();
        }
        if (reverse) {
            for (int i = start - 1; i >= 0; --i) {
                if (i == 0) {
                    return 0;
                }
                if (!this.isBreakCharacter(this.textBuffer.codePointAt(i))) continue;
                return i;
            }
            return this.textBuffer.length();
        }
        for (int i = start + 1; i <= this.textBuffer.length(); ++i) {
            if (i == this.textBuffer.length()) {
                return this.textBuffer.length();
            }
            if (!this.isBreakCharacter(this.textBuffer.codePointAt(i))) continue;
            return i;
        }
        return 0;
    }

    public boolean isBreakCharacter(int codePoint) {
        switch (codePoint) {
            case 32: 
            case 44: 
            case 46: 
            case 47: 
            case 59: 
            case 92: {
                return true;
            }
        }
        return false;
    }

    public String getSelection() {
        try {
            if (this.selectionPos > this.cursorPos) {
                return this.textBuffer.substring(this.cursorPos, this.selectionPos);
            }
            return this.textBuffer.substring(this.selectionPos, this.cursorPos);
        }
        catch (StringIndexOutOfBoundsException err) {
            BiggerReactors.LOGGER.error("Failed to write text: ", (Throwable)err);
            return "";
        }
    }

    public void deleteSelection() {
        try {
            int charsDeleted = 0;
            if (this.selectionPos > this.cursorPos) {
                this.textBuffer.delete(this.cursorPos, this.selectionPos);
                charsDeleted = this.selectionPos - this.cursorPos;
            } else {
                this.textBuffer.delete(this.selectionPos, this.cursorPos);
                charsDeleted = this.cursorPos - this.selectionPos;
            }
            this.cursorPos -= charsDeleted;
            this.selectionPos = this.cursorPos;
        }
        catch (StringIndexOutOfBoundsException err) {
            BiggerReactors.LOGGER.error("Failed to write text: ", (Throwable)err);
        }
    }

    public void deleteWord() {
        try {
            for (int i = this.cursorPos; i > 0; --i) {
                if (this.textBuffer.codePointAt(i - 1) == 32) {
                    return;
                }
                this.textBuffer.deleteCharAt(i - 1);
                this.selectionPos = --this.cursorPos;
            }
        }
        catch (StringIndexOutOfBoundsException err) {
            BiggerReactors.LOGGER.error("Failed to delete word: ", (Throwable)err);
        }
    }

    public void deleteCharacter() {
        try {
            if (this.cursorPos > 0) {
                this.textBuffer.deleteCharAt(this.cursorPos - 1);
                --this.cursorPos;
                this.selectionPos = this.cursorPos;
            }
        }
        catch (StringIndexOutOfBoundsException err) {
            BiggerReactors.LOGGER.error("Failed to write text: ", (Throwable)err);
        }
    }

    public void clear() {
        this.cursorPos = 0;
        this.selectionPos = 0;
        if (this.textBuffer.length() > 0) {
            this.textBuffer.delete(0, this.textBuffer.length());
        }
    }

    public String set(String text) {
        String buffer = this.textBuffer.toString();
        this.clear();
        this.write(text);
        return buffer;
    }

    public void write(String text) {
        try {
            if (this.textBuffer.length() >= this.charLimit) {
                this.playSound(SoundEvents.field_187913_gm);
                return;
            }
            String filteredText = SharedConstants.func_71565_a((String)text);
            if (this.cursorPos >= this.textBuffer.length() || this.cursorPos < 0) {
                this.textBuffer.append(filteredText);
            } else {
                this.textBuffer.insert(this.cursorPos, filteredText);
            }
            this.cursorPos += text.length();
            this.selectionPos = this.cursorPos;
        }
        catch (StringIndexOutOfBoundsException err) {
            BiggerReactors.LOGGER.error("Failed to write text: ", (Throwable)err);
        }
    }
}

