/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.roguelogix.phosphophyllite.gui.client.RenderHelper;
import net.roguelogix.phosphophyllite.gui.client.elements.Symbol;

@OnlyIn(value=Dist.CLIENT)
public class CommonRender {
    public static final ResourceLocation COMMON_RESOURCE_TEXTURE = new ResourceLocation("biggerreactors", "textures/screen/common.png");

    public static <T extends Container> void renderEnergyGauge(@Nonnull MatrixStack mStack, @Nonnull Symbol<T> symbol, long energyStored, long energyCapacity) {
        ResourceLocation preservedResource = RenderHelper.getCurrentResource();
        RenderHelper.bindTexture((ResourceLocation)COMMON_RESOURCE_TEXTURE);
        if (energyCapacity > 0L) {
            int renderSize = (int)((long)symbol.height * energyStored / energyCapacity);
            symbol.blit(mStack, 54, 0);
            symbol.blit(mStack, symbol.width, symbol.height - renderSize, 36, 0);
        }
        symbol.blit(mStack, 0, 0);
        symbol.tooltip = new StringTextComponent(String.format("%s/%s", RenderHelper.formatValue((double)energyStored, (String)"RF"), RenderHelper.formatValue((double)energyCapacity, (String)"RF")));
        RenderHelper.clearRenderColor();
        RenderHelper.bindTexture((ResourceLocation)preservedResource);
    }

    public static <T extends Container> void renderFluidGauge(@Nonnull MatrixStack mStack, @Nonnull Symbol<T> symbol, long fluidStored, long fluidCapacity, Fluid fluid) {
        ResourceLocation preservedResource = RenderHelper.getCurrentResource();
        RenderHelper.bindTexture((ResourceLocation)COMMON_RESOURCE_TEXTURE);
        if (fluidCapacity > 0L) {
            int renderSize = (int)((long)symbol.height * fluidStored / fluidCapacity);
            RenderHelper.drawFluidGrid((MatrixStack)mStack, (int)(symbol.x + 1), (int)symbol.y, (int)symbol.getBlitOffset(), (int)16, (int)16, (Fluid)fluid, (int)1, (int)4);
            symbol.blit(mStack, symbol.width, symbol.height - renderSize, 18, 0);
        }
        symbol.blit(mStack, 0, 0);
        symbol.blit(mStack, 72, 0);
        symbol.tooltip = new StringTextComponent(String.format("%s/%s of %s", RenderHelper.formatValue((double)((double)fluidStored / 1000.0), (String)"B", (boolean)true), RenderHelper.formatValue((double)((double)fluidCapacity / 1000.0), (String)"B", (boolean)true), new FluidStack(fluid, 1).getDisplayName().getString().toLowerCase()));
        RenderHelper.clearRenderColor();
        RenderHelper.bindTexture((ResourceLocation)preservedResource);
    }
}

