/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.world;

import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.WorldConfig;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismFeatures;
import mekanism.common.registries.MekanismPlacements;
import mekanism.common.resource.OreType;
import mekanism.common.util.EnumUtils;
import mekanism.common.world.AdjustableSpreadConfig;
import mekanism.common.world.DisableableConfiguredFeature;
import mekanism.common.world.ResizableOreFeatureConfig;
import mekanism.common.world.ResizableSphereReplaceConfig;
import mekanism.common.world.ResizableSphereReplaceFeature;
import mekanism.common.world.ResizableTopSolidRangeConfig;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.ModLoader;

public class GenHandler {
    private static final Map<OreType, ConfiguredFeature<?, ?>> ORES = new EnumMap(OreType.class);
    private static final Map<OreType, ConfiguredFeature<?, ?>> ORE_RETROGENS = new EnumMap(OreType.class);
    private static ConfiguredFeature<?, ?> SALT_FEATURE;
    private static ConfiguredFeature<?, ?> SALT_RETROGEN_FEATURE;

    private GenHandler() {
    }

    public static void setupWorldGenFeatures() {
        if (ModLoader.isLoadingStateValid()) {
            for (OreType type : EnumUtils.ORE_TYPES) {
                ORES.put(type, GenHandler.getOreFeature(type, MekanismFeatures.ORE.getFeature(), false));
                ORE_RETROGENS.put(type, GenHandler.getOreFeature(type, MekanismFeatures.ORE_RETROGEN.getFeature(), true));
            }
            SALT_FEATURE = GenHandler.getSaltFeature(MekanismConfig.world.salt, (ConfiguredPlacement<NoPlacementConfig>)Features.Placements.field_243995_f, false);
            SALT_RETROGEN_FEATURE = GenHandler.getSaltFeature(MekanismConfig.world.salt, MekanismPlacements.TOP_SOLID_RETROGEN.getConfigured(IPlacementConfig.field_202468_e), true);
        }
    }

    public static void onBiomeLoad(BiomeLoadingEvent event) {
        if (GenHandler.isValidBiome(event.getCategory())) {
            BiomeGenerationSettingsBuilder generation = event.getGeneration();
            for (ConfiguredFeature<?, ?> feature : ORES.values()) {
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, feature);
            }
            generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, SALT_FEATURE);
        }
    }

    private static boolean isValidBiome(Biome.Category biomeCategory) {
        return biomeCategory != Biome.Category.THEEND && biomeCategory != Biome.Category.NETHER;
    }

    @Nonnull
    private static ConfiguredFeature<?, ?> getOreFeature(OreType type, Feature<ResizableOreFeatureConfig> feature, boolean retroGen) {
        WorldConfig.OreConfig oreConfig = MekanismConfig.world.ores.get((Object)type);
        ConfiguredFeature configuredFeature = ((ConfiguredFeature)new DisableableConfiguredFeature<ResizableOreFeatureConfig, Feature<ResizableOreFeatureConfig>>(feature, new ResizableOreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, type, oreConfig.maxVeinSize), oreConfig.shouldGenerate, retroGen).func_227228_a_(MekanismPlacements.RESIZABLE_RANGE.getConfigured(new ResizableTopSolidRangeConfig(type, oreConfig))).func_242728_a()).func_227228_a_(MekanismPlacements.ADJUSTABLE_COUNT.getConfigured(new AdjustableSpreadConfig(type, oreConfig.perChunk)));
        String name = "ore_" + type.getResource().getRegistrySuffix();
        if (retroGen) {
            name = name + "_retrogen";
        }
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)Mekanism.rl(name), (Object)configuredFeature);
        return configuredFeature;
    }

    @Nonnull
    private static ConfiguredFeature<?, ?> getSaltFeature(WorldConfig.SaltConfig saltConfig, ConfiguredPlacement<NoPlacementConfig> placement, boolean retroGen) {
        ConfiguredFeature configuredFeature = new DisableableConfiguredFeature<ResizableSphereReplaceConfig, ResizableSphereReplaceFeature>(MekanismFeatures.DISK.getFeature(), new ResizableSphereReplaceConfig(MekanismBlocks.SALT_BLOCK.getBlock().func_176223_P(), saltConfig), saltConfig.shouldGenerate, retroGen).func_227228_a_((ConfiguredPlacement)placement.func_242728_a()).func_227228_a_(MekanismPlacements.ADJUSTABLE_COUNT.getConfigured(new AdjustableSpreadConfig(null, saltConfig.perChunk)));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)Mekanism.rl(retroGen ? "salt_retrogen" : "salt"), (Object)configuredFeature);
        return configuredFeature;
    }

    public static boolean generate(ServerWorld world, Random random, int chunkX, int chunkZ) {
        BlockPos blockPos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        Biome biome = world.func_226691_t_(blockPos);
        boolean generated = false;
        if (GenHandler.isValidBiome(biome.func_201856_r()) && world.func_217354_b(chunkX, chunkZ)) {
            ChunkGenerator chunkGenerator = world.func_72863_F().func_201711_g();
            for (ConfiguredFeature<?, ?> feature : ORE_RETROGENS.values()) {
                generated |= feature.func_242765_a((ISeedReader)world, chunkGenerator, random, blockPos);
            }
            generated |= SALT_RETROGEN_FEATURE.func_242765_a((ISeedReader)world, chunkGenerator, random, blockPos);
        }
        return generated;
    }
}

