/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radiation;

import java.util.Objects;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.radiation.IRadiationSource;
import mekanism.common.config.MekanismConfig;
import net.minecraft.nbt.CompoundNBT;

public class RadiationSource
implements IRadiationSource {
    private final Coord4D pos;
    private double magnitude;

    public RadiationSource(Coord4D pos, double magnitude) {
        this.pos = pos;
        this.magnitude = magnitude;
    }

    @Override
    @Nonnull
    public Coord4D getPos() {
        return this.pos;
    }

    @Override
    public double getMagnitude() {
        return this.magnitude;
    }

    @Override
    public void radiate(double magnitude) {
        this.magnitude += magnitude;
    }

    @Override
    public boolean decay() {
        this.magnitude *= MekanismConfig.general.radiationSourceDecayRate.get();
        return this.magnitude < 1.0E-5;
    }

    public static RadiationSource load(CompoundNBT tag) {
        return new RadiationSource(Coord4D.read(tag), tag.func_74769_h("radiation"));
    }

    public void write(CompoundNBT tag) {
        this.pos.write(tag);
        tag.func_74780_a("radiation", this.magnitude);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RadiationSource other = (RadiationSource)o;
        return this.magnitude == other.magnitude && this.pos.equals(other.pos);
    }

    public int hashCode() {
        return Objects.hash(this.pos, this.magnitude);
    }
}

