/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import java.util.List;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.FluidSlurryToSlurryRecipe;
import mekanism.api.recipes.inputs.chemical.SlurryStackIngredient;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraftforge.fluids.FluidStack;

@RecipeTypeMapper
public class FluidSlurryToSlurryRecipeMapper
implements IRecipeTypeMapper {
    public String getName() {
        return "MekFluidSlurryToSlurry";
    }

    public String getDescription() {
        return "Maps Mekanism washing recipes.";
    }

    public boolean canHandle(IRecipeType<?> recipeType) {
        return recipeType == MekanismRecipeType.WASHING;
    }

    public boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, IRecipe<?> iRecipe, INSSFakeGroupManager groupManager) {
        if (!(iRecipe instanceof FluidSlurryToSlurryRecipe)) {
            return false;
        }
        boolean handled = false;
        FluidSlurryToSlurryRecipe recipe = (FluidSlurryToSlurryRecipe)iRecipe;
        List<@NonNull TYPE> fluidRepresentations = recipe.getFluidInput().getRepresentations();
        List<@NonNull TYPE> slurryRepresentations = ((SlurryStackIngredient)recipe.getChemicalInput()).getRepresentations();
        for (FluidStack fluidRepresentation : fluidRepresentations) {
            NSSFluid nssFluid = NSSFluid.createFluid((FluidStack)fluidRepresentation);
            for (SlurryStack slurryRepresentation : slurryRepresentations) {
                SlurryStack output = recipe.getOutput(fluidRepresentation, slurryRepresentation);
                if (output.isEmpty()) continue;
                IngredientHelper ingredientHelper = new IngredientHelper(mapper);
                ingredientHelper.put((NormalizedSimpleStack)nssFluid, fluidRepresentation.getAmount());
                ingredientHelper.put(slurryRepresentation);
                if (!ingredientHelper.addAsConversion(output)) continue;
                handled = true;
            }
        }
        return handled;
    }
}

