/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import mekanism.api.math.FloatingLong;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@NativeTypeRegistration(value=FloatingLong.class, zenCodeName="mods.mekanism.api.FloatingLong")
public class CrTFloatingLong {
    private CrTFloatingLong() {
    }

    @ZenCodeType.StaticExpansionMethod
    public static FloatingLong create(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Floating Longs do not support negative numbers.");
        }
        return FloatingLong.createConst(value);
    }

    @ZenCodeType.StaticExpansionMethod
    public static FloatingLong createFromUnsigned(@ZenCodeType.Unsigned long value) {
        return FloatingLong.createConst(value);
    }

    @ZenCodeType.StaticExpansionMethod
    public static FloatingLong create(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("Floating Longs do not support negative numbers.");
        }
        return FloatingLong.createConst(value);
    }

    @ZenCodeType.StaticExpansionMethod
    public static FloatingLong create(String value) {
        return FloatingLong.parseFloatingLong(value, true);
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static String asString(FloatingLong _this) {
        return _this.toString();
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.ADD)
    public static FloatingLong add(FloatingLong _this, FloatingLong toAdd) {
        return _this.add(toAdd);
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.SUB)
    public static FloatingLong subtract(FloatingLong _this, FloatingLong toSubtract) {
        return _this.subtract(toSubtract);
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MUL)
    public static FloatingLong multiply(FloatingLong _this, FloatingLong toMultiply) {
        return _this.multiply(toMultiply);
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.DIV)
    public static FloatingLong divide(FloatingLong _this, FloatingLong toDivide) {
        return _this.divide(toDivide);
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public static boolean isEqual(FloatingLong _this, FloatingLong toCompare) {
        return _this.equals(toCompare);
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.COMPARE)
    public static int compareTo(FloatingLong _this, FloatingLong toCompare) {
        return _this.compareTo(toCompare);
    }
}

