/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.chemical;

import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.inventory.AutomationType;
import mekanism.common.capabilities.chemical.variable.VariableCapacityChemicalTank;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tile.TileEntityRadioactiveWasteBarrel;
import mekanism.common.util.WorldUtils;
import net.minecraft.world.IBlockReader;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StackedWasteBarrel
extends VariableCapacityChemicalTank<Gas, GasStack>
implements IGasHandler,
IGasTank {
    private final TileEntityRadioactiveWasteBarrel tile;

    public static StackedWasteBarrel create(TileEntityRadioactiveWasteBarrel tile) {
        Objects.requireNonNull(tile, "Radioactive Waste Barrel tile entity cannot be null");
        return new StackedWasteBarrel(tile);
    }

    protected StackedWasteBarrel(TileEntityRadioactiveWasteBarrel tile) {
        super(MekanismConfig.general.radioactiveWasteBarrelMaxGas, ChemicalTankBuilder.GAS.alwaysTrueBi, ChemicalTankBuilder.GAS.alwaysTrueBi, ChemicalTankBuilder.GAS.alwaysTrue, ChemicalAttributeValidator.createStrict(GasAttributes.Radiation.class), (IContentsListener)tile);
        this.tile = tile;
    }

    @Override
    public GasStack insert(GasStack stack, Action action, AutomationType automationType) {
        TileEntityRadioactiveWasteBarrel tileAbove;
        GasStack remainder = super.insert(stack, action, automationType);
        if (!remainder.isEmpty() && (tileAbove = WorldUtils.getTileEntity(TileEntityRadioactiveWasteBarrel.class, (IBlockReader)this.tile.func_145831_w(), this.tile.func_174877_v().func_177984_a())) != null) {
            remainder = tileAbove.getGasTank().insert(remainder, action, AutomationType.EXTERNAL);
        }
        return remainder;
    }

    @Override
    public long growStack(long amount, Action action) {
        TileEntityRadioactiveWasteBarrel tileAbove;
        long grownAmount = super.growStack(amount, action);
        if (amount > 0L && grownAmount < amount && !this.tile.getActive() && (tileAbove = WorldUtils.getTileEntity(TileEntityRadioactiveWasteBarrel.class, (IBlockReader)this.tile.func_145831_w(), this.tile.func_174877_v().func_177984_a())) != null) {
            long leftOverToInsert = amount - grownAmount;
            GasStack remainder = tileAbove.getGasTank().insert(new GasStack((GasStack)this.stored, leftOverToInsert), action, AutomationType.EXTERNAL);
            grownAmount += leftOverToInsert - remainder.getAmount();
        }
        return grownAmount;
    }
}

