/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mekanism.common.block.BlockBounding;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.lib.WildcardMatcher;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public final class TagCache {
    private static final Map<String, List<ItemStack>> blockTagStacks = new Object2ObjectOpenHashMap();
    private static final Map<String, List<ItemStack>> itemTagStacks = new Object2ObjectOpenHashMap();
    private static final Map<String, List<ItemStack>> modIDStacks = new Object2ObjectOpenHashMap();
    private static final Map<Material, List<ItemStack>> materialStacks = new Object2ObjectOpenHashMap();
    private static final Map<Block, List<String>> tileEntityTypeTagCache = new Object2ObjectOpenHashMap();
    private static final Object2BooleanMap<String> blockTagBlacklistedElements = new Object2BooleanOpenHashMap();
    private static final Object2BooleanMap<String> modIDBlacklistedElements = new Object2BooleanOpenHashMap();
    private static final Object2BooleanMap<Material> materialBlacklistedElements = new Object2BooleanOpenHashMap();

    private TagCache() {
    }

    public static void resetVanillaTagCaches() {
        blockTagStacks.clear();
        itemTagStacks.clear();
        blockTagBlacklistedElements.clear();
        modIDBlacklistedElements.clear();
        materialBlacklistedElements.clear();
    }

    public static void resetCustomTagCaches() {
        tileEntityTypeTagCache.clear();
    }

    public static List<String> getItemTags(@Nonnull ItemStack check) {
        return TagCache.getTagsAsStrings(check.func_77973_b().getTags());
    }

    public static List<String> getTileEntityTypeTags(@Nonnull Block block) {
        List<String> tagsAsString;
        if (tileEntityTypeTagCache.containsKey(block)) {
            return tileEntityTypeTagCache.get(block);
        }
        if (block instanceof IHasTileEntity) {
            tagsAsString = TagCache.getTagsAsStrings(((IHasTileEntity)block).getTileType().getTags());
        } else if (block.hasTileEntity(block.func_176223_P())) {
            HashSet<ResourceLocation> tileEntityTags = new HashSet<ResourceLocation>();
            for (TileEntityType tileEntityType : ForgeRegistries.TILE_ENTITIES) {
                if (!tileEntityType.func_223045_a(block)) continue;
                tileEntityTags.addAll(tileEntityType.getTags());
            }
            tagsAsString = TagCache.getTagsAsStrings(tileEntityTags);
        } else {
            tagsAsString = Collections.emptyList();
        }
        tileEntityTypeTagCache.put(block, tagsAsString);
        return tagsAsString;
    }

    public static List<String> getTagsAsStrings(@Nonnull Set<ResourceLocation> tags) {
        if (tags.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder asStrings = ImmutableList.builder();
        for (ResourceLocation tag : tags) {
            asStrings.add((Object)tag.toString());
        }
        return asStrings.build();
    }

    public static List<ItemStack> getItemTagStacks(@Nonnull String oreName) {
        return TagCache.getTagStacks(itemTagStacks, ItemTags.func_199903_a(), oreName);
    }

    public static List<ItemStack> getBlockTagStacks(@Nonnull String oreName) {
        return TagCache.getTagStacks(blockTagStacks, BlockTags.func_199896_a(), oreName);
    }

    private static <TYPE extends IItemProvider> List<ItemStack> getTagStacks(Map<String, List<ItemStack>> cache, ITagCollection<TYPE> tagCollection, @Nonnull String oreName) {
        if (cache.containsKey(oreName)) {
            return cache.get(oreName);
        }
        HashSet items = new HashSet();
        for (Map.Entry entry : tagCollection.func_241833_a().entrySet()) {
            if (!WildcardMatcher.matches(oreName, ((ResourceLocation)entry.getKey()).toString())) continue;
            items.addAll(((ITag)entry.getValue()).func_230236_b_());
        }
        List<ItemStack> stacks = items.stream().map(ItemStack::new).collect(Collectors.toList());
        cache.put(oreName, stacks);
        return stacks;
    }

    public static List<ItemStack> getModIDStacks(@Nonnull String modName, boolean forceBlock) {
        if (modIDStacks.containsKey(modName)) {
            return modIDStacks.get(modName);
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            ItemStack stack;
            if (forceBlock && !(item instanceof BlockItem) || item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof BlockBounding || !WildcardMatcher.matches(modName, MekanismUtils.getModId(stack = new ItemStack((IItemProvider)item)))) continue;
            stacks.add(stack);
        }
        modIDStacks.put(modName, stacks);
        return stacks;
    }

    public static List<ItemStack> getMaterialStacks(@Nonnull ItemStack stack) {
        return TagCache.getMaterialStacks(Block.func_149634_a((Item)stack.func_77973_b()).func_176223_P().func_185904_a());
    }

    public static List<ItemStack> getMaterialStacks(@Nonnull Material material) {
        if (materialStacks.containsKey(material)) {
            return materialStacks.get(material);
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            Block block;
            if (!(item instanceof BlockItem) || (block = ((BlockItem)item).func_179223_d()) == null || block instanceof BlockBounding || block.func_176223_P().func_185904_a() != material) continue;
            stacks.add(new ItemStack((IItemProvider)item));
        }
        materialStacks.put(material, stacks);
        return stacks;
    }

    public static boolean tagHasMinerBlacklisted(@Nonnull String tag) {
        if (MekanismTags.Blocks.MINER_BLACKLIST.func_230236_b_().isEmpty()) {
            return false;
        }
        if (blockTagBlacklistedElements.containsKey((Object)tag)) {
            return blockTagBlacklistedElements.getBoolean((Object)tag);
        }
        boolean hasBlacklisted = false;
        for (Map.Entry entry : BlockTags.func_199896_a().func_241833_a().entrySet()) {
            if (!WildcardMatcher.matches(tag, ((ResourceLocation)entry.getKey()).toString())) continue;
            if (!((ITag)entry.getValue()).func_230236_b_().stream().anyMatch(arg_0 -> MekanismTags.Blocks.MINER_BLACKLIST.func_230235_a_(arg_0))) continue;
            hasBlacklisted = true;
            break;
        }
        blockTagBlacklistedElements.put((Object)tag, hasBlacklisted);
        return hasBlacklisted;
    }

    public static boolean modIDHasMinerBlacklisted(@Nonnull String modName) {
        if (MekanismTags.Blocks.MINER_BLACKLIST.func_230236_b_().isEmpty()) {
            return false;
        }
        if (modIDBlacklistedElements.containsKey((Object)modName)) {
            return modIDBlacklistedElements.getBoolean((Object)modName);
        }
        boolean hasBlacklisted = false;
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            if (!MekanismTags.Blocks.MINER_BLACKLIST.func_230235_a_((Object)block) || !WildcardMatcher.matches(modName, block.getRegistryName().func_110624_b())) continue;
            hasBlacklisted = true;
            break;
        }
        modIDBlacklistedElements.put((Object)modName, hasBlacklisted);
        return hasBlacklisted;
    }

    public static boolean materialHasMinerBlacklisted(@Nonnull ItemStack stack) {
        return TagCache.materialHasMinerBlacklisted(Block.func_149634_a((Item)stack.func_77973_b()).func_176223_P().func_185904_a());
    }

    public static boolean materialHasMinerBlacklisted(@Nonnull Material material) {
        if (MekanismTags.Blocks.MINER_BLACKLIST.func_230236_b_().isEmpty()) {
            return false;
        }
        if (materialBlacklistedElements.containsKey((Object)material)) {
            return materialBlacklistedElements.getBoolean((Object)material);
        }
        boolean hasBlacklisted = false;
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            if (block.func_176223_P().func_185904_a() != material || !MekanismTags.Blocks.MINER_BLACKLIST.func_230235_a_((Object)block)) continue;
            hasBlacklisted = true;
            break;
        }
        materialBlacklistedElements.put((Object)material, hasBlacklisted);
        return hasBlacklisted;
    }
}

