/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.api.MekanismAPI;
import mekanism.api.MekanismIMC;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.providers.IItemProvider;
import mekanism.api.robit.RobitSkin;
import mekanism.common.CommonPlayerTickHandler;
import mekanism.common.CommonPlayerTracker;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.CreativeTabMekanism;
import mekanism.common.MekanismLang;
import mekanism.common.ReloadListener;
import mekanism.common.base.IModModule;
import mekanism.common.base.KeySync;
import mekanism.common.base.LootTableModifierReloadListener;
import mekanism.common.base.MekFakePlayer;
import mekanism.common.base.PlayerState;
import mekanism.common.base.TagCache;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.command.CommandMek;
import mekanism.common.command.builders.BuildCommand;
import mekanism.common.command.builders.Builders;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.MekanismModConfig;
import mekanism.common.content.boiler.BoilerMultiblockData;
import mekanism.common.content.boiler.BoilerValidator;
import mekanism.common.content.evaporation.EvaporationMultiblockData;
import mekanism.common.content.evaporation.EvaporationValidator;
import mekanism.common.content.gear.MekaSuitDispenseBehavior;
import mekanism.common.content.gear.ModuleDispenseBehavior;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.content.matrix.MatrixMultiblockData;
import mekanism.common.content.matrix.MatrixValidator;
import mekanism.common.content.network.BoxedChemicalNetwork;
import mekanism.common.content.network.EnergyNetwork;
import mekanism.common.content.network.FluidNetwork;
import mekanism.common.content.sps.SPSCache;
import mekanism.common.content.sps.SPSMultiblockData;
import mekanism.common.content.sps.SPSValidator;
import mekanism.common.content.tank.TankCache;
import mekanism.common.content.tank.TankMultiblockData;
import mekanism.common.content.tank.TankValidator;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.integration.MekanismHooks;
import mekanism.common.integration.crafttweaker.content.CrTContentUtils;
import mekanism.common.item.block.machine.ItemBlockFluidTank;
import mekanism.common.lib.MekAnnotationScanner;
import mekanism.common.lib.Version;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.lib.transmitter.TransmitterNetworkRegistry;
import mekanism.common.network.PacketHandler;
import mekanism.common.network.to_client.PacketTransmitterUpdate;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.bin.BinInsertRecipe;
import mekanism.common.recipe.condition.ModVersionLoadedCondition;
import mekanism.common.recipe.ingredient.IngredientWithout;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.registries.MekanismDataSerializers;
import mekanism.common.registries.MekanismEntityTypes;
import mekanism.common.registries.MekanismFeatures;
import mekanism.common.registries.MekanismFluids;
import mekanism.common.registries.MekanismGases;
import mekanism.common.registries.MekanismInfuseTypes;
import mekanism.common.registries.MekanismItems;
import mekanism.common.registries.MekanismModules;
import mekanism.common.registries.MekanismParticleTypes;
import mekanism.common.registries.MekanismPigments;
import mekanism.common.registries.MekanismPlacements;
import mekanism.common.registries.MekanismRecipeSerializers;
import mekanism.common.registries.MekanismRobitSkins;
import mekanism.common.registries.MekanismSlurries;
import mekanism.common.registries.MekanismSounds;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.component.TileComponentChunkLoader;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import mekanism.common.world.GenHandler;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DatagenModLoader;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mekanism")
public class Mekanism {
    public static final String MODID = "mekanism";
    public static final String MOD_NAME = "Mekanism";
    public static final String LOG_TAG = "[Mekanism]";
    public static final PlayerState playerState = new PlayerState();
    public static final PacketHandler packetHandler = new PacketHandler();
    public static final Logger logger = LogManager.getLogger((String)"Mekanism");
    public static Mekanism instance;
    public static final MekanismHooks hooks;
    public final Version versionNumber;
    public static final MultiblockManager<TankMultiblockData> tankManager;
    public static final MultiblockManager<MatrixMultiblockData> matrixManager;
    public static final MultiblockManager<BoilerMultiblockData> boilerManager;
    public static final MultiblockManager<EvaporationMultiblockData> evaporationManager;
    public static final MultiblockManager<SPSMultiblockData> spsManager;
    public static final CreativeTabMekanism tabMekanism;
    public static final List<IModModule> modulesLoaded;
    public static final CommonWorldTickHandler worldTickHandler;
    public static final GameProfile gameProfile;
    public static final KeySync keyMap;
    public static final Set<Coord4D> activeVibrators;
    private ReloadListener recipeCacheManager;

    public Mekanism() {
        instance = this;
        MekanismConfig.registerConfigs(ModLoadingContext.get());
        MinecraftForge.EVENT_BUS.addListener(this::onEnergyTransferred);
        MinecraftForge.EVENT_BUS.addListener(this::onChemicalTransferred);
        MinecraftForge.EVENT_BUS.addListener(this::onLiquidTransferred);
        MinecraftForge.EVENT_BUS.addListener(this::chunkSave);
        MinecraftForge.EVENT_BUS.addListener(this::onChunkDataLoad);
        MinecraftForge.EVENT_BUS.addListener(this::onWorldLoad);
        MinecraftForge.EVENT_BUS.addListener(this::onWorldUnload);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::addReloadListenersLowest);
        MinecraftForge.EVENT_BUS.addListener(BinInsertRecipe::onCrafting);
        MinecraftForge.EVENT_BUS.addListener(this::onVanillaTagsReload);
        MinecraftForge.EVENT_BUS.addListener(this::onCustomTagsReload);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, GenHandler::onBiomeLoad);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onConfigLoad);
        modEventBus.addListener(this::imcQueue);
        modEventBus.addListener(this::imcHandle);
        MekanismItems.ITEMS.register(modEventBus);
        MekanismBlocks.BLOCKS.register(modEventBus);
        MekanismFluids.FLUIDS.register(modEventBus);
        MekanismContainerTypes.CONTAINER_TYPES.register(modEventBus);
        MekanismEntityTypes.ENTITY_TYPES.register(modEventBus);
        MekanismTileEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
        MekanismSounds.SOUND_EVENTS.register(modEventBus);
        MekanismParticleTypes.PARTICLE_TYPES.register(modEventBus);
        MekanismPlacements.PLACEMENTS.register(modEventBus);
        MekanismFeatures.FEATURES.register(modEventBus);
        MekanismRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        MekanismDataSerializers.DATA_SERIALIZERS.register(modEventBus);
        MekanismGases.GASES.createAndRegister(modEventBus, "gas", builder -> builder.tagFolder("gases").setDefaultKey(Mekanism.rl("empty_gas")));
        MekanismInfuseTypes.INFUSE_TYPES.createAndRegister(modEventBus, "infuse_type", builder -> builder.tagFolder("infuse_types").setDefaultKey(Mekanism.rl("empty_infuse_type")));
        MekanismPigments.PIGMENTS.createAndRegister(modEventBus, "pigment", builder -> builder.tagFolder("pigments").setDefaultKey(Mekanism.rl("empty_pigment")));
        MekanismSlurries.SLURRIES.createAndRegister(modEventBus, "slurry", builder -> builder.tagFolder("slurries").setDefaultKey(Mekanism.rl("empty_slurry")));
        MekanismRobitSkins.ROBIT_SKINS.createAndRegister(modEventBus, "robit_skin", builder -> builder.setDefaultKey(Mekanism.rl("robit")));
        MekanismModules.MODULES.createAndRegister(modEventBus, "module");
        modEventBus.addGenericListener(Gas.class, this::registerGases);
        modEventBus.addGenericListener(InfuseType.class, this::registerInfuseTypes);
        modEventBus.addGenericListener(Pigment.class, this::registerPigments);
        modEventBus.addGenericListener(Slurry.class, this::registerSlurries);
        modEventBus.addGenericListener(IRecipeSerializer.class, this::registerRecipeSerializers);
        this.versionNumber = new Version(ModLoadingContext.get().getActiveContainer());
        hooks.hookConstructor();
        if (Mekanism.hooks.CraftTweakerLoaded && !DatagenModLoader.isRunningDataGen()) {
            ModContainer container;
            IEventBus crtModEventBus = modEventBus;
            Optional crtModContainer = ModList.get().getModContainerById("crafttweaker");
            if (crtModContainer.isPresent() && (container = (ModContainer)crtModContainer.get()) instanceof FMLModContainer) {
                crtModEventBus = ((FMLModContainer)container).getEventBus();
            }
            crtModEventBus.addGenericListener(Gas.class, EventPriority.LOWEST, CrTContentUtils::registerCrTGases);
            crtModEventBus.addGenericListener(InfuseType.class, EventPriority.LOWEST, CrTContentUtils::registerCrTInfuseTypes);
            crtModEventBus.addGenericListener(Pigment.class, EventPriority.LOWEST, CrTContentUtils::registerCrTPigments);
            crtModEventBus.addGenericListener(Slurry.class, EventPriority.LOWEST, CrTContentUtils::registerCrTSlurries);
            crtModEventBus.addGenericListener(RobitSkin.class, EventPriority.LOWEST, CrTContentUtils::registerCrTRobitSkins);
        }
    }

    private void registerGases(RegistryEvent.Register<Gas> event) {
        MekanismAPI.EMPTY_GAS.setRegistryName(Mekanism.rl("empty_gas"));
        event.getRegistry().register((IForgeRegistryEntry)MekanismAPI.EMPTY_GAS);
    }

    private void registerInfuseTypes(RegistryEvent.Register<InfuseType> event) {
        MekanismAPI.EMPTY_INFUSE_TYPE.setRegistryName(Mekanism.rl("empty_infuse_type"));
        event.getRegistry().register((IForgeRegistryEntry)MekanismAPI.EMPTY_INFUSE_TYPE);
    }

    private void registerPigments(RegistryEvent.Register<Pigment> event) {
        MekanismAPI.EMPTY_PIGMENT.setRegistryName(Mekanism.rl("empty_pigment"));
        event.getRegistry().register((IForgeRegistryEntry)MekanismAPI.EMPTY_PIGMENT);
    }

    private void registerSlurries(RegistryEvent.Register<Slurry> event) {
        MekanismAPI.EMPTY_SLURRY.setRegistryName(Mekanism.rl("empty_slurry"));
        event.getRegistry().register((IForgeRegistryEntry)MekanismAPI.EMPTY_SLURRY);
    }

    private void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        MekanismRecipeType.registerRecipeTypes(event.getRegistry());
        CraftingHelper.register((IConditionSerializer)ModVersionLoadedCondition.Serializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)IngredientWithout.ID, IngredientWithout.Serializer.INSTANCE);
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    private void setRecipeCacheManager(ReloadListener manager) {
        if (this.recipeCacheManager == null) {
            this.recipeCacheManager = manager;
        } else {
            logger.warn("Recipe cache manager has already been set.");
        }
    }

    public ReloadListener getRecipeCacheManager() {
        return this.recipeCacheManager;
    }

    private void onVanillaTagsReload(TagsUpdatedEvent.VanillaTagTypes event) {
        TagCache.resetVanillaTagCaches();
    }

    private void onCustomTagsReload(TagsUpdatedEvent.CustomTagTypes event) {
        TagCache.resetCustomTagCaches();
    }

    private void addReloadListenersLowest(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new LootTableModifierReloadListener(event.getDataPackRegistries()));
        event.addListener((IFutureReloadListener)this.getRecipeCacheManager());
    }

    private void registerCommands(RegisterCommandsEvent event) {
        BuildCommand.register("boiler", MekanismLang.BOILER, new Builders.BoilerBuilder());
        BuildCommand.register("matrix", MekanismLang.MATRIX, new Builders.MatrixBuilder());
        BuildCommand.register("tank", MekanismLang.DYNAMIC_TANK, new Builders.TankBuilder());
        BuildCommand.register("evaporation", MekanismLang.EVAPORATION_PLANT, new Builders.EvaporationBuilder());
        BuildCommand.register("sps", MekanismLang.SPS, new Builders.SPSBuilder());
        event.getDispatcher().register(CommandMek.register());
    }

    private void serverStopped(FMLServerStoppedEvent event) {
        playerState.clear(false);
        activeVibrators.clear();
        worldTickHandler.resetRegenChunks();
        FrequencyType.clear();
        BoilerMultiblockData.hotMap.clear();
        RadiationManager.INSTANCE.reset();
        MultiblockManager.reset();
        FrequencyManager.reset();
        TransporterManager.reset();
        PathfinderCache.reset();
        TransmitterNetworkRegistry.reset();
    }

    private void imcQueue(InterModEnqueueEvent event) {
        hooks.sendIMCMessages(event);
        MekanismIMC.addModulesToAll(MekanismModules.ENERGY_UNIT);
        MekanismIMC.addMekaSuitModules(MekanismModules.LASER_DISSIPATION_UNIT, MekanismModules.RADIATION_SHIELDING_UNIT);
        MekanismIMC.addMekaToolModules(MekanismModules.ATTACK_AMPLIFICATION_UNIT, MekanismModules.SILK_TOUCH_UNIT, MekanismModules.VEIN_MINING_UNIT, MekanismModules.FARMING_UNIT, MekanismModules.SHEARING_UNIT, MekanismModules.TELEPORTATION_UNIT, MekanismModules.EXCAVATION_ESCALATION_UNIT);
        MekanismIMC.addMekaSuitHelmetModules(MekanismModules.ELECTROLYTIC_BREATHING_UNIT, MekanismModules.INHALATION_PURIFICATION_UNIT, MekanismModules.VISION_ENHANCEMENT_UNIT, MekanismModules.SOLAR_RECHARGING_UNIT, MekanismModules.NUTRITIONAL_INJECTION_UNIT);
        MekanismIMC.addMekaSuitBodyarmorModules(MekanismModules.JETPACK_UNIT, MekanismModules.GRAVITATIONAL_MODULATING_UNIT, MekanismModules.CHARGE_DISTRIBUTION_UNIT, MekanismModules.DOSIMETER_UNIT, MekanismModules.GEIGER_UNIT, MekanismModules.ELYTRA_UNIT);
        MekanismIMC.addMekaSuitPantsModules(MekanismModules.LOCOMOTIVE_BOOSTING_UNIT);
        MekanismIMC.addMekaSuitBootsModules(MekanismModules.HYDRAULIC_PROPULSION_UNIT, MekanismModules.MAGNETIC_ATTRACTION_UNIT, MekanismModules.FROST_WALKER_UNIT);
    }

    private void imcHandle(InterModProcessEvent event) {
        ModuleHelper.INSTANCE.processIMC();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        hooks.hookCommonSetup();
        Capabilities.registerCapabilities();
        this.setRecipeCacheManager(new ReloadListener());
        event.enqueueWork(() -> {
            MekanismTags.init();
            GenHandler.setupWorldGenFeatures();
            MekAnnotationScanner.collectScanData();
            ForgeChunkManager.setForcedChunkLoadingCallback((String)MODID, (ForgeChunkManager.LoadingValidationCallback)TileComponentChunkLoader.ChunkValidationCallback.INSTANCE);
            LootTableModifierReloadListener.registerCustomPredicate();
            MekanismFluids.FLUIDS.registerBucketDispenserBehavior();
            Mekanism.registerDispenseBehavior((IDispenseItemBehavior)ItemBlockFluidTank.FluidTankItemDispenseBehavior.INSTANCE, MekanismBlocks.BASIC_FLUID_TANK, MekanismBlocks.ADVANCED_FLUID_TANK, MekanismBlocks.ELITE_FLUID_TANK, MekanismBlocks.ULTIMATE_FLUID_TANK, MekanismBlocks.CREATIVE_FLUID_TANK);
            Mekanism.registerDispenseBehavior((IDispenseItemBehavior)new ModuleDispenseBehavior(), MekanismItems.MEKA_TOOL);
            Mekanism.registerDispenseBehavior((IDispenseItemBehavior)new MekaSuitDispenseBehavior(), MekanismItems.MEKASUIT_HELMET, MekanismItems.MEKASUIT_BODYARMOR, MekanismItems.MEKASUIT_PANTS, MekanismItems.MEKASUIT_BOOTS);
        });
        MinecraftForge.EVENT_BUS.register((Object)new CommonPlayerTracker());
        MinecraftForge.EVENT_BUS.register((Object)new CommonPlayerTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)worldTickHandler);
        MinecraftForge.EVENT_BUS.register((Object)RadiationManager.INSTANCE);
        ModuleHelper.INSTANCE.gatherLegacyModules();
        logger.info("Version {} initializing...", (Object)this.versionNumber);
        TransmitterNetworkRegistry.initiate();
        packetHandler.initialize();
        logger.info("Fake player readout: UUID = {}, name = {}", (Object)gameProfile.getId(), (Object)gameProfile.getName());
        logger.info("Loading complete.");
        logger.info("Mod loaded.");
    }

    private static void registerDispenseBehavior(IDispenseItemBehavior behavior, IItemProvider ... itemProviders) {
        for (IItemProvider itemProvider : itemProviders) {
            DispenserBlock.func_199774_a((net.minecraft.util.IItemProvider)itemProvider.getItem(), (IDispenseItemBehavior)behavior);
        }
    }

    private void onEnergyTransferred(EnergyNetwork.EnergyTransferEvent event) {
        packetHandler.sendToReceivers(new PacketTransmitterUpdate((EnergyNetwork)event.network), event.network);
    }

    private void onChemicalTransferred(BoxedChemicalNetwork.ChemicalTransferEvent event) {
        packetHandler.sendToReceivers(new PacketTransmitterUpdate((BoxedChemicalNetwork)event.network, event.transferType), event.network);
    }

    private void onLiquidTransferred(FluidNetwork.FluidTransferEvent event) {
        packetHandler.sendToReceivers(new PacketTransmitterUpdate((FluidNetwork)event.network, event.fluidType), event.network);
    }

    private void chunkSave(ChunkDataEvent.Save event) {
        if (event.getWorld() != null && !event.getWorld().func_201670_d()) {
            CompoundNBT levelTag = event.getData().func_74775_l("Level");
            levelTag.func_74768_a("worldGenVersion", MekanismConfig.world.userGenVersion.get());
        }
    }

    private synchronized void onChunkDataLoad(ChunkDataEvent.Load event) {
        CompoundNBT levelTag;
        IWorld world = event.getWorld();
        if (world instanceof World && !world.func_201670_d() && MekanismConfig.world.enableRegeneration.get() && (levelTag = event.getData().func_74775_l("Level")).func_74762_e("worldGenVersion") < MekanismConfig.world.userGenVersion.get()) {
            worldTickHandler.addRegenChunk((RegistryKey<World>)((World)world).func_234923_W_(), event.getChunk().func_76632_l());
        }
    }

    private void onConfigLoad(ModConfig.ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals(MODID) && config instanceof MekanismModConfig) {
            ((MekanismModConfig)config).clearCache();
        }
    }

    private void onWorldLoad(WorldEvent.Load event) {
        playerState.init(event.getWorld());
    }

    private void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld() instanceof ServerWorld) {
            MekFakePlayer.releaseInstance(event.getWorld());
        }
        if (event.getWorld() instanceof World && MekanismConfig.general.validOredictionificatorFilters.hasInvalidationListeners()) {
            for (TileEntity tile : ((World)event.getWorld()).field_147482_g) {
                if (!(tile instanceof TileEntityOredictionificator)) continue;
                ((TileEntityOredictionificator)tile).removeInvalidationListener();
            }
        }
    }

    static {
        hooks = new MekanismHooks();
        tankManager = new MultiblockManager("dynamicTank", TankCache::new, TankValidator::new);
        matrixManager = new MultiblockManager("inductionMatrix", MultiblockCache::new, MatrixValidator::new);
        boilerManager = new MultiblockManager("thermoelectricBoiler", MultiblockCache::new, BoilerValidator::new);
        evaporationManager = new MultiblockManager("evaporation", MultiblockCache::new, EvaporationValidator::new);
        spsManager = new MultiblockManager("sps", SPSCache::new, SPSValidator::new);
        tabMekanism = new CreativeTabMekanism();
        modulesLoaded = new ArrayList<IModModule>();
        worldTickHandler = new CommonWorldTickHandler();
        gameProfile = new GameProfile(UUID.nameUUIDFromBytes("mekanism.common".getBytes(StandardCharsets.UTF_8)), LOG_TAG);
        keyMap = new KeySync();
        activeVibrators = new ObjectOpenHashSet();
    }
}

