/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model.robit;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.robit.RobitSkin;
import mekanism.client.RobitSpriteUploader;
import mekanism.client.model.MekanismModelCache;
import mekanism.client.model.baked.ExtensionBakedModel;
import mekanism.client.model.robit.RobitModelDataBakedModel;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.client.render.lib.QuadUtils;
import mekanism.common.entity.EntityRobit;
import mekanism.common.item.ItemRobit;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;

public class RobitBakedModel
extends ExtensionBakedModel<ResourceLocation> {
    private final RobitItemOverrideList overrideList = new RobitItemOverrideList(super.func_188617_f());

    public RobitBakedModel(IBakedModel original) {
        super(original);
    }

    @Override
    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.overrideList;
    }

    @Override
    public List<BakedQuad> createQuads(ExtensionBakedModel.QuadsKey<ResourceLocation> key) {
        List<BakedQuad> quads = key.getQuads();
        if (RobitSpriteUploader.UPLOADER != null) {
            ResourceLocation selectedTexture = key.getData();
            QuadTransformation transformation = QuadTransformation.texture(RobitSpriteUploader.UPLOADER.func_215282_a(selectedTexture));
            transformation = QuadTransformation.TextureFilteredTransformation.of(transformation, rl -> rl.func_110623_a().equals("missingno"));
            quads = QuadUtils.transformBakedQuads(quads, transformation);
        }
        return quads;
    }

    @Override
    @Nullable
    public ExtensionBakedModel.QuadsKey<ResourceLocation> createKey(ExtensionBakedModel.QuadsKey<ResourceLocation> key, IModelData data) {
        ResourceLocation skinTexture = (ResourceLocation)data.getData(EntityRobit.SKIN_TEXTURE_PROPERTY);
        if (skinTexture == null) {
            return null;
        }
        return key.data(skinTexture, skinTexture.hashCode(), ResourceLocation::equals);
    }

    protected RobitBakedModel wrapModel(IBakedModel model) {
        return new RobitBakedModel(model);
    }

    private static class RobitItemOverrideList
    extends ItemOverrideList {
        private final ItemOverrideList original;

        RobitItemOverrideList(ItemOverrideList original) {
            this.original = original;
        }

        @Nullable
        public IBakedModel func_239290_a_(@Nonnull IBakedModel model, @Nonnull ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemRobit) {
                IBakedModel customModel;
                RobitSkin skin = ((ItemRobit)stack.func_77973_b()).getRobitSkin(stack).getSkin();
                if (skin.getCustomModel() != null && (customModel = MekanismModelCache.INSTANCE.getRobitSkin(skin)) != null && customModel != model) {
                    return customModel.func_188617_f().func_239290_a_(customModel, stack, world, entity);
                }
                List<ResourceLocation> textures = skin.getTextures();
                if (!textures.isEmpty()) {
                    ModelDataMap modelData = new ModelDataMap.Builder().withInitial(EntityRobit.SKIN_TEXTURE_PROPERTY, (Object)textures.get(0)).build();
                    IBakedModel resolved = this.original.func_239290_a_(model, stack, world, entity);
                    if (resolved == null) {
                        resolved = model;
                    }
                    return new RobitModelDataBakedModel(resolved, (IModelData)modelData);
                }
            }
            return this.original.func_239290_a_(model, stack, world, entity);
        }

        @Nonnull
        public ImmutableList<ItemOverride> getOverrides() {
            return this.original.getOverrides();
        }
    }
}

