/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.slot;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.warning.WarningTracker;
import mekanism.client.jei.interfaces.IJEIGhostTarget;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class GuiSlot
extends GuiTexturedElement
implements IJEIGhostTarget {
    private static final int INVALID_SLOT_COLOR = MekanismRenderer.getColorARGB(EnumColor.DARK_RED, 0.8f);
    public static final int DEFAULT_HOVER_COLOR = -2130706433;
    private final SlotType slotType;
    private Supplier<ItemStack> validityCheck;
    private Supplier<ItemStack> storedStackSupplier;
    private Supplier<SlotOverlay> overlaySupplier;
    @Nullable
    private BooleanSupplier warningSupplier;
    @Nullable
    private IntSupplier overlayColorSupplier;
    @Nullable
    private SlotOverlay overlay;
    @Nullable
    private GuiElement.IHoverable onHover;
    @Nullable
    private GuiElement.IClickable onClick;
    private boolean renderHover;
    private boolean renderAboveSlots;
    @Nullable
    private IJEIGhostTarget.IGhostIngredientConsumer ghostHandler;

    public GuiSlot(SlotType type, IGuiWrapper gui, int x, int y) {
        super(type.getTexture(), gui, x, y, type.getWidth(), type.getHeight());
        this.slotType = type;
        this.field_230693_o_ = false;
    }

    public GuiSlot validity(Supplier<ItemStack> validityCheck) {
        this.validityCheck = validityCheck;
        return this;
    }

    public GuiSlot warning(@Nonnull WarningTracker.WarningType type, @Nonnull BooleanSupplier warningSupplier) {
        this.warningSupplier = this.gui().trackWarning(type, warningSupplier);
        return this;
    }

    public GuiSlot stored(Supplier<ItemStack> storedStackSupplier) {
        this.storedStackSupplier = storedStackSupplier;
        return this;
    }

    public GuiSlot hover(GuiElement.IHoverable onHover) {
        this.onHover = onHover;
        return this;
    }

    public GuiSlot click(GuiElement.IClickable onClick) {
        this.onClick = onClick;
        return this;
    }

    public GuiSlot with(SlotOverlay overlay) {
        this.overlay = overlay;
        return this;
    }

    public GuiSlot overlayColor(IntSupplier colorSupplier) {
        this.overlayColorSupplier = colorSupplier;
        return this;
    }

    public GuiSlot with(Supplier<SlotOverlay> overlaySupplier) {
        this.overlaySupplier = overlaySupplier;
        return this;
    }

    public GuiSlot setRenderHover(boolean renderHover) {
        this.renderHover = renderHover;
        return this;
    }

    public GuiSlot setGhostHandler(@Nullable IJEIGhostTarget.IGhostIngredientConsumer ghostHandler) {
        this.ghostHandler = ghostHandler;
        return this;
    }

    public GuiSlot setRenderAboveSlots() {
        this.renderAboveSlots = true;
        return this;
    }

    @Override
    public void func_230431_b_(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (!this.renderAboveSlots) {
            this.draw(matrix);
        }
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.renderAboveSlots) {
            this.draw(matrix);
        }
    }

    private void draw(@Nonnull MatrixStack matrix) {
        if (this.warningSupplier != null && this.warningSupplier.getAsBoolean()) {
            GuiSlot.minecraft.field_71446_o.func_110577_a(this.slotType.getWarningTexture());
        } else {
            GuiSlot.minecraft.field_71446_o.func_110577_a(this.getResource());
        }
        GuiSlot.func_238463_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)0.0f, (float)0.0f, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)this.field_230688_j_, (int)this.field_230689_k_);
        if (this.overlaySupplier != null) {
            this.overlay = this.overlaySupplier.get();
        }
        if (this.overlay != null) {
            GuiSlot.minecraft.field_71446_o.func_110577_a(this.overlay.getTexture());
            GuiSlot.func_238463_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)0.0f, (float)0.0f, (int)this.overlay.getWidth(), (int)this.overlay.getHeight(), (int)this.overlay.getWidth(), (int)this.overlay.getHeight());
        }
        this.drawContents(matrix);
    }

    protected void drawContents(@Nonnull MatrixStack matrix) {
        ItemStack stored;
        if (this.validityCheck != null) {
            ItemStack invalid = this.validityCheck.get();
            if (!invalid.func_190926_b()) {
                int xPos = this.field_230690_l_ + 1;
                int yPos = this.field_230691_m_ + 1;
                GuiSlot.func_238467_a_((MatrixStack)matrix, (int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + 16), (int)INVALID_SLOT_COLOR);
                MekanismRenderer.resetColor();
                this.gui().renderItem(matrix, invalid, xPos, yPos);
            }
        } else if (this.storedStackSupplier != null && !(stored = this.storedStackSupplier.get()).func_190926_b()) {
            this.gui().renderItem(matrix, stored, this.field_230690_l_ + 1, this.field_230691_m_ + 1);
        }
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        int yPos;
        int xPos;
        if (this.renderHover && this.func_230449_g_()) {
            xPos = this.relativeX + 1;
            yPos = this.relativeY + 1;
            GuiSlot.func_238467_a_((MatrixStack)matrix, (int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + 16), (int)-2130706433);
            MekanismRenderer.resetColor();
        }
        if (this.overlayColorSupplier != null) {
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.0, 0.0, 10.0);
            xPos = this.relativeX + 1;
            yPos = this.relativeY + 1;
            GuiSlot.func_238467_a_((MatrixStack)matrix, (int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + 16), (int)this.overlayColorSupplier.getAsInt());
            matrix.func_227865_b_();
            MekanismRenderer.resetColor();
        }
        if (this.func_230449_g_()) {
            this.func_230443_a_(matrix, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
        }
    }

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        super.func_230443_a_(matrix, mouseX, mouseY);
        if (this.onHover != null) {
            this.onHover.onHover(this, matrix, mouseX, mouseY);
        }
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.onClick != null && this.func_230987_a_(button) && mouseX >= (double)(this.field_230690_l_ + this.borderSize()) && mouseY >= (double)(this.field_230691_m_ + this.borderSize()) && mouseX < (double)(this.field_230690_l_ + this.field_230688_j_ - this.borderSize()) && mouseY < (double)(this.field_230691_m_ + this.field_230689_k_ - this.borderSize())) {
            this.onClick.onClick(this, (int)mouseX, (int)mouseY);
            this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    @Override
    @Nullable
    public IJEIGhostTarget.IGhostIngredientConsumer getGhostHandler() {
        return this.ghostHandler;
    }

    @Override
    public int borderSize() {
        return 1;
    }
}

