/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.gauge;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.gauge.GaugeInfo;
import mekanism.client.gui.element.gauge.GaugeOverlay;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.warning.WarningTracker;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiGauge<T>
extends GuiTexturedElement {
    private final GaugeType gaugeType;
    protected boolean dummy;
    protected T dummyType;
    @Nullable
    private BooleanSupplier warningSupplier;

    public GuiGauge(GaugeType gaugeType, IGuiWrapper gui, int x, int y) {
        this(gaugeType, gui, x, y, gaugeType.getGaugeOverlay().getWidth() + 2, gaugeType.getGaugeOverlay().getHeight() + 2);
    }

    public GuiGauge(GaugeType gaugeType, IGuiWrapper gui, int x, int y, int sizeX, int sizeY) {
        super(gaugeType.getGaugeOverlay().getBarOverlay(), gui, x, y, sizeX, sizeY);
        this.gaugeType = gaugeType;
    }

    public GuiGauge<T> warning(@Nonnull WarningTracker.WarningType type, @Nonnull BooleanSupplier warningSupplier) {
        this.warningSupplier = this.gui().trackWarning(type, warningSupplier);
        return this;
    }

    public abstract int getScaledLevel();

    public abstract TextureAtlasSprite getIcon();

    public abstract ITextComponent getLabel();

    public abstract List<ITextComponent> getTooltipText();

    public GaugeOverlay getGaugeOverlay() {
        return this.gaugeType.getGaugeOverlay();
    }

    protected GaugeInfo getGaugeColor() {
        return this.gaugeType.getGaugeInfo();
    }

    protected void applyRenderColor() {
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        GaugeInfo color = this.getGaugeColor();
        this.renderExtendedTexture(matrix, color.getResourceLocation(), color.getSideWidth(), color.getSideHeight());
        if (!this.dummy) {
            this.renderContents(matrix);
        }
    }

    public void renderContents(MatrixStack matrix) {
        boolean warning;
        boolean bl = warning = this.warningSupplier != null && this.warningSupplier.getAsBoolean();
        if (warning) {
            GuiGauge.minecraft.field_71446_o.func_110577_a(GuiSlot.WARNING_BACKGROUND_TEXTURE);
            GuiGauge.func_238463_a_((MatrixStack)matrix, (int)(this.field_230690_l_ + 1), (int)(this.field_230691_m_ + 1), (float)0.0f, (float)0.0f, (int)(this.field_230688_j_ - 2), (int)(this.field_230689_k_ - 2), (int)256, (int)256);
        }
        int scale = this.getScaledLevel();
        TextureAtlasSprite icon = this.getIcon();
        if (scale > 0 && icon != null) {
            this.applyRenderColor();
            this.drawTiledSprite(matrix, this.field_230690_l_ + 1, this.field_230691_m_ + 1, this.field_230689_k_ - 2, this.field_230688_j_ - 2, scale, icon, GuiUtils.TilingDirection.UP_RIGHT);
            MekanismRenderer.resetColor();
            if (warning && scale == this.field_230689_k_ - 2) {
                GuiGauge.minecraft.field_71446_o.func_110577_a(WARNING_TEXTURE);
                int halfWidth = (this.field_230688_j_ - 2) / 2;
                GuiGauge.func_238463_a_((MatrixStack)matrix, (int)(this.field_230690_l_ + 1 + halfWidth), (int)(this.field_230691_m_ + 1), (float)halfWidth, (float)0.0f, (int)halfWidth, (int)(this.field_230689_k_ - 2), (int)256, (int)256);
            }
        }
        this.drawBarOverlay(matrix);
    }

    public void drawBarOverlay(MatrixStack matrix) {
        GuiGauge.minecraft.field_71446_o.func_110577_a(this.getResource());
        GaugeOverlay gaugeOverlay = this.getGaugeOverlay();
        GuiGauge.func_238466_a_((MatrixStack)matrix, (int)(this.field_230690_l_ + 1), (int)(this.field_230691_m_ + 1), (int)(this.func_230998_h_() - 2), (int)(this.func_238483_d_() - 2), (float)0.0f, (float)0.0f, (int)gaugeOverlay.getWidth(), (int)gaugeOverlay.getHeight(), (int)gaugeOverlay.getWidth(), (int)gaugeOverlay.getHeight());
    }

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        super.func_230443_a_(matrix, mouseX, mouseY);
        ItemStack stack = GuiGauge.minecraft.field_71439_g.field_71071_by.func_70445_o();
        EnumColor color = this.getGaugeColor().getColor();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemConfigurator && color != null) {
            Object tile;
            if (this.gui() instanceof GuiMekanismTile && (tile = ((GuiMekanismTile)this.gui()).getTileEntity()) instanceof ISideConfiguration && this.getTransmission() != null) {
                DataType dataType = null;
                ConfigInfo config = ((ISideConfiguration)tile).getConfig().getConfig(this.getTransmission());
                if (config != null) {
                    Set<DataType> supportedDataTypes = config.getSupportedDataTypes();
                    for (DataType type : supportedDataTypes) {
                        if (type.getColor() != color) continue;
                        dataType = type;
                        break;
                    }
                }
                if (dataType == null) {
                    this.displayTooltip(matrix, (ITextComponent)MekanismLang.GENERIC_PARENTHESIS.translateColored(color, color.getName()), mouseX, mouseY);
                } else {
                    this.displayTooltip(matrix, (ITextComponent)MekanismLang.GENERIC_WITH_PARENTHESIS.translateColored(color, dataType, color.getName()), mouseX, mouseY);
                }
            }
        } else {
            ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
            if (this.getLabel() != null) {
                list.add(this.getLabel());
            }
            list.addAll(this.getTooltipText());
            this.displayTooltips(matrix, list, mouseX, mouseY);
        }
    }

    @Nullable
    public abstract TransmissionType getTransmission();

    public void setDummyType(T type) {
        this.dummyType = type;
    }
}

