/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.FluidStackIngredient;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class RotaryRecipe
extends MekanismRecipe {
    private static final GasStackIngredient EMPTY_GAS_INPUT = GasStackIngredient.from(GasStack.EMPTY);
    private static final FluidStackIngredient EMPTY_FLUID_INPUT = FluidStackIngredient.from(FluidStack.EMPTY);
    private final GasStackIngredient gasInput;
    private final FluidStackIngredient fluidInput;
    private final FluidStack fluidOutput;
    private final GasStack gasOutput;
    private final boolean hasGasToFluid;
    private final boolean hasFluidToGas;

    public RotaryRecipe(ResourceLocation id, FluidStackIngredient fluidInput, GasStack gasOutput) {
        super(id);
        this.fluidInput = Objects.requireNonNull(fluidInput, "Fluid input cannot be null.");
        Objects.requireNonNull(gasOutput, "Gas output cannot be null.");
        if (gasOutput.isEmpty()) {
            throw new IllegalArgumentException("Gas output cannot be empty.");
        }
        this.gasOutput = gasOutput.copy();
        this.gasInput = EMPTY_GAS_INPUT;
        this.fluidOutput = FluidStack.EMPTY;
        this.hasGasToFluid = false;
        this.hasFluidToGas = true;
    }

    public RotaryRecipe(ResourceLocation id, GasStackIngredient gasInput, FluidStack fluidOutput) {
        super(id);
        this.gasInput = Objects.requireNonNull(gasInput, "Gas input cannot be null.");
        Objects.requireNonNull(fluidOutput, "Fluid output cannot be null.");
        if (fluidOutput.isEmpty()) {
            throw new IllegalArgumentException("Fluid output cannot be empty.");
        }
        this.fluidOutput = fluidOutput.copy();
        this.fluidInput = EMPTY_FLUID_INPUT;
        this.gasOutput = GasStack.EMPTY;
        this.hasGasToFluid = true;
        this.hasFluidToGas = false;
    }

    public RotaryRecipe(ResourceLocation id, FluidStackIngredient fluidInput, GasStackIngredient gasInput, GasStack gasOutput, FluidStack fluidOutput) {
        super(id);
        this.gasInput = Objects.requireNonNull(gasInput, "Gas input cannot be null.");
        this.fluidInput = Objects.requireNonNull(fluidInput, "Fluid input cannot be null.");
        Objects.requireNonNull(gasOutput, "Gas output cannot be null.");
        Objects.requireNonNull(fluidOutput, "Fluid output cannot be null.");
        if (gasOutput.isEmpty()) {
            throw new IllegalArgumentException("Gas output cannot be empty.");
        }
        if (fluidOutput.isEmpty()) {
            throw new IllegalArgumentException("Fluid output cannot be empty.");
        }
        this.gasOutput = gasOutput.copy();
        this.fluidOutput = fluidOutput.copy();
        this.hasGasToFluid = true;
        this.hasFluidToGas = true;
    }

    public boolean hasGasToFluid() {
        return this.hasGasToFluid;
    }

    public boolean hasFluidToGas() {
        return this.hasFluidToGas;
    }

    public boolean test(FluidStack fluidStack) {
        return this.hasFluidToGas() && this.fluidInput.test(fluidStack);
    }

    public boolean test(GasStack gasStack) {
        return this.hasGasToFluid() && this.gasInput.test(gasStack);
    }

    public FluidStackIngredient getFluidInput() {
        return this.fluidInput;
    }

    public GasStackIngredient getGasInput() {
        return this.gasInput;
    }

    @Deprecated
    public GasStack getGasOutputRepresentation() {
        return this.gasOutput;
    }

    public List<GasStack> getGasOutputDefinition() {
        return Collections.singletonList(this.gasOutput);
    }

    @Deprecated
    public FluidStack getFluidOutputRepresentation() {
        return this.fluidOutput;
    }

    public List<FluidStack> getFluidOutputDefinition() {
        return Collections.singletonList(this.fluidOutput);
    }

    @Contract(value="_ -> new", pure=true)
    public GasStack getGasOutput(FluidStack input) {
        return this.gasOutput.copy();
    }

    @Contract(value="_ -> new", pure=true)
    public FluidStack getFluidOutput(GasStack input) {
        return this.fluidOutput.copy();
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeBoolean(this.hasFluidToGas);
        if (this.hasFluidToGas) {
            this.fluidInput.write(buffer);
            this.gasOutput.writeToPacket(buffer);
        }
        buffer.writeBoolean(this.hasGasToFluid);
        if (this.hasGasToFluid) {
            this.gasInput.write(buffer);
            this.fluidOutput.writeToPacket(buffer);
        }
    }
}

