/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import javax.annotation.Nonnull;
import mekanism.api.math.MathUtils;
import mekanism.api.text.APILang;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import net.minecraft.util.Direction;

public enum RelativeSide implements IHasTranslationKey
{
    FRONT(APILang.FRONT),
    LEFT(APILang.LEFT),
    RIGHT(APILang.RIGHT),
    BACK(APILang.BACK),
    TOP(APILang.TOP),
    BOTTOM(APILang.BOTTOM);

    private static final RelativeSide[] SIDES;
    private final ILangEntry langEntry;

    public static RelativeSide byIndex(int index) {
        return MathUtils.getByIndexMod(SIDES, index);
    }

    private RelativeSide(ILangEntry langEntry) {
        this.langEntry = langEntry;
    }

    @Override
    public String getTranslationKey() {
        return this.langEntry.getTranslationKey();
    }

    public Direction getDirection(@Nonnull Direction facing) {
        if (this == FRONT) {
            return facing;
        }
        if (this == BACK) {
            return facing.func_176734_d();
        }
        if (this == LEFT) {
            if (facing == Direction.DOWN || facing == Direction.UP) {
                return Direction.EAST;
            }
            return facing.func_176746_e();
        }
        if (this == RIGHT) {
            if (facing == Direction.DOWN || facing == Direction.UP) {
                return Direction.WEST;
            }
            return facing.func_176735_f();
        }
        if (this == TOP) {
            if (facing == Direction.DOWN) {
                return Direction.NORTH;
            }
            if (facing == Direction.UP) {
                return Direction.SOUTH;
            }
            return Direction.UP;
        }
        if (this == BOTTOM) {
            if (facing == Direction.DOWN) {
                return Direction.SOUTH;
            }
            if (facing == Direction.UP) {
                return Direction.NORTH;
            }
            return Direction.DOWN;
        }
        return Direction.NORTH;
    }

    public static RelativeSide fromDirections(@Nonnull Direction facing, @Nonnull Direction side) {
        if (side == facing) {
            return FRONT;
        }
        if (side == facing.func_176734_d()) {
            return BACK;
        }
        if (facing == Direction.DOWN || facing == Direction.UP) {
            if (side == Direction.NORTH) {
                return facing == Direction.DOWN ? TOP : BOTTOM;
            }
            if (side == Direction.SOUTH) {
                return facing == Direction.DOWN ? BOTTOM : TOP;
            }
            if (side == Direction.WEST) {
                return RIGHT;
            }
            if (side == Direction.EAST) {
                return LEFT;
            }
        } else {
            if (side == Direction.DOWN) {
                return BOTTOM;
            }
            if (side == Direction.UP) {
                return TOP;
            }
            if (side == facing.func_176735_f()) {
                return RIGHT;
            }
            if (side == facing.func_176746_e()) {
                return LEFT;
            }
        }
        return FRONT;
    }

    static {
        SIDES = RelativeSide.values();
    }
}

