/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.registry.trade;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.shedaniel.architectury.registry.trade.VillagerTradeOfferContext;
import me.shedaniel.architectury.registry.trade.WanderingTraderOfferContext;
import me.shedaniel.architectury.registry.trade.forge.TradeRegistryImpl;
import me.shedaniel.architectury.registry.trade.impl.TradeRegistryData;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;

public class TradeRegistry {
    private TradeRegistry() {
    }

    public static void registerVillagerTrade(VillagerProfession profession, int level, VillagerTrades.ITrade ... trades) {
        if (level < 1) {
            throw new IllegalArgumentException("Villager Trade level has to be at least 1!");
        }
        TradeRegistry.registerVillagerTrade0(profession, level, trades);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerVillagerTrade0(VillagerProfession profession, int level, VillagerTrades.ITrade ... trades) {
        void var2_2;
        void var1_1;
        TradeRegistryImpl.registerVillagerTrade0(profession, (int)var1_1, (VillagerTrades.ITrade[])var2_2);
    }

    public static void setVillagerMaxOffers(VillagerProfession profession, int level, int maxOffers) {
        if (level < 1) {
            throw new IllegalArgumentException("Villager Trade level has to be at least 1!");
        }
        if (maxOffers < 0) {
            throw new IllegalArgumentException("Villager's max offers has to be at least 0!");
        }
        Map map = TradeRegistryData.VILLAGER_MAX_OFFER_OVERRIDES.computeIfAbsent(profession, k -> new HashMap());
        map.put(level, maxOffers);
    }

    public static void modifyVillagerOffers(Consumer<VillagerTradeOfferContext> callback) {
        Objects.requireNonNull(callback);
        TradeRegistryData.VILLAGER_MODIFY_HANDLERS.add(callback);
    }

    public static void removeVillagerOffers(Predicate<VillagerTradeOfferContext> filter) {
        Objects.requireNonNull(filter);
        TradeRegistryData.VILLAGER_REMOVE_HANDLERS.add(filter);
    }

    public static void modifyWanderingTraderOffers(Consumer<WanderingTraderOfferContext> callback) {
        Objects.requireNonNull(callback);
        TradeRegistryData.WANDERING_TRADER_MODIFY_HANDLERS.add(callback);
    }

    public static void removeWanderingTraderOffers(Predicate<WanderingTraderOfferContext> filter) {
        Objects.requireNonNull(filter);
        TradeRegistryData.WANDERING_TRADER_REMOVE_HANDLERS.add(filter);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerTradeForWanderingTrader(boolean rare, VillagerTrades.ITrade ... trades) {
        void var1_1;
        TradeRegistryImpl.registerTradeForWanderingTrader(rare, (VillagerTrades.ITrade[])var1_1);
    }

    public static void setWanderingTraderMaxOffers(int maxOffers) {
        if (maxOffers < 0) {
            throw new IllegalArgumentException("Wandering trader's max offers has to be at least 0!");
        }
        TradeRegistryData.wanderingTraderMaxOfferOverride = maxOffers;
    }
}

