/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder.types;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import exopandora.worldhandler.builder.types.BlockResourceLocation;
import exopandora.worldhandler.builder.types.CoordinateDouble;
import exopandora.worldhandler.builder.types.CoordinateInt;
import exopandora.worldhandler.builder.types.GreedyString;
import exopandora.worldhandler.builder.types.ItemResourceLocation;
import exopandora.worldhandler.builder.types.TargetSelector;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum ArgumentType {
    SHORT(Short::valueOf),
    BYTE(Byte::valueOf),
    INT(Integer::valueOf),
    FLOAT(Float::valueOf),
    DOUBLE(Double::valueOf),
    LONG(Long::valueOf),
    BOOLEAN(Boolean::valueOf),
    STRING(String::valueOf),
    GREEDY_STRING(GreedyString::valueOf),
    RESOURCE_LOCATION(ArgumentType::parseResourceLocation),
    ITEM_RESOURCE_LOCATION(ItemResourceLocation::valueOf),
    BLOCK_RESOURCE_LOCATION(BlockResourceLocation::valueOf),
    NBT(ArgumentType::parseCompoundNBT),
    COORDINATE_INT(CoordinateInt::valueOf),
    COORDINATE_DOUBLE(CoordinateDouble::valueOf),
    TARGET_SELECTOR(TargetSelector::valueOf),
    PLAYER(String::valueOf);

    private final Function<String, Object> parser;

    private ArgumentType(Function<String, Object> parser) {
        this.parser = parser;
    }

    @Nullable
    public <T> T parse(String object) {
        return (T)this.parser.apply(object);
    }

    public <T> T parseOfDefault(String object, T def) {
        try {
            return this.parse(object);
        }
        catch (Exception e) {
            return def;
        }
    }

    @Nullable
    public static ResourceLocation parseResourceLocation(String value) {
        return value != null && !value.isEmpty() ? new ResourceLocation(value) : null;
    }

    @Nullable
    public static CompoundNBT parseCompoundNBT(String value) {
        if (value != null) {
            try {
                return JsonToNBT.func_180713_a((String)value);
            }
            catch (CommandSyntaxException e) {
                return null;
            }
        }
        return null;
    }
}

