/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler;

import com.mojang.brigadier.CommandDispatcher;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.event.ClientEventHandler;
import exopandora.worldhandler.event.KeyHandler;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.usercontent.UsercontentLoader;
import exopandora.worldhandler.util.AdvancementHelper;
import exopandora.worldhandler.util.CommandHelper;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.CommandSource;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="worldhandler")
public class WorldHandler {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Path USERCONTENT_PATH = FMLPaths.CONFIGDIR.get().resolve("worldhandler").resolve("usercontent");

    public WorldHandler() {
        final IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        final ModLoadingContext modLoadingContext = ModLoadingContext.get();
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 1457410143759855413L;

            public void run() {
                SimpleReloadableResourceManager manager = (SimpleReloadableResourceManager)Minecraft.func_71410_x().func_195551_G();
                manager.func_219534_a((IFutureReloadListener)AdvancementHelper.getInstance());
                Config.setupDirectories(USERCONTENT_PATH);
                modLoadingContext.registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_SPEC, "worldhandler/worldhandler.toml");
                UsercontentLoader.load(USERCONTENT_PATH);
                modEventBus.register(Config.class);
                modEventBus.addListener(WorldHandler.this::clientSetup);
                modEventBus.addListener(Content::createRegistry);
                modEventBus.addListener(Category::createRegistry);
                modEventBus.addGenericListener(Content.class, Content::register);
                modEventBus.addGenericListener(Category.class, Category::register);
            }
        });
        modLoadingContext.registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(KeyHandler::keyInputEvent);
        MinecraftForge.EVENT_BUS.addListener(ClientEventHandler::renderWorldLastEvent);
        MinecraftForge.EVENT_BUS.addListener(ClientEventHandler::clientChatEvent);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyHandler.KEY_WORLD_HANDLER);
        KeyHandler.updatePosKeys();
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        CommandHelper.registerCommands((CommandDispatcher<CommandSource>)event.getDispatcher());
    }
}

