/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.inventory;

import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.BlockFace;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class CapManipulationBehaviourBase<T, S extends CapManipulationBehaviourBase<?, ?>>
extends TileEntityBehaviour {
    protected InterfaceProvider target;
    protected LazyOptional<T> targetCapability;
    protected boolean simulateNext;
    protected boolean bypassSided;
    private boolean findNewNextTick;

    public CapManipulationBehaviourBase(SmartTileEntity te, InterfaceProvider target) {
        super(te);
        this.setLazyTickRate(5);
        this.target = target;
        this.targetCapability = LazyOptional.empty();
        this.simulateNext = false;
        this.bypassSided = false;
    }

    protected abstract Capability<T> capability();

    @Override
    public void initialize() {
        super.initialize();
        this.findNewNextTick = true;
    }

    @Override
    public void onNeighborChanged(BlockPos neighborPos) {
        BlockFace targetBlockFace = this.target.getTarget(this.getWorld(), this.tileEntity.func_174877_v(), this.tileEntity.func_195044_w());
        if (targetBlockFace.getConnectedPos().equals((Object)neighborPos)) {
            this.onHandlerInvalidated(this.targetCapability);
        }
    }

    public S bypassSidedness() {
        this.bypassSided = true;
        return (S)this;
    }

    public S simulate() {
        this.simulateNext = true;
        return (S)this;
    }

    public boolean hasInventory() {
        return this.targetCapability.isPresent();
    }

    @Nullable
    public T getInventory() {
        return (T)this.targetCapability.orElse(null);
    }

    protected void onHandlerInvalidated(LazyOptional<T> handler) {
        this.findNewNextTick = true;
        this.targetCapability = LazyOptional.empty();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (!this.targetCapability.isPresent()) {
            this.findNewCapability();
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.findNewNextTick || this.getWorld().func_82737_E() % 64L == 0L) {
            this.findNewNextTick = false;
            this.findNewCapability();
        }
    }

    public int getAmountFromFilter() {
        int amount = -1;
        FilteringBehaviour filter = this.tileEntity.getBehaviour(FilteringBehaviour.TYPE);
        if (filter != null && !filter.anyAmount()) {
            amount = filter.getAmount();
        }
        return amount;
    }

    public void findNewCapability() {
        World world = this.getWorld();
        BlockFace targetBlockFace = this.target.getTarget(world, this.tileEntity.func_174877_v(), this.tileEntity.func_195044_w()).getOpposite();
        BlockPos pos = targetBlockFace.getPos();
        this.targetCapability = LazyOptional.empty();
        if (!world.func_195588_v(pos)) {
            return;
        }
        TileEntity invTE = world.func_175625_s(pos);
        if (invTE == null) {
            return;
        }
        Capability<T> capability = this.capability();
        LazyOptional lazyOptional = this.targetCapability = this.bypassSided ? invTE.getCapability(capability) : invTE.getCapability(capability, targetBlockFace.getFace());
        if (this.targetCapability.isPresent()) {
            this.targetCapability.addListener(this::onHandlerInvalidated);
        }
    }

    @FunctionalInterface
    public static interface InterfaceProvider {
        public static InterfaceProvider towardBlockFacing() {
            return (w, p, s) -> new BlockFace(p, s.func_235901_b_((Property)BlockStateProperties.field_208155_H) ? (Direction)s.func_177229_b((Property)BlockStateProperties.field_208155_H) : (Direction)s.func_177229_b((Property)BlockStateProperties.field_208157_J));
        }

        public static InterfaceProvider oppositeOfBlockFacing() {
            return (w, p, s) -> new BlockFace(p, (s.func_235901_b_((Property)BlockStateProperties.field_208155_H) ? (Direction)s.func_177229_b((Property)BlockStateProperties.field_208155_H) : (Direction)s.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d());
        }

        public BlockFace getTarget(World var1, BlockPos var2, BlockState var3);
    }
}

