/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.command.SConfigureConfigPacket;
import com.simibubi.create.foundation.config.ui.ConfigHelper;
import com.simibubi.create.foundation.networking.AllPackets;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.network.PacketDistributor;

public class ConfigCommand {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"config").executes(ctx -> {
            ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
            AllPackets.channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SConfigureConfigPacket(SConfigureConfigPacket.Actions.configScreen.name(), ""));
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"path", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
            AllPackets.channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SConfigureConfigPacket(SConfigureConfigPacket.Actions.configScreen.name(), StringArgumentType.getString((CommandContext)ctx, (String)"path")));
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").requires(cs -> cs.func_197034_c(2))).then(Commands.func_197056_a((String)"value", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            ConfigHelper.ConfigPath configPath;
            String path = StringArgumentType.getString((CommandContext)ctx, (String)"path");
            String value = StringArgumentType.getString((CommandContext)ctx, (String)"value");
            try {
                configPath = ConfigHelper.ConfigPath.parse(path);
            }
            catch (IllegalArgumentException e) {
                ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)new StringTextComponent(e.getMessage()));
                return 0;
            }
            if (configPath.getType() == ModConfig.Type.CLIENT) {
                ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
                AllPackets.channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SConfigureConfigPacket("SET" + path, value));
                return 1;
            }
            try {
                ConfigHelper.setConfigValue(configPath, value);
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Great Success!"), false);
                return 1;
            }
            catch (ConfigHelper.InvalidValueException e) {
                ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Config could not be set the the specified value!"));
                return 0;
            }
            catch (Exception e) {
                ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Something went wrong while trying to set config value. Check the server logs for more information"));
                Create.LOGGER.warn("Exception during server-side config value set:", (Throwable)e);
                return 0;
            }
        }))));
    }
}

