/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.pipes;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidValveBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidValveTileEntity;
import com.simibubi.create.foundation.render.PartialBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;

public class FluidValveRenderer
extends KineticTileEntityRenderer {
    public FluidValveRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (Backend.getInstance().canUseInstancing(te.func_145831_w())) {
            return;
        }
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        BlockState blockState = te.func_195044_w();
        SuperByteBuffer pointer = PartialBufferer.get(AllBlockPartials.FLUID_VALVE_POINTER, blockState);
        Direction facing = (Direction)blockState.func_177229_b((Property)FluidValveBlock.FACING);
        if (!(te instanceof FluidValveTileEntity)) {
            return;
        }
        FluidValveTileEntity valve = (FluidValveTileEntity)te;
        float pointerRotation = MathHelper.func_219799_g((float)valve.pointer.getValue(partialTicks), (float)0.0f, (float)-90.0f);
        Direction.Axis pipeAxis = FluidValveBlock.getPipeAxis(blockState);
        Direction.Axis shaftAxis = KineticTileEntityRenderer.getRotationAxisOf(te);
        int pointerRotationOffset = 0;
        if (pipeAxis.func_176722_c() && shaftAxis == Direction.Axis.Z || pipeAxis.func_200128_b()) {
            pointerRotationOffset = 90;
        }
        MatrixTransformStack.of((MatrixStack)ms).centre().rotateY((double)AngleHelper.horizontalAngle(facing)).rotateX(facing == Direction.UP ? 0.0 : (facing == Direction.DOWN ? 180.0 : 90.0)).rotateY((double)((float)pointerRotationOffset + pointerRotation)).unCentre();
        pointer.light(light).renderInto(ms, buffer.getBuffer(RenderType.func_228639_c_()));
    }

    @Override
    protected BlockState getRenderedBlockState(KineticTileEntity te) {
        return KineticTileEntityRenderer.shaft(KineticTileEntityRenderer.getRotationAxisOf(te));
    }
}

