/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.gui.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IHasContainer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.phosphophyllite.gui.client.RenderHelper;
import net.roguelogix.phosphophyllite.gui.client.api.IRender;
import net.roguelogix.phosphophyllite.gui.client.api.ITooltip;
import net.roguelogix.phosphophyllite.gui.client.elements.AbstractElement;

@OnlyIn(value=Dist.CLIENT)
public class ScreenBase<T extends Container>
extends ContainerScreen<T>
implements IHasContainer<T> {
    private final List<AbstractElement> screenElements;
    protected ResourceLocation textureAtlas;

    public ScreenBase(T screenContainer, PlayerInventory playerInventory, ITextComponent title, ResourceLocation textureAtlas, int width, int height) {
        super(screenContainer, playerInventory, title);
        this.textureAtlas = textureAtlas;
        this.field_146999_f = width;
        this.field_147000_g = height;
        this.screenElements = Lists.newArrayList();
    }

    public void addElement(AbstractElement element) {
        if (element != null) {
            this.screenElements.add(element);
        }
    }

    public int getWidth() {
        return this.field_146999_f;
    }

    public int getHeight() {
        return this.field_147000_g;
    }

    public FontRenderer getFont() {
        return this.field_230712_o_;
    }

    public void setTextureAtlas(ResourceLocation textureAtlas) {
        this.textureAtlas = textureAtlas;
    }

    public void func_230430_a_(@Nonnull MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(mStack);
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(mStack, mouseX, mouseY);
        for (AbstractElement element : this.screenElements) {
            if (!(element instanceof ITooltip)) continue;
            ((ITooltip)((Object)element)).renderTooltip(mStack, mouseX, mouseY);
        }
    }

    protected void func_230451_b_(@Nonnull MatrixStack mStack, int mouseX, int mouseY) {
        RenderHelper.bindTexture(this.textureAtlas);
        RenderHelper.setRenderColor(1.0f, 1.0f, 1.0f, 1.0f);
        for (AbstractElement element : this.screenElements) {
            if (!(element instanceof IRender)) continue;
            ((IRender)((Object)element)).render(mStack, mouseX, mouseY);
        }
        this.field_230712_o_.func_238421_b_(mStack, this.field_230704_d_.getString(), (float)this.field_238742_p_, (float)this.field_238743_q_, 0x404040);
    }

    protected void func_230450_a_(@Nonnull MatrixStack mStack, float partialTicks, int mouseX, int mouseY) {
        RenderHelper.bindTexture(this.textureAtlas);
        RenderHelper.setRenderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.func_238474_b_(mStack, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public boolean isMouseOver(double mouseX, double mouseY, double areaX, double areaY, int areaWidth, int areaHeight) {
        int relativeX = (int)((double)this.getGuiLeft() + areaX);
        int relativeY = (int)((double)this.getGuiTop() + areaY);
        return mouseX > (double)relativeX && mouseX < (double)(relativeX + areaWidth) && mouseY > (double)relativeY && mouseY < (double)(relativeY + areaHeight);
    }

    public void func_231023_e_() {
        for (AbstractElement element : this.screenElements) {
            element.func_110550_d();
        }
    }

    public void func_212927_b(double mouseX, double mouseY) {
        for (AbstractElement element : this.screenElements) {
            if (!(element instanceof IGuiEventListener)) continue;
            element.func_212927_b(mouseX, mouseY);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        boolean handled = false;
        for (AbstractElement element : this.screenElements) {
            if (!(element instanceof IGuiEventListener)) continue;
            handled = handled || element.func_231044_a_(mouseX, mouseY, button);
        }
        return handled || super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        boolean handled = false;
        for (AbstractElement element : this.screenElements) {
            if (!(element instanceof IGuiEventListener)) continue;
            handled = handled || element.func_231048_c_(mouseX, mouseY, button);
        }
        return handled || super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean handled = false;
        for (AbstractElement element : this.screenElements) {
            if (!(element instanceof IGuiEventListener)) continue;
            handled = handled || element.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
        }
        return handled || super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        boolean handled = false;
        for (AbstractElement element : this.screenElements) {
            if (!(element instanceof IGuiEventListener)) continue;
            handled = handled || element.func_231043_a_(mouseX, mouseY, delta);
        }
        return handled || super.func_231043_a_(mouseX, mouseY, delta);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        boolean handled = false;
        for (AbstractElement element : this.screenElements) {
            if (!(element instanceof IGuiEventListener)) continue;
            handled = handled || element.func_231046_a_(keyCode, scanCode, modifiers);
        }
        return handled || super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        boolean handled = false;
        for (AbstractElement element : this.screenElements) {
            if (!(element instanceof IGuiEventListener)) continue;
            handled = handled || element.func_223281_a_(keyCode, scanCode, modifiers);
        }
        return handled || super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        boolean handled = false;
        for (AbstractElement element : this.screenElements) {
            if (!(element instanceof IGuiEventListener)) continue;
            handled = handled || element.func_231042_a_(codePoint, modifiers);
        }
        return handled || super.func_231042_a_(codePoint, modifiers);
    }
}

