/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.roguelogix.phosphophyllite.PhosphophylliteConfig;
import net.roguelogix.phosphophyllite.multiblock.generic.MultiblockController;
import net.roguelogix.phosphophyllite.multiblock.generic.MultiblockTile;
import net.roguelogix.phosphophyllite.registry.Registry;
import net.roguelogix.phosphophyllite.threading.Queues;
import net.roguelogix.phosphophyllite.threading.WorkQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="phosphophyllite")
public class Phosphophyllite {
    public static final String modid = "phosphophyllite";
    public static final Logger LOGGER = LogManager.getLogger((String)"Phosphophyllite/Main");
    public static long lastTime = 0L;
    private static long tick = 0L;
    public static DataPackRegistries dataPackRegistries;
    public static final WorkQueue serverQueue;
    private static final HashMap<ServerWorld, ArrayList<MultiblockController<?, ?, ?>>> controllersToTick;
    private static final HashMap<ServerWorld, ArrayList<MultiblockTile<?, ?, ?>>> tilesToAttach;
    private static final ArrayList<MultiblockController<?, ?, ?>> newControllers;
    private static final ArrayList<MultiblockController<?, ?, ?>> oldControllers;
    private static final ArrayList<MultiblockTile<?, ?, ?>> newTiles;

    public Phosphophyllite() {
        new Registry();
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (PhosphophylliteConfig.bypassPerformantCheck) {
            LOGGER.warn("Performant check bypassed");
            LOGGER.warn("Performant " + (FMLLoader.getLoadingModList().getModFileById("performant") != null ? "is" : "is not") + " present");
        } else if (FMLLoader.getLoadingModList().getModFileById("performant") != null) {
            throw new IllegalStateException("Performant is incompatible with Phosphophyllite\nThis is a known issue with performant and it breaking other mods, the author does not care\nGitHub issue on the matter: https://github.com/someaddons/performant_issues/issues/70\nTo bypass this check add \"bypassPerformantCheck: true\" to your phosphophyllite config\nIf you bypass this check I (RogueLogix) will not provide any support for any issues related to Phosphophyllite or the mods that use it\nIf you believe your issue is unrelated, disable performant and reproduce it\nBy choosing to bypass this check you understand that here there be dragons");
        }
    }

    @SubscribeEvent
    public void onAddReloadListenerEvent(AddReloadListenerEvent reloadListenerEvent) {
        dataPackRegistries = reloadListenerEvent.getDataPackRegistries();
    }

    @SubscribeEvent
    public void onServerStopped(FMLServerStoppedEvent serverStoppedEvent) {
        dataPackRegistries = null;
    }

    public static long tickNumber() {
        return tick;
    }

    public static void addController(MultiblockController<?, ?, ?> controller) {
        newControllers.add(controller);
    }

    public static void removeController(MultiblockController<?, ?, ?> controller) {
        oldControllers.add(controller);
    }

    public static void attachTile(MultiblockTile<?, ?, ?> tile) {
        newTiles.add(tile);
    }

    @SubscribeEvent
    void onWorldUnload(WorldEvent.Unload worldUnloadEvent) {
        if (!worldUnloadEvent.getWorld().func_201670_d()) {
            ArrayList<MultiblockController<?, ?, ?>> controllersToTick = Phosphophyllite.controllersToTick.remove(worldUnloadEvent.getWorld());
            if (controllersToTick != null) {
                for (MultiblockController<?, ?, ?> multiblockController2 : controllersToTick) {
                    multiblockController2.suicide();
                }
            }
            tilesToAttach.remove(worldUnloadEvent.getWorld());
            newControllers.removeIf(multiblockController -> multiblockController.getWorld() == worldUnloadEvent.getWorld());
            oldControllers.removeIf(multiblockController -> multiblockController.getWorld() == worldUnloadEvent.getWorld());
            newTiles.removeIf(multiblockTile -> multiblockTile.func_145831_w() == worldUnloadEvent.getWorld());
        }
    }

    @SubscribeEvent
    public void advanceTick(TickEvent.ServerTickEvent e) {
        if (!e.side.isServer()) {
            return;
        }
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        ++tick;
        Queues.serverThread.runAll();
        for (MultiblockController<?, ?, ?> multiblockController : newControllers) {
            controllersToTick.computeIfAbsent((ServerWorld)multiblockController.getWorld(), k -> new ArrayList()).add(multiblockController);
        }
        newControllers.clear();
        for (MultiblockController<?, ?, ?> multiblockController : oldControllers) {
            ArrayList<MultiblockController<?, ?, ?>> controllers = controllersToTick.get(multiblockController.getWorld());
            controllers.remove(multiblockController);
        }
        oldControllers.clear();
        for (MultiblockTile multiblockTile : newTiles) {
            tilesToAttach.computeIfAbsent((ServerWorld)multiblockTile.func_145831_w(), k -> new ArrayList()).add(multiblockTile);
        }
        newTiles.clear();
    }

    @SubscribeEvent
    public void tickWorld(TickEvent.WorldTickEvent e) {
        ArrayList<MultiblockTile<?, ?, ?>> tilesToAttach;
        if (!(e.world instanceof ServerWorld)) {
            return;
        }
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        ArrayList<MultiblockController<?, ?, ?>> controllersToTick = Phosphophyllite.controllersToTick.get(e.world);
        if (controllersToTick != null) {
            for (MultiblockController<?, ?, ?> controller : controllersToTick) {
                if (controller == null) continue;
                controller.update();
            }
        }
        if ((tilesToAttach = Phosphophyllite.tilesToAttach.get(e.world)) != null) {
            tilesToAttach.sort(Comparator.comparing(TileEntity::func_174877_v));
            for (MultiblockTile<?, ?, ?> toAttach : tilesToAttach) {
                if (toAttach == null) continue;
                toAttach.attachToNeighbors();
            }
            tilesToAttach.clear();
        }
    }

    static {
        serverQueue = Queues.serverThread;
        controllersToTick = new HashMap();
        tilesToAttach = new HashMap();
        newControllers = new ArrayList();
        oldControllers = new ArrayList();
        newTiles = new ArrayList();
    }
}

