/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.entities;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.corelib.CachedMap;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.entities.DummyPlayer;
import de.maxhenkel.corpse.entities.DummySkeleton;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class CorpseRenderer
extends EntityRenderer<CorpseEntity> {
    private final CachedMap<CorpseEntity, DummyPlayer> players = new CachedMap(10000L);
    private final CachedMap<CorpseEntity, DummySkeleton> skeletons = new CachedMap(10000L);
    private static final Minecraft MC = Minecraft.func_71410_x();

    public CorpseRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(CorpseEntity entity) {
        return null;
    }

    public void render(CorpseEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLightIn) {
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLightIn);
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-entity.field_70177_z));
        if (((Boolean)Main.SERVER_CONFIG.spawnCorpseOnFace.get()).booleanValue()) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            matrixStack.func_227861_a_(0.0, -1.0, -0.125625);
        } else {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
            matrixStack.func_227861_a_(0.0, -1.0, 0.125625);
        }
        if (entity.isSkeleton()) {
            DummySkeleton skeleton = this.skeletons.get(entity, () -> new DummySkeleton(entity.field_70170_p, entity.getEquipment()));
            this.getRenderer(skeleton).func_225623_a_((Entity)skeleton, entityYaw, 1.0f, matrixStack, buffer, packedLightIn);
        } else {
            RemoteClientPlayerEntity abstractClientPlayerEntity = this.players.get(entity, () -> new DummyPlayer((ClientWorld)entity.field_70170_p, new GameProfile(entity.getCorpseUUID().orElse(new UUID(0L, 0L)), entity.getCorpseName()), entity.getEquipment(), entity.getCorpseModel()));
            this.getRenderer(abstractClientPlayerEntity).func_225623_a_((Entity)abstractClientPlayerEntity, 0.0f, 1.0f, matrixStack, buffer, packedLightIn);
        }
        matrixStack.func_227865_b_();
    }

    private <T extends Entity> EntityRenderer<? super T> getRenderer(T entity) {
        return MC.func_175598_ae().func_78713_a(entity);
    }
}

