/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.controllable.client.ISearchable;
import com.mrcrayfish.controllable.client.util.ScreenUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ListMenuScreen
extends Screen {
    protected final Screen parent;
    protected final int itemHeight;
    protected EntryList list;
    protected List<Item> entries;
    protected List<IReorderingProcessor> activeTooltip;
    protected FocusedTextFieldWidget activeTextField;
    protected FocusedTextFieldWidget searchTextField;
    protected ITextComponent subTitle;
    protected boolean searchBarVisible = true;
    protected int rowWidth = 240;

    protected ListMenuScreen(Screen parent, ITextComponent title, int itemHeight) {
        super(title);
        this.parent = parent;
        this.itemHeight = itemHeight;
    }

    public void setSubTitle(ITextComponent subTitle) {
        this.subTitle = subTitle;
    }

    public void setSearchBarVisible(boolean visible) {
        this.searchBarVisible = visible;
    }

    public void setRowWidth(int rowWidth) {
        this.rowWidth = rowWidth;
    }

    protected void func_231160_c_() {
        ArrayList<Item> entries = new ArrayList<Item>();
        this.constructEntries(entries);
        this.entries = ImmutableList.copyOf(entries);
        this.list = new EntryList(this.entries, this.calculateTop());
        this.list.func_244605_b(!ListMenuScreen.isPlayingGame());
        this.field_230705_e_.add(this.list);
        this.searchTextField = new FocusedTextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 110, this.calculateSearchBarY(), 220, 20, (ITextComponent)new StringTextComponent("Search"));
        this.searchTextField.func_212954_a(s -> {
            ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, s, this.entries);
            this.list.func_230942_a_(s.isEmpty() ? this.entries : (Collection)this.entries.stream().filter(item -> !(item instanceof IIgnoreSearch) && item.getLabel().toLowerCase(Locale.ENGLISH).contains(s.toLowerCase(Locale.ENGLISH))).collect(Collectors.toList()));
            if (!s.isEmpty()) {
                this.list.func_230932_a_(0.0);
            }
        });
        this.field_230705_e_.add(this.searchTextField);
        this.searchTextField.field_230694_p_ = this.searchBarVisible;
        ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, "", this.entries);
    }

    private int calculateTop() {
        int top = 30;
        if (this.searchBarVisible) {
            top += 20;
        }
        if (this.subTitle != null) {
            top += 14;
        }
        return top;
    }

    private int calculateSearchBarY() {
        return this.subTitle != null ? 36 : 22;
    }

    protected abstract void constructEntries(List<Item> var1);

    public void setActiveTooltip(List<IReorderingProcessor> tooltip) {
        this.activeTooltip = tooltip;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        this.func_230446_a_(matrixStack);
        this.list.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.searchTextField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        int titleY = 7 + (!this.searchBarVisible && this.subTitle == null ? 5 : 0);
        ListMenuScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)titleY, (int)0xFFFFFF);
        if (this.subTitle != null) {
            ListMenuScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.subTitle, (int)(this.field_230708_k_ / 2), (int)21, (int)0xFFFFFF);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.activeTooltip != null) {
            this.func_238654_b_(matrixStack, this.activeTooltip, mouseX, mouseY);
        } else {
            for (IGuiEventListener widget : this.func_231039_at__()) {
                if (!(widget instanceof Button) || !((Button)widget).func_230449_g_()) continue;
                ((Button)widget).func_230443_a_(matrixStack, mouseX, mouseY);
                break;
            }
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, (int)mouseX, (int)mouseY)) {
            Style style = Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/configured"));
            this.func_230455_a_(style);
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public static boolean isPlayingGame() {
        return Minecraft.func_71410_x().field_71439_g != null;
    }

    protected static interface IIgnoreSearch {
    }

    @OnlyIn(value=Dist.CLIENT)
    protected class FocusedTextFieldWidget
    extends TextFieldWidget {
        public FocusedTextFieldWidget(FontRenderer fontRenderer, int x, int y, int width, int height, ITextComponent label) {
            super(fontRenderer, x, y, width, height, label);
        }

        public void func_146195_b(boolean focused) {
            super.func_146195_b(focused);
            if (focused) {
                if (ListMenuScreen.this.activeTextField != null && ListMenuScreen.this.activeTextField != this) {
                    ListMenuScreen.this.activeTextField.func_146195_b(false);
                }
                ListMenuScreen.this.activeTextField = this;
            }
        }
    }

    public class TitleItem
    extends Item
    implements IIgnoreSearch {
        public TitleItem(ITextComponent title) {
            super(title);
        }

        public TitleItem(String title) {
            super((ITextComponent)new StringTextComponent(title).func_240699_a_(TextFormatting.BOLD).func_240699_a_(TextFormatting.YELLOW));
        }

        public void func_230432_a_(MatrixStack matrixStack, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            AbstractGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)((ListMenuScreen)ListMenuScreen.this).field_230706_i_.field_71466_p, (ITextComponent)this.label, (int)(left + width / 2), (int)(top + 5), (int)0xFFFFFF);
        }
    }

    protected abstract class Item
    extends AbstractOptionList.Entry<Item>
    implements ISearchable {
        protected final ITextComponent label;
        protected List<IReorderingProcessor> tooltip;

        public Item(ITextComponent label) {
            this.label = label;
        }

        public Item(String label) {
            this.label = new StringTextComponent(label);
        }

        @Override
        public String getLabel() {
            return this.label.func_150261_e();
        }

        public void setTooltip(ITextComponent text, int maxWidth) {
            this.tooltip = ((ListMenuScreen)ListMenuScreen.this).field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)text, maxWidth);
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.emptyList();
        }
    }

    protected class EntryList
    extends AbstractOptionList<Item> {
        public EntryList(List<Item> entries, int top) {
            super(ListMenuScreen.this.field_230706_i_, ListMenuScreen.this.field_230708_k_, ListMenuScreen.this.field_230709_l_, top, ListMenuScreen.this.field_230709_l_ - 44, ListMenuScreen.this.itemHeight);
            entries.forEach(arg_0 -> ((EntryList)this).func_230513_b_(arg_0));
        }

        protected int func_230952_d_() {
            return this.field_230670_d_ / 2 + ListMenuScreen.this.rowWidth / 2 + 10;
        }

        public int func_230949_c_() {
            return ListMenuScreen.this.rowWidth;
        }

        public void func_230942_a_(Collection<Item> entries) {
            super.func_230942_a_(entries);
        }

        public boolean removeEntry(Item item) {
            return super.func_230956_e_((AbstractList.AbstractListEntry)item);
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.renderToolTips(matrixStack, mouseX, mouseY);
        }

        private void renderToolTips(MatrixStack matrixStack, int mouseX, int mouseY) {
            Item item2;
            if (this.func_231047_b_(mouseX, mouseY) && mouseX < ListMenuScreen.this.list.func_230968_n_() + ListMenuScreen.this.list.func_230949_c_() - 67 && (item2 = (Item)this.func_230933_a_(mouseX, mouseY)) != null) {
                ListMenuScreen.this.setActiveTooltip(item2.tooltip);
            }
            this.func_231039_at__().forEach(item -> item.func_231039_at__().forEach(o -> {
                if (o instanceof Button) {
                    ((Button)o).func_230443_a_(matrixStack, mouseX, mouseY);
                }
            }));
        }
    }
}

