/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.controllable.client.BindingRegistry;
import com.mrcrayfish.controllable.client.ISearchable;
import com.mrcrayfish.controllable.client.KeyAdapterBinding;
import com.mrcrayfish.controllable.client.RadialMenuHandler;
import com.mrcrayfish.controllable.client.gui.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.gui.ListMenuScreen;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class KeyBindingListMenuScreen
extends ListMenuScreen {
    private static final List<KeyBinding> DEFAULT_BINDINGS = (List)Util.func_199748_a(() -> {
        GameSettings options = Minecraft.func_71410_x().field_71474_y;
        ArrayList<KeyBinding> bindings = new ArrayList<KeyBinding>();
        bindings.add(options.field_74312_F);
        bindings.add(options.field_74313_G);
        bindings.add(options.field_74351_w);
        bindings.add(options.field_74370_x);
        bindings.add(options.field_74368_y);
        bindings.add(options.field_74366_z);
        bindings.add(options.field_74314_A);
        bindings.add(options.field_228046_af_);
        bindings.add(options.field_151444_V);
        bindings.add(options.field_74316_C);
        bindings.add(options.field_151445_Q);
        bindings.add(options.field_74310_D);
        bindings.add(options.field_74321_H);
        bindings.add(options.field_74322_I);
        bindings.add(options.field_74323_J);
        bindings.add(options.field_151447_Z);
        bindings.add(options.field_151457_aa);
        bindings.add(options.field_151458_ab);
        bindings.add(options.field_152395_am);
        bindings.add(options.field_178883_an);
        bindings.add(options.field_186718_X);
        bindings.add(options.field_193629_ap);
        bindings.add(options.field_193630_aq);
        bindings.add(options.field_194146_ao);
        bindings.addAll(Arrays.asList(options.field_151456_ac));
        return ImmutableList.copyOf(bindings);
    });
    private Map<String, List<KeyBinding>> categories = new LinkedHashMap<String, List<KeyBinding>>();

    protected KeyBindingListMenuScreen(Screen parent, TextComponent title, int itemHeight) {
        super(parent, (ITextComponent)title, itemHeight);
        this.categories.put("key.categories.movement", new ArrayList());
        this.categories.put("key.categories.gameplay", new ArrayList());
        this.categories.put("key.categories.inventory", new ArrayList());
        this.categories.put("key.categories.creative", new ArrayList());
        this.categories.put("key.categories.multiplayer", new ArrayList());
        this.categories.put("key.categories.ui", new ArrayList());
        this.categories.put("key.categories.misc", new ArrayList());
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        this.updateList(entries, false);
    }

    public void updateList(List<ListMenuScreen.Item> entries, boolean showUnbound) {
        this.categories.forEach((category, list) -> list.clear());
        Stream.of(this.field_230706_i_.field_71474_y.field_74324_K).filter(binding -> !DEFAULT_BINDINGS.contains(binding)).forEach(binding -> this.categories.computeIfAbsent(binding.func_151466_e(), category -> new ArrayList()).add(binding));
        this.categories.forEach((category, list) -> {
            if (!list.isEmpty()) {
                Collections.sort(list);
                entries.add(new ListMenuScreen.TitleItem((ListMenuScreen)this, (ITextComponent)new TranslationTextComponent(category).func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.BOLD})));
                list.forEach(binding -> entries.add(new KeyBindingItem((KeyBinding)binding)));
            }
        });
    }

    protected void onChange() {
    }

    public class KeyBindingItem
    extends ListMenuScreen.Item
    implements ISearchable {
        private final KeyBinding mapping;
        private Button addBinding;
        private Button removeBinding;

        protected KeyBindingItem(KeyBinding mapping) {
            super((ListMenuScreen)KeyBindingListMenuScreen.this, (ITextComponent)new TranslationTextComponent(mapping.func_151464_g()));
            this.mapping = mapping;
            Collection<KeyAdapterBinding> bindings = BindingRegistry.getInstance().getKeyAdapters().values();
            this.addBinding = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 88, 25, 10, 10, button -> {
                BindingRegistry.getInstance().addKeyAdapter(new KeyAdapterBinding(-1, this.mapping));
                this.addBinding.field_230693_o_ = false;
                this.removeBinding.field_230693_o_ = true;
                KeyBindingListMenuScreen.this.onChange();
            });
            this.removeBinding = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 98, 15, 10, 10, button -> {
                KeyAdapterBinding keyAdapter = BindingRegistry.getInstance().getKeyAdapterByDescriptionKey(this.mapping.func_151464_g() + ".custom");
                if (keyAdapter != null) {
                    BindingRegistry.getInstance().removeKeyAdapter(keyAdapter);
                    RadialMenuHandler.instance().removeBinding(keyAdapter);
                }
                this.addBinding.field_230693_o_ = true;
                this.removeBinding.field_230693_o_ = false;
                KeyBindingListMenuScreen.this.onChange();
            });
            this.addBinding.field_230693_o_ = bindings.stream().noneMatch(entry -> entry.getKeyBinding() == this.mapping);
            this.removeBinding.field_230693_o_ = bindings.stream().anyMatch(entry -> entry.getKeyBinding() == this.mapping);
        }

        @Override
        public String getLabel() {
            return this.label.func_230531_f_().getString();
        }

        public void updateButtons() {
            Collection<KeyAdapterBinding> bindings = BindingRegistry.getInstance().getKeyAdapters().values();
            this.addBinding.field_230693_o_ = bindings.stream().noneMatch(entry -> entry.getKeyBinding() == this.mapping);
            this.removeBinding.field_230693_o_ = bindings.stream().anyMatch(entry -> entry.getKeyBinding() == this.mapping);
        }

        @Override
        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)this.addBinding, (Object)this.removeBinding);
        }

        public void func_230432_a_(MatrixStack matrixStack, int x, int y, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean selected, float partialTicks) {
            ((KeyBindingListMenuScreen)KeyBindingListMenuScreen.this).field_230706_i_.field_71466_p.func_243246_a(matrixStack, this.label, (float)left, (float)(y + 6), 0xFFFFFF);
            this.addBinding.field_230690_l_ = left + width - 42;
            this.addBinding.field_230691_m_ = y;
            this.addBinding.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.removeBinding.field_230690_l_ = left + width - 20;
            this.removeBinding.field_230691_m_ = y;
            this.removeBinding.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }
}

