/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.BindingRegistry;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.ButtonBindings;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.Thumbstick;
import com.mrcrayfish.controllable.client.gui.ButtonBindingData;
import com.mrcrayfish.controllable.client.gui.RadialMenuConfigureScreen;
import com.mrcrayfish.controllable.event.GatherRadialMenuItemsEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RadialMenuHandler {
    private static final ResourceLocation TEXTURE = new ResourceLocation("controllable", "textures/gui/controller.png");
    private static final int ANIMATE_DURATION = 5;
    private static RadialMenuHandler instance;
    private boolean loaded;
    private boolean visible;
    private int animateTicks;
    private int prevAnimateTicks;
    private Set<ButtonBindingData> bindings = new LinkedHashSet<ButtonBindingData>();
    private AbstractRadialItem settingsItem;
    private AbstractRadialItem closeItem;
    private List<AbstractRadialItem> allItems = new ArrayList<AbstractRadialItem>();
    private List<AbstractRadialItem> leftItems = new ArrayList<AbstractRadialItem>();
    private List<AbstractRadialItem> rightItems = new ArrayList<AbstractRadialItem>();
    private AbstractRadialItem selected;

    public static RadialMenuHandler instance() {
        if (instance == null) {
            instance = new RadialMenuHandler();
        }
        return instance;
    }

    private RadialMenuHandler() {
    }

    private void load() {
        if (this.loaded) {
            return;
        }
        File file = new File(Controllable.getConfigFolder(), "controllable/radial_menu_items.json");
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8));){
                JsonArray bindings = (JsonArray)new Gson().fromJson((Reader)reader, JsonArray.class);
                bindings.forEach(element -> {
                    JsonObject object = element.getAsJsonObject();
                    String key = JSONUtils.func_151200_h((JsonObject)object, (String)"key");
                    String colorName = JSONUtils.func_151200_h((JsonObject)object, (String)"color");
                    ButtonBinding binding = BindingRegistry.getInstance().getBindingByDescriptionKey(key);
                    if (binding != null) {
                        TextFormatting color = TextFormatting.func_96300_b((String)colorName);
                        if (color == null || color.func_211163_e() == null) {
                            color = TextFormatting.YELLOW;
                        }
                        this.bindings.add(new ButtonBindingData(binding, color));
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.bindings.addAll(this.getBindings());
            this.save();
        }
        this.loaded = true;
    }

    private void save() {
        JsonArray array = new JsonArray();
        this.bindings.forEach(data -> {
            JsonObject object = new JsonObject();
            object.addProperty("key", data.getBinding().getDescription());
            object.addProperty("color", data.getColor().name());
            array.add((JsonElement)object);
        });
        String json = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)array);
        File file = new File(Controllable.getConfigFolder(), "controllable/radial_menu_items.json");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));){
            writer.write(json);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<ButtonBindingData> getDefaults() {
        ArrayList<ButtonBindingData> defaults = new ArrayList<ButtonBindingData>();
        defaults.add(new ButtonBindingData(ButtonBindings.ADVANCEMENTS, TextFormatting.YELLOW));
        defaults.add(new ButtonBindingData(ButtonBindings.DEBUG_INFO, TextFormatting.AQUA));
        defaults.add(new ButtonBindingData(ButtonBindings.SCREENSHOT, TextFormatting.GOLD));
        defaults.add(new ButtonBindingData(ButtonBindings.FULLSCREEN, TextFormatting.YELLOW));
        defaults.add(new ButtonBindingData(ButtonBindings.CINEMATIC_CAMERA, TextFormatting.GREEN));
        defaults.add(new ButtonBindingData(ButtonBindings.HIGHLIGHT_PLAYERS, TextFormatting.GREEN));
        return defaults;
    }

    public void interact() {
        if (this.visible) {
            if (this.selected != null) {
                this.selected.onUseItem(this);
            }
        } else {
            this.load();
            this.setVisibility(true);
            this.populateAndConstruct();
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219717_mj, (float)1.5f));
        }
    }

    public AbstractRadialItem getSelected() {
        return this.selected;
    }

    public LinkedHashSet<ButtonBindingData> getBindings() {
        return new LinkedHashSet<ButtonBindingData>(this.bindings);
    }

    public void setBindings(Set<ButtonBindingData> bindings) {
        this.bindings = bindings;
        this.save();
        this.populateAndConstruct();
    }

    public void removeBinding(ButtonBinding binding) {
        if (this.bindings.removeIf(data -> data.getBinding() == binding)) {
            this.save();
            this.populateAndConstruct();
        }
    }

    public void setVisibility(boolean visible) {
        this.visible = visible;
    }

    public void clearAnimation() {
        this.animateTicks = 0;
        this.prevAnimateTicks = 0;
    }

    private void populateAndConstruct() {
        this.rightItems.clear();
        this.leftItems.clear();
        ArrayList<AbstractRadialItem> items = new ArrayList<AbstractRadialItem>();
        this.bindings.forEach(binding -> items.add(new ButtonBindingItem((ButtonBindingData)binding)));
        GatherRadialMenuItemsEvent event = new GatherRadialMenuItemsEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        items.addAll(event.getItems());
        int rightSize = items.size() / 2;
        for (int i = 0; i < rightSize; ++i) {
            float gap = 180.0f / (float)(rightSize + 1);
            AbstractRadialItem item = (AbstractRadialItem)items.get(i);
            item.setAngle(gap * (float)i + gap);
            this.rightItems.add(item);
        }
        int leftSize = items.size() - rightSize;
        for (int i = rightSize; i < items.size(); ++i) {
            float gap = 180.0f / (float)(leftSize + 1);
            AbstractRadialItem item = (AbstractRadialItem)items.get(i);
            item.setAngle(360.0f - gap * (float)(i - rightSize) - gap);
            this.leftItems.add((AbstractRadialItem)items.get(i));
        }
        this.settingsItem = new RadialSettingsItem();
        this.settingsItem.setAngle(0.0f);
        items.add(this.settingsItem);
        this.closeItem = new CloseRadialMenuItem();
        this.closeItem.setAngle(180.0f);
        items.add(this.closeItem);
        this.selected = this.closeItem;
        this.allItems = items;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START || !this.visible || !Controllable.getInput().isControllerInUse()) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onRenderScreen(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74319_N || mc.field_71462_r != null) {
            return;
        }
        if (Controllable.getController() != null && (this.visible || this.animateTicks > 0 || this.prevAnimateTicks > 0)) {
            this.renderRadialMenu(event.renderTickTime);
        }
    }

    @SubscribeEvent
    public void onRenderScreen(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.prevAnimateTicks = this.animateTicks;
        if (this.visible) {
            if (this.animateTicks < 5) {
                ++this.animateTicks;
            }
        } else if (this.animateTicks > 0) {
            --this.animateTicks;
        }
    }

    private void renderRadialMenu(float partialTicks) {
        this.updateSelected();
        MatrixStack matrixStack = new MatrixStack();
        Minecraft mc = Minecraft.func_71410_x();
        matrixStack.func_227861_a_(0.0, -10.0, 0.0);
        matrixStack.func_227861_a_((double)((int)((float)mc.func_228018_at_().func_198107_o() / 2.0f)), (double)((int)((float)mc.func_228018_at_().func_198087_p() / 2.0f)), 0.0);
        float animation = MathHelper.func_219799_g((float)partialTicks, (float)this.prevAnimateTicks, (float)this.animateTicks) / 5.0f;
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        animation = (float)(1.0 + (double)c3 * Math.pow(animation - 1.0f, 3.0) + (double)c1 * Math.pow(animation - 1.0f, 2.0));
        matrixStack.func_227860_a_();
        this.settingsItem.draw(matrixStack, mc, false, this.selected == this.settingsItem, animation);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        this.closeItem.draw(matrixStack, mc, false, this.selected == this.closeItem, animation);
        matrixStack.func_227865_b_();
        this.drawRadialItems(this.rightItems, matrixStack, mc, animation);
        this.drawRadialItems(this.leftItems, matrixStack, mc, animation);
    }

    private void drawRadialItems(List<AbstractRadialItem> items, MatrixStack matrixStack, Minecraft mc, float animation) {
        for (int i = 0; i < items.size(); ++i) {
            AbstractRadialItem item = items.get(i);
            matrixStack.func_227860_a_();
            if (i == 0) {
                matrixStack.func_227861_a_(0.0, -10.0, 0.0);
            }
            if (i == items.size() - 1) {
                matrixStack.func_227861_a_(0.0, 10.0, 0.0);
            }
            boolean left = item.angle >= 180.0f;
            float x = (float)Math.cos(Math.toRadians(item.angle - 90.0f)) * 70.0f;
            float y = (float)Math.sin(Math.toRadians(item.angle - 90.0f)) * 70.0f;
            matrixStack.func_227861_a_((double)((int)x), (double)((int)y), 0.0);
            item.draw(matrixStack, mc, left, this.selected == item, animation);
            matrixStack.func_227865_b_();
        }
    }

    private void updateSelected() {
        float yValue;
        if (!this.visible) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        float xValue = Config.CLIENT.options.radialThumbstick.get() == Thumbstick.RIGHT ? controller.getRThumbStickXValue() : controller.getLThumbStickXValue();
        float f = yValue = Config.CLIENT.options.radialThumbstick.get() == Thumbstick.RIGHT ? controller.getRThumbStickYValue() : controller.getLThumbStickYValue();
        if (Math.abs(xValue) <= 0.5f && Math.abs(yValue) <= 0.5f) {
            return;
        }
        float selectedAngle = (float)(MathHelper.func_76138_g((double)(Math.toDegrees(Math.atan2(yValue, xValue)) - 90.0)) + 180.0);
        Optional closest = this.allItems.stream().min((o1, o2) -> MathHelper.func_203301_d((float)((AbstractRadialItem)o1).angle, (float)selectedAngle) > MathHelper.func_203301_d((float)((AbstractRadialItem)o2).angle, (float)selectedAngle) ? 1 : 0);
        if (!closest.isPresent()) {
            return;
        }
        if (closest.get() == this.selected) {
            return;
        }
        this.selected = (AbstractRadialItem)closest.get();
        Minecraft mc = Minecraft.func_71410_x();
        if (((Boolean)Config.CLIENT.options.uiSounds.get()).booleanValue()) {
            mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187638_cR, (float)1.5f));
        }
    }

    private Optional<AbstractRadialItem> getSelectedItem() {
        return Optional.empty();
    }

    private static class ButtonBindingItem
    extends AbstractRadialItem {
        public ButtonBindingData entry;

        public ButtonBindingItem(ButtonBindingData entry) {
            super((ITextComponent)new TranslationTextComponent(entry.getBinding().getLabelKey()).func_240699_a_(entry.getColor()), (ITextComponent)new TranslationTextComponent(entry.getBinding().getCategory()));
            this.entry = entry;
        }

        @Override
        public void onUseItem(RadialMenuHandler radialMenu) {
            radialMenu.setVisibility(false);
            radialMenu.clearAnimation();
            this.entry.getBinding().setActiveAndPressed();
            Controllable.getInput().handleButtonInput(Controllable.getController(), -1, true, true);
        }

        @Override
        protected void draw(MatrixStack matrixStack, Minecraft mc, boolean left, boolean selected, float animation) {
            int offset;
            matrixStack.func_227860_a_();
            float color = selected ? 1.0f : 0.1f;
            float end = (left ? -150.0f : 150.0f) * animation;
            matrixStack.func_227861_a_((double)((1.0f - animation) * (float)(left ? -20 : 20)), 0.0, 0.0);
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.defaultBlendFunc();
            RenderSystem.shadeModel((int)7425);
            RenderSystem.disableCull();
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), 0.0f, -15.0f, 0.0f).func_227885_a_(color, color, color, 0.6f * animation).func_181675_d();
            buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), 0.0f, 15.0f, 0.0f).func_227885_a_(color, color, color, 0.6f * animation).func_181675_d();
            buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), end, 15.0f, 0.0f).func_227885_a_(color, color, color, 0.0f).func_181675_d();
            buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), end, -15.0f, 0.0f).func_227885_a_(color, color, color, 0.0f).func_181675_d();
            buffer.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)buffer);
            RenderSystem.shadeModel((int)7424);
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableTexture();
            RenderSystem.enableCull();
            if (this.label != null) {
                offset = !left ? 5 : -mc.field_71466_p.func_238414_a_((ITextProperties)this.label) - 5;
                AbstractGui.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (ITextComponent)this.label, (int)offset, (int)-10, (int)0xFFFFFF);
            }
            if (this.description != null) {
                offset = !left ? 5 : -mc.field_71466_p.func_238414_a_((ITextProperties)this.description) - 5;
                AbstractGui.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (ITextComponent)this.description, (int)offset, (int)2, (int)0xFFFFFF);
            }
            matrixStack.func_227865_b_();
        }
    }

    public static final class RadialSettingsItem
    extends AbstractRadialItem {
        private static final ITextComponent LABEL = new TranslationTextComponent("controllable.gui.configure");

        public RadialSettingsItem() {
            super((ITextComponent)new TranslationTextComponent("controllable.gui.radial.settings"));
        }

        @Override
        public void onUseItem(RadialMenuHandler handler) {
            handler.setVisibility(false);
            handler.clearAnimation();
            Minecraft.func_71410_x().func_147108_a((Screen)new RadialMenuConfigureScreen(handler.getBindings()));
        }

        @Override
        protected void draw(MatrixStack matrixStack, Minecraft mc, boolean left, boolean selected, float animation) {
            float color = selected ? 1.0f : 0.1f;
            matrixStack.func_227861_a_(0.0, -90.0, 0.0);
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), -15.0f, -15.0f, 0.0f).func_227885_a_(color, color, color, 0.6f * animation).func_181675_d();
            buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), -15.0f, 15.0f, 0.0f).func_227885_a_(color, color, color, 0.6f * animation).func_181675_d();
            buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), 15.0f, 15.0f, 0.0f).func_227885_a_(color, color, color, 0.6f * animation).func_181675_d();
            buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), 15.0f, -15.0f, 0.0f).func_227885_a_(color, color, color, 0.6f * animation).func_181675_d();
            buffer.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)buffer);
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableTexture();
            RenderSystem.enableCull();
            mc.func_110434_K().func_110577_a(TEXTURE);
            AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)-10, (int)-10, (int)20, (int)20, (float)88.0f, (float)15.0f, (int)10, (int)10, (int)256, (int)256);
            if (selected) {
                AbstractGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (ITextComponent)LABEL, (int)0, (int)21, (int)0xFFFFFF);
            }
        }
    }

    public static final class CloseRadialMenuItem
    extends AbstractRadialItem {
        private static final ITextComponent LABEL = new TranslationTextComponent("controllable.gui.close");

        public CloseRadialMenuItem() {
            super((ITextComponent)new TranslationTextComponent("controllable.gui.radial.close"));
        }

        @Override
        public void onUseItem(RadialMenuHandler handler) {
            handler.setVisibility(false);
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219717_mj, (float)1.3f));
        }

        @Override
        protected void draw(MatrixStack matrixStack, Minecraft mc, boolean left, boolean selected, float animation) {
            float color = selected ? 1.0f : 0.1f;
            matrixStack.func_227861_a_(0.0, 90.0, 0.0);
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), -15.0f, -15.0f, 0.0f).func_227885_a_(color, color, color, 0.6f * animation).func_181675_d();
            buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), -15.0f, 15.0f, 0.0f).func_227885_a_(color, color, color, 0.6f * animation).func_181675_d();
            buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), 15.0f, 15.0f, 0.0f).func_227885_a_(color, color, color, 0.6f * animation).func_181675_d();
            buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), 15.0f, -15.0f, 0.0f).func_227885_a_(color, color, color, 0.6f * animation).func_181675_d();
            buffer.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)buffer);
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableTexture();
            RenderSystem.enableCull();
            mc.func_110434_K().func_110577_a(TEXTURE);
            AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)-10, (int)-10, (int)20, (int)20, (float)98.0f, (float)15.0f, (int)10, (int)10, (int)256, (int)256);
            if (selected) {
                AbstractGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (ITextComponent)LABEL, (int)0, (int)-30, (int)0xFFFFFF);
            }
        }
    }

    public static abstract class AbstractRadialItem {
        protected ITextComponent label;
        protected ITextComponent description;
        private float angle;

        protected AbstractRadialItem(ITextComponent label) {
            this(label, null);
        }

        protected AbstractRadialItem(ITextComponent label, ITextComponent description) {
            this.label = label;
            this.description = description;
        }

        public ITextComponent getLabel() {
            return this.label;
        }

        @Nullable
        public ITextComponent getDescription() {
            return this.description;
        }

        public boolean isEmpty() {
            return false;
        }

        public abstract void onUseItem(RadialMenuHandler var1);

        protected abstract void draw(MatrixStack var1, Minecraft var2, boolean var3, boolean var4, float var5);

        protected void playSound(SoundEvent event, float pitch) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)event, (float)pitch));
        }

        void setAngle(float angle) {
            this.angle = angle;
        }
    }
}

