/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable;

import com.google.common.io.ByteStreams;
import com.mrcrayfish.controllable.ButtonStates;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.Buttons;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.ControllerEvents;
import com.mrcrayfish.controllable.client.ControllerInput;
import com.mrcrayfish.controllable.client.ControllerManager;
import com.mrcrayfish.controllable.client.ControllerProperties;
import com.mrcrayfish.controllable.client.ControllerToast;
import com.mrcrayfish.controllable.client.GuiEvents;
import com.mrcrayfish.controllable.client.IControllerListener;
import com.mrcrayfish.controllable.client.Mappings;
import com.mrcrayfish.controllable.client.RadialMenuHandler;
import com.mrcrayfish.controllable.client.RenderEvents;
import com.mrcrayfish.controllable.client.gui.ButtonBindingScreen;
import com.mrcrayfish.controllable.client.gui.ControllerLayoutScreen;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryUtil;

@Mod(value="controllable")
public class Controllable
implements IControllerListener {
    public static final Logger LOGGER = LogManager.getLogger((String)"Controllable");
    private static ControllerManager manager;
    private static Controller controller;
    private static ControllerInput input;
    private static File configFolder;
    private static boolean jeiLoaded;

    public Controllable() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.serverSpec);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    @Nullable
    public static Controller getController() {
        return controller;
    }

    public static ControllerInput getInput() {
        return input;
    }

    public static File getConfigFolder() {
        return configFolder;
    }

    public static boolean isJeiLoaded() {
        return jeiLoaded;
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            Minecraft mc = (Minecraft)event.getMinecraftSupplier().get();
            configFolder = new File(mc.field_71412_D, "config");
            jeiLoaded = ModList.get().isLoaded("jei");
            ControllerProperties.load(configFolder);
            try (InputStream is = Mappings.class.getResourceAsStream("/gamecontrollerdb.txt");){
                byte[] bytes;
                ByteBuffer buffer;
                if (is != null && (buffer = MemoryUtil.memASCIISafe((CharSequence)new String(bytes = ByteStreams.toByteArray((InputStream)is)))) != null && GLFW.glfwUpdateGamepadMappings((ByteBuffer)buffer)) {
                    LOGGER.info("Successfully updated gamepad mappings");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            manager = new ControllerManager();
            manager.addControllerListener(this);
            if (((Boolean)Config.CLIENT.options.autoSelect.get()).booleanValue() && GLFW.glfwJoystickPresent((int)0) && GLFW.glfwJoystickIsGamepad((int)0)) {
                Controllable.setController(new Controller(0));
            }
            Mappings.load(configFolder);
            MinecraftForge.EVENT_BUS.register((Object)this);
            input = new ControllerInput();
            MinecraftForge.EVENT_BUS.register((Object)input);
            MinecraftForge.EVENT_BUS.register((Object)new RenderEvents());
            MinecraftForge.EVENT_BUS.register((Object)new GuiEvents(manager));
            MinecraftForge.EVENT_BUS.register((Object)new ControllerEvents());
            MinecraftForge.EVENT_BUS.register((Object)RadialMenuHandler.instance());
            MinecraftForge.EVENT_BUS.addListener(this::controllerTick);
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void connected(int jid) {
        Minecraft.func_71410_x().func_212871_a_(() -> {
            if (controller == null) {
                if (((Boolean)Config.CLIENT.options.autoSelect.get()).booleanValue()) {
                    Controllable.setController(new Controller(jid));
                }
                Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_71439_g != null && controller != null) {
                    Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new ControllerToast(true, controller.getName()));
                }
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void disconnected(int jid) {
        Minecraft.func_71410_x().func_212871_a_(() -> {
            if (controller != null && controller.getJid() == jid) {
                Controller oldController = controller;
                Controllable.setController(null);
                if (((Boolean)Config.CLIENT.options.autoSelect.get()).booleanValue() && manager.getControllerCount() > 0) {
                    Optional<Integer> optional = manager.getControllers().keySet().stream().min(Comparator.comparing(i -> i));
                    optional.ifPresent(minJid -> Controllable.setController(new Controller((int)minJid)));
                }
                Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_71439_g != null) {
                    Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new ControllerToast(false, oldController.getName()));
                }
            }
        });
    }

    public static void setController(@Nullable Controller controller) {
        if (controller != null) {
            Controllable.controller = controller;
            Mappings.updateControllerMappings(controller);
        } else {
            Controllable.controller = null;
        }
    }

    private void controllerTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (manager != null) {
            manager.update();
        }
        if (controller != null) {
            controller.updateGamepadState();
            Controllable.gatherAndQueueControllerInput();
        }
    }

    private static void gatherAndQueueControllerInput() {
        Controller currentController = controller;
        if (currentController == null) {
            return;
        }
        ButtonStates states = new ButtonStates();
        states.setState(0, Controllable.getButtonState(0));
        states.setState(1, Controllable.getButtonState(1));
        states.setState(2, Controllable.getButtonState(2));
        states.setState(3, Controllable.getButtonState(3));
        states.setState(4, Controllable.getButtonState(6));
        states.setState(5, Controllable.getButtonState(8));
        states.setState(6, Controllable.getButtonState(7));
        states.setState(7, Controllable.getButtonState(9));
        states.setState(8, Controllable.getButtonState(10));
        states.setState(9, Controllable.getButtonState(4));
        states.setState(10, Controllable.getButtonState(5));
        states.setState(11, currentController.getLTriggerValue() >= 0.5f);
        states.setState(12, currentController.getRTriggerValue() >= 0.5f);
        states.setState(13, Controllable.getButtonState(11));
        states.setState(14, Controllable.getButtonState(13));
        states.setState(15, Controllable.getButtonState(14));
        states.setState(16, Controllable.getButtonState(12));
        Controllable.processButtonStates(states);
    }

    private static void processButtonStates(ButtonStates states) {
        ButtonBinding.tick();
        for (int i = 0; i < Buttons.BUTTONS.length; ++i) {
            Controllable.processButton(Buttons.BUTTONS[i], states);
        }
    }

    private static void processButton(int index, ButtonStates newStates) {
        boolean state = newStates.getState(index);
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof ControllerLayoutScreen) {
            ((ControllerLayoutScreen)screen).processButton(index, newStates);
            return;
        }
        if (controller == null) {
            return;
        }
        if (controller.getMapping() != null) {
            index = controller.getMapping().remap(index);
        }
        if (index == -1) {
            return;
        }
        ButtonStates states = controller.getButtonsStates();
        if (state) {
            if (!states.getState(index)) {
                states.setState(index, true);
                if (screen instanceof ButtonBindingScreen && ((ButtonBindingScreen)screen).processButton(index)) {
                    return;
                }
                input.handleButtonInput(controller, index, true, false);
            }
        } else if (states.getState(index)) {
            states.setState(index, false);
            input.handleButtonInput(controller, index, false, false);
        }
    }

    public static boolean isButtonPressed(int button) {
        return controller != null && controller.getButtonsStates().getState(button);
    }

    private static boolean getButtonState(int buttonCode) {
        return controller != null && controller.getGamepadState().buttons(buttonCode) == 1;
    }
}

