/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib;

import com.google.common.primitives.Ints;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum MoonPhase {
    FULL(0, "full"),
    WAXING_GIBBOUS(1, "waxing.gibbous"),
    FIRST_QUARTER(2, "first.quarter"),
    WAXING_CRESCENT(3, "waxing.crescent"),
    NEW_MOON(4, "new"),
    WANING_CRESCENT(5, "waning.crescent"),
    LAST_QUARTER(6, "last.quarter"),
    WANING_GIBBOUS(7, "waning.gibbous");

    private final int phase;
    private final String key;

    private MoonPhase(int phase, String key) {
        this.phase = phase;
        this.key = key;
    }

    public int getPhase() {
        return this.phase;
    }

    public String getKey() {
        return this.key;
    }

    public static MoonPhase getPhase(int phase) {
        return MoonPhase.values()[Ints.constrainToRange((int)phase, (int)0, (int)7)];
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getPhaseName() {
        return I18n.func_135052_a((String)("moon.phase." + this.key + ".name"), (Object[])new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static MoonPhase getCurrentPhase() {
        return MoonPhase.getPhase(Minecraft.func_71410_x().field_71441_e.func_242414_af());
    }
}

