/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.implementations.items.IAEWrench;
import appeng.util.LookDirection;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;

public final class InteractionUtil {
    private InteractionUtil() {
    }

    public static boolean isWrench(PlayerEntity player, ItemStack eq, BlockPos pos) {
        if (!eq.func_190926_b() && eq.func_77973_b() instanceof IAEWrench) {
            IAEWrench wrench = (IAEWrench)eq.func_77973_b();
            return wrench.canWrench(eq, player, pos);
        }
        return false;
    }

    public static boolean isInAlternateUseMode(PlayerEntity player) {
        return player.func_225608_bj_();
    }

    public static float getEyeOffset(PlayerEntity player) {
        assert (player.field_70170_p.field_72995_K) : "Valid only on client";
        return (float)(player.func_226278_cu_() + (double)player.func_70047_e() - (double)1.62f);
    }

    public static LookDirection getPlayerRay(PlayerEntity playerIn) {
        double reachDistance = playerIn.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        return InteractionUtil.getPlayerRay(playerIn, reachDistance);
    }

    public static LookDirection getPlayerRay(PlayerEntity playerIn, double reachDistance) {
        double x = playerIn.field_70169_q + (playerIn.func_226277_ct_() - playerIn.field_70169_q);
        double y = playerIn.field_70167_r + (playerIn.func_226278_cu_() - playerIn.field_70167_r) + (double)playerIn.func_70047_e();
        double z = playerIn.field_70166_s + (playerIn.func_226281_cx_() - playerIn.field_70166_s);
        float playerPitch = playerIn.field_70127_C + (playerIn.field_70125_A - playerIn.field_70127_C);
        float playerYaw = playerIn.field_70126_B + (playerIn.field_70177_z - playerIn.field_70126_B);
        float yawRayX = MathHelper.func_76126_a((float)(-playerYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float yawRayZ = MathHelper.func_76134_b((float)(-playerYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float pitchMultiplier = -MathHelper.func_76134_b((float)(-playerPitch * ((float)Math.PI / 180)));
        float eyeRayY = MathHelper.func_76126_a((float)(-playerPitch * ((float)Math.PI / 180)));
        float eyeRayX = yawRayX * pitchMultiplier;
        float eyeRayZ = yawRayZ * pitchMultiplier;
        Vector3d from = new Vector3d(x, y, z);
        Vector3d to = from.func_72441_c((double)eyeRayX * reachDistance, (double)eyeRayY * reachDistance, (double)eyeRayZ * reachDistance);
        return new LookDirection(from, to);
    }

    public static RayTraceResult rayTrace(PlayerEntity p, boolean hitBlocks, boolean hitEntities) {
        World w = p.func_130014_f_();
        float f = 1.0f;
        float f1 = p.field_70127_C + (p.field_70125_A - p.field_70127_C) * 1.0f;
        float f2 = p.field_70126_B + (p.field_70177_z - p.field_70126_B) * 1.0f;
        double d0 = p.field_70169_q + (p.func_226277_ct_() - p.field_70169_q) * 1.0;
        double d1 = p.field_70167_r + (p.func_226278_cu_() - p.field_70167_r) * 1.0 + 1.62 - p.func_70033_W();
        double d2 = p.field_70166_s + (p.func_226281_cx_() - p.field_70166_s) * 1.0;
        Vector3d vec3 = new Vector3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 32.0;
        Vector3d vec31 = vec3.func_72441_c((double)f7 * 32.0, (double)f6 * 32.0, (double)f8 * 32.0);
        AxisAlignedBB bb = new AxisAlignedBB(Math.min(vec3.field_72450_a, vec31.field_72450_a), Math.min(vec3.field_72448_b, vec31.field_72448_b), Math.min(vec3.field_72449_c, vec31.field_72449_c), Math.max(vec3.field_72450_a, vec31.field_72450_a), Math.max(vec3.field_72448_b, vec31.field_72448_b), Math.max(vec3.field_72449_c, vec31.field_72449_c)).func_72314_b(16.0, 16.0, 16.0);
        Entity entity = null;
        double closest = 9999999.0;
        if (hitEntities) {
            List list = w.func_72839_b((Entity)p, bb);
            for (Entity entity1 : list) {
                double nd;
                if (!entity1.func_70089_S() || entity1 == p || entity1 instanceof ItemEntity || entity1.func_184215_y((Entity)p)) continue;
                f1 = 0.3f;
                AxisAlignedBB boundingBox = entity1.func_174813_aQ().func_72314_b((double)f1, (double)f1, (double)f1);
                Vector3d rtResult = boundingBox.func_216365_b(vec3, vec31).orElse(null);
                if (rtResult == null || !((nd = vec3.func_72436_e(rtResult)) < closest)) continue;
                entity = entity1;
                closest = nd;
            }
        }
        EntityRayTraceResult pos = null;
        Vector3d vec = null;
        if (hitBlocks) {
            vec = new Vector3d(d0, d1, d2);
            pos = w.func_217299_a(new RayTraceContext(vec3, vec31, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)p));
        }
        if (entity != null && pos != null && pos.func_216347_e().func_72436_e(vec) > closest) {
            pos = new EntityRayTraceResult(entity);
        } else if (entity != null && pos == null) {
            pos = new EntityRayTraceResult(entity);
        }
        return pos;
    }
}

