/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered.powersink;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.items.tools.powered.powersink.PoweredItemCapabilities;
import java.text.MessageFormat;
import java.util.List;
import java.util.function.DoubleSupplier;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class AEBasePoweredItem
extends AEBaseItem
implements IAEItemPowerStorage {
    private static final String CURRENT_POWER_NBT_KEY = "internalCurrentPower";
    private final DoubleSupplier powerCapacity;

    public AEBasePoweredItem(DoubleSupplier powerCapacity, Item.Properties props) {
        super(props);
        this.powerCapacity = powerCapacity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag advancedTooltips) {
        CompoundNBT tag = stack.func_77978_p();
        double internalCurrentPower = 0.0;
        double internalMaxPower = this.getAEMaxPower(stack);
        if (tag != null) {
            internalCurrentPower = tag.func_74769_h(CURRENT_POWER_NBT_KEY);
        }
        double percent = internalCurrentPower / internalMaxPower;
        lines.add((ITextComponent)GuiText.StoredEnergy.text().func_230532_e_().func_240702_b_(':' + MessageFormat.format(" {0,number,#} ", internalCurrentPower)).func_230529_a_(PowerUnits.AE.textComponent()).func_240702_b_(" - " + MessageFormat.format(" {0,number,#.##%} ", percent)));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        super.func_150895_a(group, items);
        if (this.func_194125_a(group)) {
            ItemStack charged = new ItemStack((IItemProvider)this, 1);
            this.injectAEPower(charged, this.getAEMaxPower(charged), Actionable.MODULATE);
            items.add((Object)charged);
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack is) {
        return 1.0 - this.getAECurrentPower(is) / this.getAEMaxPower(is);
    }

    @Override
    public double injectAEPower(ItemStack is, double amount, Actionable mode) {
        double maxStorage = this.getAEMaxPower(is);
        double currentStorage = this.getAECurrentPower(is);
        double required = maxStorage - currentStorage;
        double overflow = amount - required;
        if (mode == Actionable.MODULATE) {
            CompoundNBT data = is.func_196082_o();
            double toAdd = Math.min(amount, required);
            data.func_74780_a(CURRENT_POWER_NBT_KEY, currentStorage + toAdd);
        }
        return Math.max(0.0, overflow);
    }

    @Override
    public double extractAEPower(ItemStack is, double amount, Actionable mode) {
        double currentStorage = this.getAECurrentPower(is);
        double fulfillable = Math.min(amount, currentStorage);
        if (mode == Actionable.MODULATE) {
            CompoundNBT data = is.func_196082_o();
            data.func_74780_a(CURRENT_POWER_NBT_KEY, currentStorage - fulfillable);
        }
        return fulfillable;
    }

    @Override
    public double getAEMaxPower(ItemStack is) {
        return this.powerCapacity.getAsDouble();
    }

    @Override
    public double getAECurrentPower(ItemStack is) {
        CompoundNBT data = is.func_196082_o();
        return data.func_74769_h(CURRENT_POWER_NBT_KEY);
    }

    @Override
    public AccessRestriction getPowerFlow(ItemStack is) {
        return AccessRestriction.WRITE;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new PoweredItemCapabilities(stack, this);
    }
}

