/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.CopyMode;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.container.SlotSemantic;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.container.implementations.UpgradeableContainer;
import appeng.container.slot.FakeTypeOnlySlot;
import appeng.container.slot.OptionalRestrictedInputSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.core.Api;
import appeng.tile.misc.CellWorkbenchTileEntity;
import appeng.util.EnumCycler;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.WrapperSupplierItemHandler;
import appeng.util.iterators.NullIterator;
import java.util.Iterator;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class CellWorkbenchContainer
extends UpgradeableContainer {
    public static final ContainerType<CellWorkbenchContainer> TYPE = ContainerTypeBuilder.create(CellWorkbenchContainer::new, CellWorkbenchTileEntity.class).build("cellworkbench");
    private final CellWorkbenchTileEntity workBench;
    @GuiSync(value=2)
    public CopyMode copyMode = CopyMode.CLEAR_ON_REMOVE;
    private ItemStack prevStack = ItemStack.field_190927_a;
    private int lastUpgrades = 0;

    public CellWorkbenchContainer(int id, PlayerInventory ip, CellWorkbenchTileEntity te) {
        super(TYPE, id, ip, te);
        this.workBench = te;
    }

    public void setFuzzy(FuzzyMode valueOf) {
        ICellWorkbenchItem cwi = this.workBench.getCell();
        if (cwi != null) {
            cwi.setFuzzyMode(this.getWorkbenchItem(), valueOf);
        }
    }

    public void nextWorkBenchCopyMode() {
        this.workBench.getConfigManager().putSetting(Settings.COPY_MODE, EnumCycler.next(this.getWorkBenchCopyMode()));
    }

    private CopyMode getWorkBenchCopyMode() {
        return (CopyMode)this.workBench.getConfigManager().getSetting(Settings.COPY_MODE);
    }

    @Override
    protected void setupConfig() {
        int i;
        IItemHandler cell = this.getUpgradeable().getInventoryByName("cell");
        this.addSlot(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.WORKBENCH_CELL, cell, 0), SlotSemantic.STORAGE_CELL);
        IItemHandler inv = this.getUpgradeable().getInventoryByName("config");
        WrapperSupplierItemHandler upgradeInventory = new WrapperSupplierItemHandler(this::getCellUpgradeInventory);
        for (i = 0; i < 63; ++i) {
            this.addSlot(new FakeTypeOnlySlot(inv, i), SlotSemantic.CONFIG);
        }
        for (i = 0; i < 24; ++i) {
            OptionalRestrictedInputSlot slot = new OptionalRestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, (IItemHandler)upgradeInventory, this, i, i, this.getPlayerInventory());
            this.addSlot(slot, SlotSemantic.UPGRADE);
        }
    }

    @Override
    public int availableUpgrades() {
        ItemStack is = this.getWorkbenchItem();
        if (this.prevStack != is) {
            this.prevStack = is;
            this.lastUpgrades = this.getCellUpgradeInventory().getSlots();
        }
        return this.lastUpgrades;
    }

    public ItemStack getWorkbenchItem() {
        return this.workBench.getInventoryByName("cell").getStackInSlot(0);
    }

    @Override
    public void func_75142_b() {
        ItemStack is = this.getWorkbenchItem();
        if (this.isServer()) {
            for (IContainerListener listener : this.field_75149_d) {
                if (this.prevStack == is) continue;
                for (Slot s : this.field_75151_b) {
                    if (!(s instanceof OptionalRestrictedInputSlot)) continue;
                    OptionalRestrictedInputSlot sri = (OptionalRestrictedInputSlot)s;
                    listener.func_71111_a((Container)this, sri.field_75222_d, sri.func_75211_c());
                }
                if (!(listener instanceof ServerPlayerEntity)) continue;
                ((ServerPlayerEntity)listener).field_71137_h = false;
            }
            this.setCopyMode(this.getWorkBenchCopyMode());
            this.setFuzzyMode(this.getWorkBenchFuzzyMode());
        }
        this.prevStack = is;
        this.standardDetectAndSendChanges();
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        return idx < this.availableUpgrades();
    }

    public IItemHandler getCellUpgradeInventory() {
        IItemHandler upgradeInventory = this.workBench.getCellUpgradeInventory();
        return upgradeInventory == null ? EmptyHandler.INSTANCE : upgradeInventory;
    }

    @Override
    public void onServerDataSync() {
        super.onServerDataSync();
        this.workBench.getConfigManager().putSetting(Settings.COPY_MODE, this.getCopyMode());
    }

    public void clear() {
        ItemHandlerUtil.clear(this.getUpgradeable().getInventoryByName("config"));
        this.func_75142_b();
    }

    private FuzzyMode getWorkBenchFuzzyMode() {
        ICellWorkbenchItem cwi = this.workBench.getCell();
        if (cwi != null) {
            return cwi.getFuzzyMode(this.getWorkbenchItem());
        }
        return FuzzyMode.IGNORE_ALL;
    }

    public void partition() {
        IItemHandler inv = this.getUpgradeable().getInventoryByName("config");
        ItemStack is = this.getWorkbenchItem();
        IItemStorageChannel channel = is.func_77973_b() instanceof IStorageCell ? ((IStorageCell)is.func_77973_b()).getChannel() : Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
        Iterator<IAEStack<IAEItemStack>> i = this.iterateCellItems(is, channel);
        for (int x = 0; x < inv.getSlots(); ++x) {
            if (i.hasNext()) {
                ItemStack g = i.next().asItemStackRepresentation();
                ItemHandlerUtil.setStackInSlot(inv, x, g);
                continue;
            }
            ItemHandlerUtil.setStackInSlot(inv, x, ItemStack.field_190927_a);
        }
        this.func_75142_b();
    }

    private <T extends IAEStack<T>> Iterator<? extends IAEStack<T>> iterateCellItems(ItemStack is, IStorageChannel<T> channel) {
        ICellInventoryHandler<T> cellInv = Api.instance().registries().cell().getCellInventory(is, null, channel);
        if (cellInv != null) {
            IItemList<T> list = cellInv.getAvailableItems(channel.createList());
            return list.iterator();
        }
        return new NullIterator();
    }

    public CopyMode getCopyMode() {
        return this.copyMode;
    }

    private void setCopyMode(CopyMode copyMode) {
        this.copyMode = copyMode;
    }
}

