/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.guisync;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Objects;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;

public abstract class SynchronizedField<T> {
    private final Object source;
    protected final MethodHandle getter;
    protected final MethodHandle setter;
    protected T clientVersion = null;

    private SynchronizedField(Object source, Field field) {
        this.source = source;
        field.setAccessible(true);
        try {
            this.getter = MethodHandles.publicLookup().unreflectGetter(field);
            this.setter = MethodHandles.publicLookup().unreflectSetter(field);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to get accessor for field " + field + ". Did you forget to make it public?");
        }
    }

    private T getCurrentValue() {
        try {
            return (T)this.getter.invoke(this.source);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public boolean hasChanges() {
        return !Objects.equals(this.getCurrentValue(), this.clientVersion);
    }

    public final void write(PacketBuffer data) {
        T currentValue = this.getCurrentValue();
        this.clientVersion = currentValue;
        this.writeValue(data, currentValue);
    }

    public final void read(PacketBuffer data) {
        T value = this.readValue(data);
        try {
            this.setter.invoke(this.source, value);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    protected abstract void writeValue(PacketBuffer var1, T var2);

    protected abstract T readValue(PacketBuffer var1);

    public static SynchronizedField<?> create(Object source, Field field) {
        Class<ITextComponent> fieldType = field.getType();
        if (fieldType.isAssignableFrom(ITextComponent.class)) {
            return new TextComponentField(source, field);
        }
        if (fieldType == String.class) {
            return new StringField(source, field);
        }
        if (fieldType == Integer.TYPE || fieldType == Integer.class) {
            return new IntegerField(source, field);
        }
        if (fieldType == Long.TYPE || fieldType == Long.class) {
            return new LongField(source, field);
        }
        if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
            return new BooleanField(source, field);
        }
        if (fieldType.isEnum()) {
            return SynchronizedField.createEnumField(source, field, fieldType.asSubclass(Enum.class));
        }
        throw new IllegalArgumentException("Cannot synchronize field " + field);
    }

    private static <T extends Enum<T>> EnumField<T> createEnumField(Object source, Field field, Class<T> fieldType) {
        return new EnumField(source, field, (Enum[])fieldType.getEnumConstants());
    }

    private static class TextComponentField
    extends SynchronizedField<ITextComponent> {
        private TextComponentField(Object source, Field field) {
            super(source, field);
        }

        @Override
        protected void writeValue(PacketBuffer data, ITextComponent value) {
            if (value == null) {
                data.writeBoolean(false);
            } else {
                data.writeBoolean(true);
                data.func_179256_a(value);
            }
        }

        @Override
        protected ITextComponent readValue(PacketBuffer data) {
            if (data.readBoolean()) {
                return data.func_179258_d();
            }
            return null;
        }
    }

    private static class EnumField<T extends Enum<T>>
    extends SynchronizedField<T> {
        private final T[] values;

        private EnumField(Object source, Field field, T[] values) {
            super(source, field);
            this.values = values;
        }

        @Override
        protected void writeValue(PacketBuffer data, T value) {
            data.func_150787_b(((Enum)value).ordinal());
        }

        @Override
        protected T readValue(PacketBuffer data) {
            int ordinal = data.func_150792_a();
            return this.values[ordinal];
        }
    }

    private static class BooleanField
    extends SynchronizedField<Boolean> {
        private BooleanField(Object source, Field field) {
            super(source, field);
        }

        @Override
        protected void writeValue(PacketBuffer data, Boolean value) {
            data.writeBoolean(value.booleanValue());
        }

        @Override
        protected Boolean readValue(PacketBuffer data) {
            return data.readBoolean();
        }
    }

    private static class LongField
    extends SynchronizedField<Long> {
        private LongField(Object source, Field field) {
            super(source, field);
        }

        @Override
        protected void writeValue(PacketBuffer data, Long value) {
            data.writeLong(value.longValue());
        }

        @Override
        protected Long readValue(PacketBuffer data) {
            return data.readLong();
        }
    }

    private static class IntegerField
    extends SynchronizedField<Integer> {
        private IntegerField(Object source, Field field) {
            super(source, field);
        }

        @Override
        protected void writeValue(PacketBuffer data, Integer value) {
            data.writeInt(value.intValue());
        }

        @Override
        protected Integer readValue(PacketBuffer data) {
            return data.readInt();
        }
    }

    private static class StringField
    extends SynchronizedField<String> {
        private StringField(Object source, Field field) {
            super(source, field);
        }

        @Override
        protected void writeValue(PacketBuffer data, String value) {
            data.func_180714_a(value);
        }

        @Override
        protected String readValue(PacketBuffer data) {
            return data.func_218666_n();
        }
    }
}

