/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.items;

import appeng.api.config.ActionItems;
import appeng.client.gui.me.items.ItemTerminalScreen;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.TabButton;
import appeng.container.SlotSemantic;
import appeng.container.me.items.PatternTermContainer;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;

public class PatternTermScreen
extends ItemTerminalScreen<PatternTermContainer> {
    private static final String MODES_TEXTURE = "guis/pattern_modes.png";
    private static final Blitter CRAFTING_MODE_BG = Blitter.texture("guis/pattern_modes.png").src(0, 0, 126, 68);
    private static final Blitter PROCESSING_MODE_BG = Blitter.texture("guis/pattern_modes.png").src(0, 70, 126, 68);
    private static final String SUBSTITUTION_DISABLE = "0";
    private static final String SUBSTITUTION_ENABLE = "1";
    private static final String CRAFTMODE_CRAFTING = "1";
    private static final String CRAFTMODE_PROCESSING = "0";
    private final TabButton tabCraftButton;
    private final TabButton tabProcessButton;
    private final ActionButton substitutionsEnabledBtn;
    private final ActionButton substitutionsDisabledBtn;

    public PatternTermScreen(PatternTermContainer container, PlayerInventory playerInventory, ITextComponent title, ScreenStyle style) {
        super(container, playerInventory, title, style);
        this.tabCraftButton = new TabButton(new ItemStack((IItemProvider)Blocks.field_150462_ai), GuiText.CraftingPattern.text(), this.field_230707_j_, btn -> this.toggleCraftMode("0"));
        this.widgets.add("craftingPatternMode", (Widget)this.tabCraftButton);
        this.tabProcessButton = new TabButton(new ItemStack((IItemProvider)Blocks.field_150460_al), GuiText.ProcessingPattern.text(), this.field_230707_j_, btn -> this.toggleCraftMode("1"));
        this.widgets.add("processingPatternMode", (Widget)this.tabProcessButton);
        this.substitutionsEnabledBtn = new ActionButton(ActionItems.ENABLE_SUBSTITUTION, act -> this.toggleSubstitutions("0"));
        this.substitutionsEnabledBtn.setHalfSize(true);
        this.widgets.add("substitutionsEnabled", (Widget)this.substitutionsEnabledBtn);
        this.substitutionsDisabledBtn = new ActionButton(ActionItems.DISABLE_SUBSTITUTION, act -> this.toggleSubstitutions("1"));
        this.substitutionsDisabledBtn.setHalfSize(true);
        this.widgets.add("substitutionsDisabled", (Widget)this.substitutionsDisabledBtn);
        ActionButton clearBtn = new ActionButton(ActionItems.CLOSE, act -> this.clear());
        clearBtn.setHalfSize(true);
        this.widgets.add("clearPattern", (Widget)clearBtn);
        ActionButton encodeBtn = new ActionButton(ActionItems.ENCODE, act -> this.encode());
        this.widgets.add("encodePattern", (Widget)encodeBtn);
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        if (((PatternTermContainer)this.field_147002_h).isCraftingMode()) {
            this.tabCraftButton.field_230694_p_ = true;
            this.tabProcessButton.field_230694_p_ = false;
            if (((PatternTermContainer)this.field_147002_h).substitute) {
                this.substitutionsEnabledBtn.field_230694_p_ = true;
                this.substitutionsDisabledBtn.field_230694_p_ = false;
            } else {
                this.substitutionsEnabledBtn.field_230694_p_ = false;
                this.substitutionsDisabledBtn.field_230694_p_ = true;
            }
        } else {
            this.tabCraftButton.field_230694_p_ = false;
            this.tabProcessButton.field_230694_p_ = true;
            this.substitutionsEnabledBtn.field_230694_p_ = false;
            this.substitutionsDisabledBtn.field_230694_p_ = false;
        }
        this.setSlotsHidden(SlotSemantic.CRAFTING_RESULT, !((PatternTermContainer)this.field_147002_h).isCraftingMode());
        this.setSlotsHidden(SlotSemantic.PROCESSING_RESULT, ((PatternTermContainer)this.field_147002_h).isCraftingMode());
    }

    private void toggleCraftMode(String mode) {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("PatternTerminal.CraftMode", mode));
    }

    private void toggleSubstitutions(String mode) {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("PatternTerminal.Substitute", mode));
    }

    private void encode() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("PatternTerminal.Encode", "1"));
    }

    private void clear() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("PatternTerminal.Clear", "1"));
    }

    @Override
    public void drawBG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(matrixStack, offsetX, offsetY, mouseX, mouseY, partialTicks);
        Blitter modeBg = ((PatternTermContainer)this.field_147002_h).isCraftingMode() ? CRAFTING_MODE_BG : PROCESSING_MODE_BG;
        modeBg.dest(this.field_147003_i + 9, this.field_147009_r + this.field_147000_g - 164).blit(matrixStack, this.func_230927_p_());
    }
}

