/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.message;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xaero.map.message.WorldMapMessage;
import xaero.map.message.client.ClientMessageConsumer;
import xaero.map.message.server.ServerMessageConsumer;

public class PacketConsumerForge<T extends WorldMapMessage<T>>
implements BiConsumer<T, Supplier<NetworkEvent.Context>> {
    private final ServerMessageConsumer<T> serverHandler;
    private final ClientMessageConsumer<T> clientHandler;

    public PacketConsumerForge(ServerMessageConsumer<T> serverHandler, ClientMessageConsumer<T> clientHandler) {
        this.serverHandler = serverHandler;
        this.clientHandler = clientHandler;
    }

    @Override
    public void accept(T msg, Supplier<NetworkEvent.Context> contextSupplier) {
        if (msg == null) {
            contextSupplier.get().setPacketHandled(true);
            return;
        }
        NetworkDirection networkDirection = contextSupplier.get().getDirection();
        if (this.clientHandler != null && networkDirection == NetworkDirection.PLAY_TO_CLIENT) {
            contextSupplier.get().enqueueWork(() -> this.clientHandler.handle((WorldMapMessage)msg));
        } else if (this.serverHandler != null && networkDirection == NetworkDirection.PLAY_TO_SERVER) {
            ServerPlayerEntity sender = contextSupplier.get().getSender();
            contextSupplier.get().enqueueWork(() -> this.serverHandler.handle(sender.func_184102_h(), sender, (WorldMapMessage)msg));
        }
        contextSupplier.get().setPacketHandled(true);
    }
}

