/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.blocks;

import com.ldtteam.storageracks.blocks.ModBlocks;
import com.ldtteam.storageracks.blocks.RackBlock;
import com.ldtteam.storageracks.blocks.RackType;
import com.ldtteam.structurize.api.blocks.IBlockList;
import com.ldtteam.structurize.api.generation.ModBlockStateProvider;
import com.ldtteam.structurize.api.generation.ModBlockTagsProvider;
import com.ldtteam.structurize.api.generation.ModItemModelProvider;
import com.ldtteam.structurize.api.generation.ModItemTagsProvider;
import com.ldtteam.structurize.api.generation.ModLanguageProvider;
import com.ldtteam.structurize.api.generation.ModRecipeProvider;
import com.ldtteam.structurize.blocks.types.WoodType;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;

public class RackList
implements IBlockList<RackBlock> {
    public List<RegistryObject<RackBlock>> getRegisteredBlocks() {
        return Collections.emptyList();
    }

    public void generateBlockStates(ModBlockStateProvider states) {
        ModBlocks.racks.forEach(block -> this.processStates(states, (RackBlock)((Object)block)));
    }

    public void processStates(ModBlockStateProvider states, RackBlock block) {
        states.getVariantBuilder((Block)block).forAllStates(state -> ConfiguredModel.builder().modelFile(this.getModel((BlockState)state, states, block)).build());
    }

    private ModelFile getModel(BlockState state, ModBlockStateProvider states, RackBlock block) {
        String variant = state.func_177229_b(RackBlock.VARIANT) == RackType.DEFAULT ? "empty" : "full";
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)states.models().getBuilder("block/racks/" + block.getRegistryName().func_110623_a() + variant)).parent((ModelFile)new ModelFile.UncheckedModelFile(states.modLoc("block/" + variant + "rack")))).texture("0", block.getWoodType() == WoodType.CACTUS ? "structurize:blocks/cactus/blockcactusplank" : "minecraft:block/" + block.getWoodType().getMaterial().getRegistryName().func_110623_a())).texture("1", "minecraft:block/" + block.getFrameType().getMaterial().getRegistryName().func_110623_a())).texture("particle", "minecraft:block/" + block.getFrameType().getMaterial().getRegistryName().func_110623_a());
    }

    public void generateItemModels(ModItemModelProvider models) {
        ModBlocks.racks.forEach(block -> ((ItemModelBuilder)((ItemModelBuilder)models.getBuilder(this.getRegistryPath((Block)block))).parent((ModelFile)new ModelFile.UncheckedModelFile(models.modLoc("block/racks/" + this.getRegistryPath((Block)block) + "empty")))).transforms().transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(45.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).rotation(45.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(0.0f, 45.0f, 0.0f).translation(0.0f, 1.75f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_LEFT).rotation(0.0f, 45.0f, 0.0f).translation(0.0f, 1.75f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ModelBuilder.Perspective.GROUND).rotation(0.0f, 3.0f, 0.0f).scale(0.25f, 0.25f, 0.25f).end().transform(ModelBuilder.Perspective.GUI).rotation(30.0f, 225.0f, 0.0f).translation(0.0f, 0.5f, 0.0f).scale(0.625f, 0.625f, 0.625f).end().transform(ModelBuilder.Perspective.FIXED).scale(0.6f, 0.6f, 0.6f).end());
    }

    public void generateRecipes(ModRecipeProvider provider) {
        ModBlocks.racks.forEach(block -> provider.add(consumer -> new ShapedRecipeBuilder((IItemProvider)block, 1).func_200472_a("FFF").func_200472_a("XCX").func_200472_a("FFF").func_200462_a(Character.valueOf('F'), (IItemProvider)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("minecraft", block.getWoodType().name().toLowerCase() + "_slab"))).func_200462_a(Character.valueOf('C'), (IItemProvider)block.getFrameType().getCost()).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151055_y).func_200465_a("has_" + block.getRegistryName().func_110623_a(), provider.getCriterion((IItemProvider)block)).func_200467_a(consumer, new ResourceLocation("storageracks", block.getRegistryName().func_110623_a()))));
        provider.add(consumer -> new ShapedRecipeBuilder((IItemProvider)ModBlocks.stoneController, 1).func_200472_a("SSS").func_200472_a("SPS").func_200472_a("SSS").func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_221712_br).func_200462_a(Character.valueOf('P'), (IItemProvider)Items.field_151121_aF).func_200465_a("has_" + ModBlocks.stoneController.getRegistryName().func_110623_a(), provider.getCriterion((IItemProvider)ModBlocks.stoneController)).func_200467_a(consumer, new ResourceLocation("storageracks", ModBlocks.stoneController.getRegistryName().func_110623_a())));
        provider.add(consumer -> new ShapedRecipeBuilder((IItemProvider)ModBlocks.ironController, 1).func_200472_a("SSS").func_200472_a("SPS").func_200472_a("SSS").func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151042_j).func_200462_a(Character.valueOf('P'), (IItemProvider)Items.field_151121_aF).func_200465_a("has_" + ModBlocks.ironController.getRegistryName().func_110623_a(), provider.getCriterion((IItemProvider)ModBlocks.ironController)).func_200467_a(consumer, new ResourceLocation("storageracks", ModBlocks.ironController.getRegistryName().func_110623_a())));
        provider.add(consumer -> new ShapedRecipeBuilder((IItemProvider)ModBlocks.emeraldController, 1).func_200472_a("SSS").func_200472_a("SPS").func_200472_a("SSS").func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151166_bC).func_200462_a(Character.valueOf('P'), (IItemProvider)Items.field_151121_aF).func_200465_a("has_" + ModBlocks.emeraldController.getRegistryName().func_110623_a(), provider.getCriterion((IItemProvider)ModBlocks.emeraldController)).func_200467_a(consumer, new ResourceLocation("storageracks", ModBlocks.emeraldController.getRegistryName().func_110623_a())));
        provider.add(consumer -> new ShapedRecipeBuilder((IItemProvider)ModBlocks.diamondController, 1).func_200472_a("SSS").func_200472_a("SPS").func_200472_a("SSS").func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151045_i).func_200462_a(Character.valueOf('P'), (IItemProvider)Items.field_151121_aF).func_200465_a("has_" + ModBlocks.diamondController.getRegistryName().func_110623_a(), provider.getCriterion((IItemProvider)ModBlocks.diamondController)).func_200467_a(consumer, new ResourceLocation("storageracks", ModBlocks.diamondController.getRegistryName().func_110623_a())));
    }

    public void generateTags(ModBlockTagsProvider blocks, ModItemTagsProvider items) {
    }

    public void generateTranslations(ModLanguageProvider lang) {
        lang.translate(ModBlocks.racks, block -> ModLanguageProvider.format((String)block.getWoodType().func_176610_l()) + " " + ModLanguageProvider.format((String)block.getFrameType().func_176610_l()) + " Rack");
    }
}

