/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.blocks;

import com.ldtteam.storageracks.blocks.FrameType;
import com.ldtteam.storageracks.blocks.RackType;
import com.ldtteam.storageracks.blocks.UpgradeableBlock;
import com.ldtteam.storageracks.tileentities.TileEntityRack;
import com.ldtteam.storageracks.utils.InventoryUtils;
import com.ldtteam.structurize.blocks.types.WoodType;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class RackBlock
extends UpgradeableBlock {
    public static final EnumProperty<RackType> VARIANT = EnumProperty.func_177709_a((String)"variant", RackType.class);
    private static final String BLOCK_NAME = "rack";
    private static final VoxelShape SHAPE = VoxelShapes.func_197873_a((double)0.1, (double)0.1, (double)0.1, (double)0.9, (double)0.9, (double)0.9);
    private final FrameType frameType;
    private final WoodType woodType;

    public RackBlock(WoodType wood, FrameType frame, Item upgradeMaterial) {
        super(upgradeMaterial);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(VARIANT, (Comparable)((Object)RackType.DEFAULT)));
        this.woodType = wood;
        this.frameType = frame;
        this.setRegistryName("storageracks".toLowerCase() + ":" + wood.func_176610_l() + "_" + frame.func_176610_l() + "_" + BLOCK_NAME);
    }

    public boolean func_200123_i(BlockState state, @NotNull IBlockReader reader, @NotNull BlockPos pos) {
        return true;
    }

    @NotNull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_220062_a(BlockState state, ServerWorld worldIn, BlockPos pos, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityRack) {
            IItemHandlerModifiable handler = ((TileEntityRack)tileentity).getInventory();
            InventoryUtils.dropItemHandler((IItemHandler)handler, (World)worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        super.func_220062_a(state, worldIn, pos, stack);
    }

    @NotNull
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityRack) {
            TileEntityRack rack = (TileEntityRack)tileEntity;
            if (!world.field_72995_K) {
                rack.checkForUpgrade(state, rack.getSize());
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)rack, buf -> buf.func_179255_a(rack.func_174877_v()));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{VARIANT});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityRack();
    }

    public void func_196243_a(BlockState state, @NotNull World worldIn, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof TileEntityRack) {
                TileEntityRack tileEntityRack = (TileEntityRack)tileEntity;
                InventoryUtils.dropItemHandler((IItemHandler)tileEntityRack.getInventory(), worldIn, tileEntityRack.func_174877_v().func_177958_n(), tileEntityRack.func_174877_v().func_177956_o(), tileEntityRack.func_174877_v().func_177952_p());
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public WoodType getWoodType() {
        return this.woodType;
    }

    public FrameType getFrameType() {
        return this.frameType;
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState newState, boolean bool) {
        super.func_220082_b(state, world, pos, newState, bool);
        if (!world.field_72995_K && state.func_177230_c() instanceof RackBlock) {
            ((TileEntityRack)world.func_175625_s(pos)).neighborChange();
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        boolean rem = super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        if (!world.field_72995_K && state.func_177230_c() instanceof RackBlock) {
            for (Direction direction : Direction.values()) {
                TileEntity te = world.func_175625_s(pos.func_177972_a(direction));
                if (!(te instanceof TileEntityRack)) continue;
                ((TileEntityRack)te).neighborChange();
            }
        }
        return rem;
    }
}

