/*
 * Decompiled with CFR 0.152.
 */
package com.kotakotik.createautomated.register;

import com.kotakotik.createautomated.register.ModBlocks;
import com.kotakotik.createautomated.register.ModItems;
import com.kotakotik.createautomated.register.RecipeItems;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.repack.registrate.providers.RegistrateLangProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class ModTooltips {
    public static CreateRegistrate reg;
    public final String key;
    public final String content;
    protected static HashMap<ResourceLocation, Integer> behaviors;
    protected static HashMap<ResourceLocation, Integer> conditions;
    protected static ArrayList<Consumer<CreateRegistrate>> onRegister;

    public static void register(CreateRegistrate registrate) {
        reg = registrate;
        ModTooltips.register((Item)ModItems.PICKER.get(), "A string that can be used to _pick tiny bits from materials_. Can be automatically applied using the Deployer.", "When used", "Picks from items held in the _offhand_ or lying on the _floor_ when _looking at them_");
        ModTooltips.registerSpongeSail((Block)ModBlocks.WET_SPONGE_SAIL.get(), "wash", "washing");
        ModTooltips.registerSpongeSail((Block)ModBlocks.LAVA_SPONGE_SAIL.get(), "blast", "blasting");
        ModTooltips.register((Block)ModBlocks.SPONGE_SAIL.get(), "A boring dry sponge. Try _splashing some water on it_!", new Pair[0]);
        ModTooltips.register((Item)RecipeItems.DRILL_HEAD.item.get(), "The most important component for _extracting_", new Pair[0]);
        onRegister.forEach((Consumer<Consumer<CreateRegistrate>>)((Consumer<Consumer>)c -> c.accept(reg)));
    }

    private static List<ModTooltips> registerSpongeSail(Block item, String type, String type_ing) {
        return ModTooltips.register(item, "A sail that can be used to _" + type + " without a fluid_", "When placed in front of a fan", "Converts the _flow_ to _" + type_ing + "_");
    }

    protected static String getTooltipKeyStart(String id, boolean isItem) {
        return (isItem ? "item." : "block.") + "createautomated" + "." + id + ".tooltip";
    }

    protected static String getTooltipKeyStart(Item item) {
        return ModTooltips.getTooltipKeyStart(Objects.requireNonNull(item.getRegistryName()).func_110623_a(), true);
    }

    protected static String getTooltipKeyStart(Block block) {
        return ModTooltips.getTooltipKeyStart(Objects.requireNonNull(block.getRegistryName()).func_110623_a(), false);
    }

    protected static ModTooltips registerTooltip(Item item, String suffix, String content) {
        return new ModTooltips(ModTooltips.getTooltipKeyStart(item) + "." + suffix, content);
    }

    protected static ModTooltips registerTooltip(Block block, String suffix, String content) {
        return new ModTooltips(ModTooltips.getTooltipKeyStart(block) + "." + suffix, content);
    }

    public TranslationTextComponent getComponent() {
        return new TranslationTextComponent(this.key);
    }

    public ModTooltips(String key, String content, boolean genLang) {
        if (genLang) {
            reg.addRawLang(key, content);
        }
        this.key = key;
        this.content = content;
    }

    public ModTooltips(String key, String content) {
        this(key, content, true);
    }

    public static ModTooltips registerMain(Item item, String name) {
        return new ModTooltips(ModTooltips.getTooltipKeyStart(item), name.toUpperCase());
    }

    public static ModTooltips registerMain(Item item) {
        return ModTooltips.registerMain(item, RegistrateLangProvider.toEnglishName((String)item.getRegistryName().func_110623_a()));
    }

    public static ModTooltips registerMain(Block item, String name) {
        return new ModTooltips(ModTooltips.getTooltipKeyStart(item), name.toUpperCase());
    }

    public static ModTooltips registerMain(Block item) {
        return ModTooltips.registerMain(item, RegistrateLangProvider.toEnglishName((String)item.getRegistryName().func_110623_a()));
    }

    public static ModTooltips registerSummary(Item item, String content) {
        return ModTooltips.registerTooltip(item, "summary", content);
    }

    public static ModTooltips registerSummary(Block item, String content) {
        return ModTooltips.registerTooltip(item, "summary", content);
    }

    public static ModTooltips registerBehavior(Item item, String content) {
        int b = behaviors.getOrDefault(item.getRegistryName(), 0) + 1;
        behaviors.put(item.getRegistryName(), b);
        return ModTooltips.registerTooltip(item, "behaviour" + b, content);
    }

    public static ModTooltips registerCondition(Item item, String content) {
        int b = conditions.getOrDefault(item.getRegistryName(), 0) + 1;
        conditions.put(item.getRegistryName(), b);
        return ModTooltips.registerTooltip(item, "condition" + b, content);
    }

    public static ModTooltips registerBehavior(Block item, String content) {
        int b = behaviors.getOrDefault(item.getRegistryName(), 0) + 1;
        behaviors.put(item.getRegistryName(), b);
        return ModTooltips.registerTooltip(item, "behaviour" + b, content);
    }

    public static ModTooltips registerCondition(Block item, String content) {
        int b = conditions.getOrDefault(item.getRegistryName(), 0) + 1;
        conditions.put(item.getRegistryName(), b);
        return ModTooltips.registerTooltip(item, "condition" + b, content);
    }

    @SafeVarargs
    public static List<ModTooltips> register(Item item, String summary, Pair<String, String> ... behaviors) {
        ArrayList<ModTooltips> list = new ArrayList<ModTooltips>();
        list.add(ModTooltips.registerMain(item));
        list.add(ModTooltips.registerSummary(item, summary));
        for (Pair<String, String> b : behaviors) {
            list.add(ModTooltips.registerCondition(item, (String)b.getFirst()));
            list.add(ModTooltips.registerBehavior(item, (String)b.getSecond()));
        }
        return list;
    }

    public static List<ModTooltips> register(Item item, String summary, String condition, String behavior) {
        return ModTooltips.register(item, summary, Pair.of((Object)condition, (Object)behavior));
    }

    @SafeVarargs
    public static List<ModTooltips> register(Block item, String summary, Pair<String, String> ... behaviors) {
        ArrayList<ModTooltips> list = new ArrayList<ModTooltips>();
        list.add(ModTooltips.registerMain(item));
        list.add(ModTooltips.registerSummary(item, summary));
        for (Pair<String, String> b : behaviors) {
            list.add(ModTooltips.registerCondition(item, (String)b.getFirst()));
            list.add(ModTooltips.registerBehavior(item, (String)b.getSecond()));
        }
        return list;
    }

    public static List<ModTooltips> register(Block item, String summary, String condition, String behavior) {
        return ModTooltips.register(item, summary, Pair.of((Object)condition, (Object)behavior));
    }

    public static void onRegister(Consumer<CreateRegistrate> consumer) {
        onRegister.add(consumer);
    }

    static {
        behaviors = new HashMap();
        conditions = new HashMap();
        onRegister = new ArrayList();
    }
}

