/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.easy_villagers.corelib.CachedMap;
import de.maxhenkel.easy_villagers.corelib.client.RenderUtils;
import de.maxhenkel.easy_villagers.corelib.helpers.Pair;
import de.maxhenkel.easyvillagers.blocks.TraderBlock;
import de.maxhenkel.easyvillagers.blocks.tileentity.TraderTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.TraderTileentityBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.VillagerRendererBase;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.GrindstoneBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.MobEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.registries.ForgeRegistries;

public class TraderRenderer
extends VillagerRendererBase<TraderTileentity> {
    private static final CachedMap<BlockState, Pair<TileEntityRenderer<TileEntity>, TileEntity>> tileEntityCache = new CachedMap(10000L);
    private static final CachedMap<Block, BlockState> blockStateCache = new CachedMap(10000L);
    public static final Map<ResourceLocation, ResourceLocation> TOP_BLOCKS = new HashMap<ResourceLocation, ResourceLocation>();
    private static final Map<Block, BlockState> TOP_BLOCK_CACHE = new HashMap<Block, BlockState>();

    public TraderRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    @Override
    public void render(TraderTileentity trader, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        super.render(trader, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
        TraderRenderer.renderTraderBase(this.villagerRenderer, trader, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
    }

    public static void renderTraderBase(VillagerRenderer renderer, TraderTileentityBase trader, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        matrixStack.func_227860_a_();
        Direction direction = Direction.SOUTH;
        if (!trader.isFakeWorld()) {
            direction = (Direction)trader.func_195044_w().func_177229_b((Property)TraderBlock.FACING);
        }
        if (trader.getVillagerEntity() != null) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 0.0625, 0.5);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-direction.func_185119_l()));
            matrixStack.func_227861_a_(0.0, 0.0, -0.25);
            matrixStack.func_227862_a_(0.45f, 0.45f, 0.45f);
            renderer.func_225623_a_((MobEntity)trader.getVillagerEntity(), 0.0f, 1.0f, matrixStack, buffer, combinedLight);
            matrixStack.func_227865_b_();
        }
        if (trader.hasWorkstation()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 0.0625, 0.5);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-direction.func_185119_l()));
            matrixStack.func_227861_a_(0.0, 0.0, 0.125);
            matrixStack.func_227861_a_(-0.5, 0.0, -0.5);
            matrixStack.func_227862_a_(0.45f, 0.45f, 0.45f);
            matrixStack.func_227861_a_(0.6111111111111112, 0.0, 0.6111111111111112);
            BlockState workstation = TraderRenderer.getState(trader.getWorkstation());
            TraderRenderer.renderBlock(workstation, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
            BlockState topBlock = TraderRenderer.getTopBlock(workstation);
            if (!topBlock.func_196958_f()) {
                matrixStack.func_227861_a_(0.0, 1.0, 0.0);
                TraderRenderer.renderBlock(topBlock, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
            }
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    public static void renderBlock(BlockState state, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (state.func_177230_c().func_149645_b(state) == BlockRenderType.MODEL) {
            BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
            int color = Minecraft.func_71410_x().func_184125_al().func_228054_a_(state, null, null, 0);
            RenderType renderType = RenderTypeLookup.func_239220_a_((BlockState)state, (boolean)false);
            dispatcher.func_175019_b().renderModel(matrixStack.func_227866_c_(), buffer.getBuffer(renderType), state, dispatcher.func_184389_a(state), (float)RenderUtils.getRed(color), (float)RenderUtils.getGreen(color), (float)RenderUtils.getBlue(color), combinedLight, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
        } else {
            Pair<TileEntityRenderer<TileEntity>, TileEntity> renderer = TraderRenderer.getRenderer(state);
            if (renderer != null) {
                renderer.getKey().func_225616_a_(renderer.getValue(), partialTicks, matrixStack, buffer, combinedLight, OverlayTexture.field_229196_a_);
            }
        }
    }

    public static BlockState getState(Block block) {
        return blockStateCache.get(block, () -> TraderRenderer.getFittingState(block));
    }

    public static Pair<TileEntityRenderer<TileEntity>, TileEntity> getRenderer(BlockState state) {
        return tileEntityCache.get(state, () -> {
            TileEntityRenderer renderer;
            TileEntity tileEntity = state.createTileEntity((IBlockReader)Minecraft.func_71410_x().field_71441_e);
            if (tileEntity != null && (renderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(tileEntity)) != null) {
                tileEntity.field_195045_e = state;
                return new Pair<TileEntityRenderer, TileEntity>(renderer, tileEntity);
            }
            return null;
        });
    }

    protected static BlockState getFittingState(Block block) {
        if (block == Blocks.field_222427_lP) {
            return (BlockState)block.func_176223_P().func_206870_a((Property)GrindstoneBlock.field_196366_M, (Comparable)AttachFace.FLOOR);
        }
        return block.func_176223_P();
    }

    protected static BlockState getTopBlock(BlockState bottom) {
        BlockState cached = TOP_BLOCK_CACHE.get(bottom.func_177230_c());
        if (cached != null) {
            return cached;
        }
        ResourceLocation resourceLocation = TOP_BLOCKS.get(bottom.func_177230_c().getRegistryName());
        if (resourceLocation == null) {
            BlockState state = Blocks.field_150350_a.func_176223_P();
            TOP_BLOCK_CACHE.put(bottom.func_177230_c(), state);
            return state;
        }
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
        if (b == null) {
            BlockState state = Blocks.field_150350_a.func_176223_P();
            TOP_BLOCK_CACHE.put(bottom.func_177230_c(), state);
            return state;
        }
        BlockState state = b.func_176223_P();
        TOP_BLOCK_CACHE.put(bottom.func_177230_c(), state);
        return state;
    }

    static {
        TOP_BLOCKS.put(new ResourceLocation("car", "gas_station"), new ResourceLocation("car", "gas_station_top"));
    }
}

