/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkEvent;
import quphoria.compactvoidminers.blocks.voidpump.TileEntityVoidPump;

public class CreateBucketPacket {
    private BlockPos blockPos;
    private FluidStack targetFluid;

    public CreateBucketPacket() {
    }

    public CreateBucketPacket(BlockPos blockPos, FluidStack targetFluid) {
        this.blockPos = blockPos;
        this.targetFluid = targetFluid;
    }

    public CreateBucketPacket(PacketBuffer buf) {
        this.decode(buf);
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.blockPos.func_177958_n());
        buf.writeInt(this.blockPos.func_177956_o());
        buf.writeInt(this.blockPos.func_177952_p());
        this.targetFluid.writeToPacket(buf);
    }

    public void decode(PacketBuffer buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.blockPos = new BlockPos(x, y, z);
        this.targetFluid = FluidStack.readFromPacket((PacketBuffer)buf);
    }

    public static void handle(CreateBucketPacket msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity serverPlayer = ((NetworkEvent.Context)context.get()).getSender();
            BlockPos pos = msg.getBlockPos();
            FluidStack fluid = msg.getFluidStack();
            World world = serverPlayer.field_70170_p;
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityVoidPump) {
                ((TileEntityVoidPump)tile).getFluidBucket(fluid, serverPlayer);
            }
        });
        context.get().setPacketHandled(true);
    }

    public FluidStack getFluidStack() {
        return this.targetFluid;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }
}

