/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.init;

import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import quphoria.compactvoidminers.config.Config;
import quphoria.compactvoidminers.init.ModBlocks;
import quphoria.compactvoidminers.init.ModContainerTypes;
import quphoria.compactvoidminers.init.ModItems;
import quphoria.compactvoidminers.init.ModTileEntityTypes;

public class Registration {
    public static final DeferredRegister<Block> BLOCKS = Registration.create(ForgeRegistries.BLOCKS);
    public static final DeferredRegister<ContainerType<?>> CONTAINERS = Registration.create(ForgeRegistries.CONTAINERS);
    public static final DeferredRegister<Item> ITEMS = Registration.create(ForgeRegistries.ITEMS);
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = Registration.create(ForgeRegistries.TILE_ENTITIES);

    public static void register() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(modEventBus);
        CONTAINERS.register(modEventBus);
        ITEMS.register(modEventBus);
        TILE_ENTITIES.register(modEventBus);
        Config.register();
        ModBlocks.register();
        ModContainerTypes.register();
        ModItems.register();
        ModTileEntityTypes.register();
    }

    private static <T extends IForgeRegistryEntry<T>> DeferredRegister<T> create(IForgeRegistry<T> registry) {
        return DeferredRegister.create(registry, (String)"compactvoidminers");
    }

    @Mod.EventBusSubscriber(modid="compactvoidminers", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Client {
        private Client() {
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ModContainerTypes.registerScreens(event);
        }
    }
}

