/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FluidRenderer {
    public static void renderTiledFluid(Minecraft mc, MatrixStack matrixStack, int x, int y, int width, int height, int depth, FluidStack fluidStack) {
        ResourceLocation stillTexture = fluidStack.getFluid().getAttributes().getStillTexture(fluidStack);
        TextureAtlasSprite fluidSprite = (TextureAtlasSprite)mc.func_228015_a_(PlayerContainer.field_226615_c_).apply(stillTexture);
        FluidRenderer.setColorRGBA(fluidStack.getFluid().getAttributes().getColor(fluidStack));
        AbstractGui.func_238470_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)width, (int)height, (int)depth, (TextureAtlasSprite)fluidSprite);
        FluidRenderer.renderTiledTextureAtlas(mc, x, y, width, height, depth, fluidSprite, fluidStack.getFluid().getAttributes().isGaseous(fluidStack));
    }

    public static void setColorRGBA(int color) {
        float a = (float)FluidRenderer.alpha(color) / 255.0f;
        float r = (float)FluidRenderer.red(color) / 255.0f;
        float g = (float)FluidRenderer.green(color) / 255.0f;
        float b = (float)FluidRenderer.blue(color) / 255.0f;
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
    }

    public static int alpha(int c) {
        return c >> 24 & 0xFF;
    }

    public static int red(int c) {
        return c >> 16 & 0xFF;
    }

    public static int green(int c) {
        return c >> 8 & 0xFF;
    }

    public static int blue(int c) {
        return c & 0xFF;
    }

    public static void renderTiledTextureAtlas(Minecraft mc, int x, int y, int width, int height, int depth, TextureAtlasSprite sprite, boolean upsideDown) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        mc.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        FluidRenderer.putTiledTextureQuads(worldrenderer, x, y, width, height, depth, sprite, upsideDown);
        tessellator.func_78381_a();
    }

    public static void putTiledTextureQuads(BufferBuilder renderer, int x, int y, int width, int height, int depth, TextureAtlasSprite sprite, boolean upsideDown) {
        float u1 = sprite.func_94209_e();
        float v1 = sprite.func_94206_g();
        do {
            int renderHeight = Math.min(sprite.func_94216_b(), height);
            height -= renderHeight;
            float v2 = sprite.func_94207_b((double)(16.0f * (float)renderHeight / (float)sprite.func_94216_b()));
            int x2 = x;
            int width2 = width;
            do {
                int renderWidth = Math.min(sprite.func_94211_a(), width2);
                width2 -= renderWidth;
                float u2 = sprite.func_94214_a((double)(16.0f * (float)renderWidth / (float)sprite.func_94211_a()));
                if (upsideDown) {
                    renderer.func_225582_a_((double)x2, (double)y, (double)depth).func_225583_a_(u2, v1).func_181675_d();
                    renderer.func_225582_a_((double)x2, (double)(y + renderHeight), (double)depth).func_225583_a_(u2, v2).func_181675_d();
                    renderer.func_225582_a_((double)(x2 + renderWidth), (double)(y + renderHeight), (double)depth).func_225583_a_(u1, v2).func_181675_d();
                    renderer.func_225582_a_((double)(x2 + renderWidth), (double)y, (double)depth).func_225583_a_(u1, v1).func_181675_d();
                } else {
                    renderer.func_225582_a_((double)x2, (double)y, (double)depth).func_225583_a_(u1, v1).func_181675_d();
                    renderer.func_225582_a_((double)x2, (double)(y + renderHeight), (double)depth).func_225583_a_(u1, v2).func_181675_d();
                    renderer.func_225582_a_((double)(x2 + renderWidth), (double)(y + renderHeight), (double)depth).func_225583_a_(u2, v2).func_181675_d();
                    renderer.func_225582_a_((double)(x2 + renderWidth), (double)y, (double)depth).func_225583_a_(u2, v1).func_181675_d();
                }
                x2 += renderWidth;
            } while (width2 > 0);
            y += renderHeight;
        } while (height > 0);
    }
}

