/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import quphoria.compactvoidminers.CompactVoidMiners;
import quphoria.compactvoidminers.config.SyncedServerModConfig;
import quphoria.compactvoidminers.init.ModItems;

public class Config {
    private static final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    public static final GeneralConfig general = new GeneralConfig(builder);
    public static final VoidMinerConfig voidminer = new VoidMinerConfig(builder);
    public static final VoidPumpConfig voidpump = new VoidPumpConfig(builder);
    public static ForgeConfigSpec spec = builder.build();

    public static void register() {
        ModContainer container = ModLoadingContext.get().getActiveContainer();
        SyncedServerModConfig config = new SyncedServerModConfig(spec, container, "compactvoidminers.toml");
        container.addConfig((ModConfig)config);
    }

    public static String createRegexFromGlob(String glob) {
        StringBuilder out = new StringBuilder("^");
        boolean invalid = false;
        boolean used_colon = false;
        block5: for (int i = 0; i < glob.length() && !invalid; ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    out.append(".*");
                    continue block5;
                }
                case '.': {
                    out.append("\\.");
                    continue block5;
                }
                case ':': {
                    out.append(':');
                    invalid = used_colon;
                    used_colon = true;
                    continue block5;
                }
                default: {
                    if (!Character.isLetterOrDigit(c) && c != '_' && c != '-') {
                        invalid = true;
                        continue block5;
                    }
                    out.append(Character.toLowerCase(c));
                }
            }
        }
        out.append('$');
        if (invalid) {
            CompactVoidMiners.LOGGER.error("Invalid Wildcard String:" + glob);
            return null;
        }
        return out.toString();
    }

    public static class VoidPumpConfig {
        public final ForgeConfigSpec.ConfigValue<List<String>> fluidPartialBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<String>> fluidExactBlacklist;

        public VoidPumpConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Void Pump");
            this.fluidPartialBlacklist = builder.comment("Void Pump Partial Fluid Blacklist (prefix fluid. not required) (case insensitive)").translation("compactvoidminers.config.voidpump.fluidpartial").define("Partial Fluid Blacklist", new ArrayList());
            this.fluidExactBlacklist = builder.comment("Void Pump Exact Fluid Blacklist (prefix fluid. not required) (case sensitive)").translation("compactvoidminers.config.voidpump.fluidexact").define("Exact Fluid Blacklist", new ArrayList());
            builder.pop();
        }
    }

    public static class VoidMinerConfig {
        public final ForgeConfigSpec.ConfigValue<List<String>> tagPartialBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<String>> tagExactBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<String>> itemBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<String>> itemWildcardBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> enabledTagPrefixes;
        private List<String> valid_prefixes = Arrays.asList(ModItems.filter_prefixes);
        public List<String> parsedItemWildcardBlacklist = new ArrayList<String>();

        public VoidMinerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Void Miner");
            builder.comment("To get an items tag / item id, use /cvm iteminfo while holding an item");
            this.tagPartialBlacklist = builder.comment("Void Miner Partial Tag Blacklist (case insensitive)").translation("compactvoidminers.config.voidminer.tagpartial").define("Partial Tag Blacklist", new ArrayList());
            this.tagExactBlacklist = builder.comment("Void Miner Exact Tag Blacklist (case sensitive)").translation("compactvoidminers.config.voidminer.tagexact").define("Exact Tag Blacklist", new ArrayList());
            this.itemBlacklist = builder.comment("Void Miner Item ID Blacklist (case insensitive) e.g. minecraft:stone").translation("compactvoidminers.config.voidminer.itemblacklist").define("Item Blacklist", new ArrayList());
            this.itemWildcardBlacklist = builder.comment("Void Miner Wildcard Item ID Blacklist (Wildcard: *) (case insensitive) e.g. mekanism:*").translation("compactvoidminers.config.voidminer.itemwildcardblacklist").define("Wildcard Item Blacklist", new ArrayList());
            this.enabledTagPrefixes = builder.comment("Void Miner Enabled Tag Filters/Prefixes (case sensitive)").comment("Valid prefixes: " + String.join((CharSequence)",", ModItems.filter_prefixes)).translation("compactvoidminers.config.voidminer.enabledprefixes").defineList("Enabled Filters/Prefixes", this.valid_prefixes, value -> this.valid_prefixes.contains(value));
            builder.pop();
        }

        public void parseItemWildcardBlacklist() {
            this.parsedItemWildcardBlacklist = new ArrayList<String>();
            CompactVoidMiners.LOGGER.info(((List)this.itemWildcardBlacklist.get()).toString());
            for (String wildcard : (List)this.itemWildcardBlacklist.get()) {
                String parsedWildcard = Config.createRegexFromGlob(wildcard);
                if (parsedWildcard == null || parsedWildcard.length() <= 0) continue;
                this.parsedItemWildcardBlacklist.add(parsedWildcard);
            }
        }
    }

    public static class GeneralConfig {
        public final ForgeConfigSpec.ConfigValue<Integer> maxMachineEnergyUsage;
        public final ForgeConfigSpec.ConfigValue<Double> energyUpgradeScale;
        public final ForgeConfigSpec.ConfigValue<Double> energySpeedUpgradeScale;
        public final ForgeConfigSpec.ConfigValue<Integer> speedUpgradeScale;
        public final ForgeConfigSpec.ConfigValue<Integer> chunkloaderRadius;

        public GeneralConfig(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.maxMachineEnergyUsage = builder.comment("Energy usage for machine with no upgrades [default:1024]").translation("compactvoidminers.config.energyusage").defineInRange("Base Machine Energy Usage", 1024, 1, 0x100000);
            this.energyUpgradeScale = builder.comment("Value to scale energy usage by with energy upgrades [default:1.3]").translation("compactvoidminers.config.energyscale").defineInRange("Machine Energy Usage Energy Upgrade Scale", (double)1.3f, 1.0, 4.0);
            this.energySpeedUpgradeScale = builder.comment("Value to scale energy usage by with speed upgrades [default:2]").translation("compactvoidminers.config.speedenergyscale").defineInRange("Machine Energy Usage Speed Upgrade Scale", 2.0, 1.0, 8.0);
            this.speedUpgradeScale = builder.comment("Value to scale collection speed with speed upgrades [default:5]").translation("compactvoidminers.config.speedscale").defineInRange("Machine Speed Upgrade Scale", 5, 1, 8);
            this.chunkloaderRadius = builder.comment("Chunkloader radius in Chunks [default:1]").translation("compactvoidminers.config.chunkloaderradius").defineInRange("Chunkloader Radius", 2, 0, 1);
            builder.pop();
        }
    }
}

