/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.blocks.voidpump;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import quphoria.compactvoidminers.blocks.ScreenMachine;
import quphoria.compactvoidminers.blocks.TileEntityMachine;
import quphoria.compactvoidminers.blocks.voidpump.ContainerVoidPump;
import quphoria.compactvoidminers.blocks.voidpump.TileEntityVoidPump;
import quphoria.compactvoidminers.gui.FluidRenderer;

public class ScreenVoidPump
extends ScreenMachine<ContainerVoidPump> {
    private ContainerVoidPump containerPump;
    protected Rectangle filterSlot = new Rectangle(152, 18, 16, 16);
    protected Rectangle filterSlotTooltip = new Rectangle(151, 17, 18, 18);
    protected int filterSlotDisabledTextureX = 176;
    protected int filterSlotDisabledTextureY = 10;
    protected Map<Rectangle, FluidStack> fluidBars = new HashMap<Rectangle, FluidStack>();

    public ScreenVoidPump(ContainerVoidPump container, PlayerInventory playerInv, ITextComponent title) {
        super(container, playerInv, title);
        this.containerPump = container;
        this.field_147000_g = 154;
        this.playerInv = playerInv;
        this.energyBar = new Rectangle(84, 28, 62, 6);
        this.progressBar = new Rectangle(84, 18, 62, 4);
        this.energyBarTextureX = 176;
        this.energyBarTextureY = 0;
        this.progressBarTextureX = 176;
        this.progressBarTextureY = 6;
        this.field_238744_r_ = 8;
        this.field_238745_s_ = 60;
        this.BG_TEXTURE = new ResourceLocation("compactvoidminers", "textures/gui/voidpump.png");
    }

    @Override
    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrix, partialTicks, mouseX, mouseY);
        if (this.field_230706_i_ == null) {
            return;
        }
        int x = (this.field_230708_k_ - this.field_146999_f) / 2;
        int y = (this.field_230709_l_ - this.field_147000_g) / 2;
        int fluid_x = 8;
        if (this.containerPump.tileEntity != null) {
            if (!((TileEntityMachine)((Object)this.container.tileEntity)).hasFilterUpgrade()) {
                this.func_238474_b_(matrix, x + this.filterSlot.x, y + this.filterSlot.y, this.filterSlotDisabledTextureX, this.filterSlotDisabledTextureY, this.filterSlot.width, this.filterSlot.height);
            }
            List<FluidStack> fluids = ((TileEntityVoidPump)this.containerPump.tileEntity).getFluids();
            this.fluidBars = new HashMap<Rectangle, FluidStack>();
            int max_width = 160 - 10 * fluids.size();
            for (FluidStack fluid : fluids) {
                int fluidWidth = 10 + (int)Math.floor(max_width * fluid.getAmount() / ((TileEntityVoidPump)this.containerPump.tileEntity).getFluidCapacity());
                FluidRenderer.renderTiledFluid(this.field_230706_i_, matrix, x + fluid_x, y + 40, fluidWidth, 16, 0, fluid);
                this.fluidBars.put(new Rectangle(fluid_x, 40, fluidWidth, 16), fluid);
                fluid_x += fluidWidth;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void drawTooltips(List<ITextComponent> tooltip, int mouseX, int mouseY) {
        if (this.field_230706_i_ == null) {
            return;
        }
        super.drawTooltips(tooltip, mouseX, mouseY);
        if (this.containerPump.tileEntity != null) {
            if (this.filterSlotTooltip.contains(mouseX, mouseY) && !((TileEntityMachine)((Object)this.container.tileEntity)).hasFilterUpgrade()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("gui.compactvoidminers.missing_filter_upgrade").func_240699_a_(TextFormatting.RED));
            }
            for (Rectangle fluidBar : this.fluidBars.keySet()) {
                if (!fluidBar.contains(mouseX, mouseY)) continue;
                FluidStack fluid = this.fluidBars.get(fluidBar);
                tooltip.add(fluid.getDisplayName());
                tooltip.add((ITextComponent)new StringTextComponent(this.addDigitGrouping(fluid.getAmount()) + "mB"));
                if (!this.field_230706_i_.field_71474_y.field_82882_x) continue;
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + fluid.getFluid().getRegistryName().toString()));
            }
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        int x = (this.field_230708_k_ - this.field_146999_f) / 2;
        int y = (this.field_230709_l_ - this.field_147000_g) / 2;
        if (mouseButton == 0 && this.containerPump != null) {
            for (Rectangle fluidBar : this.fluidBars.keySet()) {
                if (!fluidBar.contains(mouseX - (double)x, mouseY - (double)y)) continue;
                FluidStack fluid = this.fluidBars.get(fluidBar);
                this.containerPump.collectBucket(fluid);
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }
}

